"use strict";
/* eslint-disable import/no-deprecated */
Object.defineProperty(exports, "__esModule", { value: true });
exports.datetime = datetime;
exports.uri = uri;
exports.atUri = atUri;
exports.did = did;
exports.handle = handle;
exports.atIdentifier = atIdentifier;
exports.nsid = nsid;
exports.cid = cid;
exports.language = language;
exports.tid = tid;
exports.recordKey = recordKey;
const iso_datestring_validator_1 = require("iso-datestring-validator");
const cid_1 = require("multiformats/cid");
const common_web_1 = require("@atproto/common-web");
const syntax_1 = require("@atproto/syntax");
const types_1 = require("../types");
function datetime(path, value) {
    try {
        if (!(0, iso_datestring_validator_1.isValidISODateString)(value)) {
            throw new Error();
        }
    }
    catch {
        return {
            success: false,
            error: new types_1.ValidationError(`${path} must be an valid atproto datetime (both RFC-3339 and ISO-8601)`),
        };
    }
    return { success: true, value };
}
function uri(path, value) {
    const isUri = value.match(/^\w+:(?:\/\/)?[^\s/][^\s]*$/) !== null;
    if (!isUri) {
        return {
            success: false,
            error: new types_1.ValidationError(`${path} must be a uri`),
        };
    }
    return { success: true, value };
}
function atUri(path, value) {
    try {
        (0, syntax_1.ensureValidAtUri)(value);
    }
    catch {
        return {
            success: false,
            error: new types_1.ValidationError(`${path} must be a valid at-uri`),
        };
    }
    return { success: true, value };
}
function did(path, value) {
    try {
        (0, syntax_1.ensureValidDid)(value);
    }
    catch {
        return {
            success: false,
            error: new types_1.ValidationError(`${path} must be a valid did`),
        };
    }
    return { success: true, value };
}
function handle(path, value) {
    try {
        (0, syntax_1.ensureValidHandle)(value);
    }
    catch {
        return {
            success: false,
            error: new types_1.ValidationError(`${path} must be a valid handle`),
        };
    }
    return { success: true, value };
}
function atIdentifier(path, value) {
    // We can discriminate based on the "did:" prefix
    if (value.startsWith('did:')) {
        const didResult = did(path, value);
        if (didResult.success)
            return didResult;
    }
    else {
        const handleResult = handle(path, value);
        if (handleResult.success)
            return handleResult;
    }
    return {
        success: false,
        error: new types_1.ValidationError(`${path} must be a valid did or a handle`),
    };
}
function nsid(path, value) {
    if ((0, syntax_1.isValidNsid)(value)) {
        return {
            success: true,
            value,
        };
    }
    else {
        return {
            success: false,
            error: new types_1.ValidationError(`${path} must be a valid nsid`),
        };
    }
}
function cid(path, value) {
    try {
        cid_1.CID.parse(value);
    }
    catch {
        return {
            success: false,
            error: new types_1.ValidationError(`${path} must be a cid string`),
        };
    }
    return { success: true, value };
}
// The language format validates well-formed BCP 47 language tags: https://www.rfc-editor.org/info/bcp47
function language(path, value) {
    if ((0, common_web_1.validateLanguage)(value)) {
        return { success: true, value };
    }
    return {
        success: false,
        error: new types_1.ValidationError(`${path} must be a well-formed BCP 47 language tag`),
    };
}
function tid(path, value) {
    if ((0, syntax_1.isValidTid)(value)) {
        return { success: true, value };
    }
    return {
        success: false,
        error: new types_1.ValidationError(`${path} must be a valid TID`),
    };
}
function recordKey(path, value) {
    try {
        (0, syntax_1.ensureValidRecordKey)(value);
    }
    catch {
        return {
            success: false,
            error: new types_1.ValidationError(`${path} must be a valid Record Key`),
        };
    }
    return { success: true, value };
}
//# sourceMappingURL=formats.js.map