import { LexValue } from '@atproto/lex-data';
import { JsonValue } from './json.js';
export declare function lexStringify(input: LexValue): string;
export type LexParseOptions = {
    /**
     * Forbids the presence of invalid Lex values (e.g. non-integer numbers,
     * malformed $link, $bytes, blob objects, etc.)
     */
    strict?: boolean;
};
export declare function lexParse(input: string, options?: LexParseOptions): LexValue;
export declare function jsonToLex(value: JsonValue, options?: LexParseOptions): LexValue;
export declare function lexToJson(value: LexValue): JsonValue;
//# sourceMappingURL=lex-json.d.ts.map