export interface Checkable<T> {
    parse: (obj: unknown) => T;
    safeParse: (obj: unknown) => {
        success: true;
        data: T;
    } | {
        success: false;
        error: Error;
    };
}
export interface Def<T> {
    name: string;
    schema: Checkable<T>;
}
export declare const is: <T>(obj: unknown, def: Checkable<T>) => obj is T;
export declare const create: <T>(def: Checkable<T>) => (v: unknown) => v is T;
export declare const assure: <T>(def: Checkable<T>, obj: unknown) => T;
export declare const isObject: (obj: unknown) => obj is Record<string, unknown>;
//# sourceMappingURL=check.d.ts.map