import * as React from 'react';
import Svg, { Path, Ellipse, Circle } from 'react-native-svg';
const SvgComponent = (props) => (
	<Svg
		xmlns="http://www.w3.org/2000/svg"
		xmlSpace="preserve"
		style={{
			enableBackground: 'new 0 0 512 512',
		}}
		viewBox="0 0 512 512"
		{...props}
	>
		<Path
			d="M207.791 139.462v21.81H49.759v-21.81c0-10.524 8.528-19.052 19.052-19.052h119.927c10.524 0 19.053 8.528 19.053 19.052z"
			style={{
				fill: '#65e1e9',
			}}
		/>
		<Path
			d="M207.791 161.272v80.1c0 10.524-8.529 19.052-19.052 19.052H68.811c-10.524 0-19.052-8.528-19.052-19.052v-80.1h158.032z"
			style={{
				fill: '#fff',
			}}
		/>
		<Path
			d="M188.738 114.899H68.82c-13.545 0-24.565 11.02-24.565 24.565v101.915c0 13.545 11.02 24.565 24.565 24.565h119.918c13.546 0 24.566-11.02 24.566-24.565V139.464c0-13.545-11.02-24.565-24.566-24.565zM68.82 125.921h119.918c7.468 0 13.544 6.076 13.544 13.543v16.305H55.277v-16.305c0-7.467 6.076-13.543 13.543-13.543zm119.918 129.001H68.82c-7.467 0-13.543-6.076-13.543-13.543v-74.588h147.005v74.588c0 7.467-6.076 13.543-13.544 13.543z"
			style={{
				fill: '#00d4d7',
			}}
		/>
		<Ellipse
			cx={73.615}
			cy={141.77}
			rx={9.953}
			ry={9.788}
			style={{
				fill: '#fff',
			}}
		/>
		<Ellipse
			cx={104.75}
			cy={141.77}
			rx={9.953}
			ry={9.788}
			style={{
				fill: '#fff',
			}}
		/>
		<Path
			d="M478.147 148.172c13.487-7.946 11.603-22.365.922-38.187 8.237-9.048 14.369-22.114 6.684-38.497-12.966-27.595-51.073-36.974-78.758-19.299-9.549-4.629-19.138-8.317-28.267-10.671-15.01-3.878-32.866-5.211-50.752-4.419-15.12-30.04-53.898-40.942-79.039-22.746-14.229 10.281-15.551 24.148-13.016 35.852 1.253 5.812 3.457 11.092 5.491 15.12-4.94 6.373-5.892 13.587-1.283 21.403 0 0-63.357 28.116-32.205 55.511 0 0-7.936 4.659-15.651 13.838-4.018 4.759-7.986 10.741-10.712 17.916-.201.461-.371.912-.541 1.393-3.928 11.012-4.97 24.74.732 41.062 2.415 6.864 5.401 12.906 8.858 18.227 31.463 48.568 95.141 57.445 95.141 57.445s17.422 8.568 42.736 15.43c-9.01 13.1-14.419 29.828-14.419 48.059 0 42.001 28.68 76.05 64.058 76.05 35.378 0 64.058-34.049 64.058-76.05 0-17.156-4.789-32.983-12.862-45.707 13.08-4.078 25.685-10.469 37.101-19.966 22.866-19.028 23.627-41.984 20.211-57.956-1.834-8.637-4.88-15.22-6.333-18.056a28.733 28.733 0 0 0-.802-1.503c-.01-.02-.03-.05-.04-.07l-.01-.02c40.511-8.898-1.302-64.159-1.302-64.159z"
			style={{
				fill: '#ffd5ae',
			}}
		/>
		<Path
			d="M279.347 44.664c-17.295 4.93-31.263 12.024-37.936 20.662-2.034-4.028-4.238-9.309-5.491-15.12.641-8.096 4.098-15.571 13.297-19.179 12.836-5.021 23.076 3.657 30.13 13.637zM466.421 289.935c-68.794 57.231-180.666 2.19-180.666 2.19s-79.634-6.113-104-75.676c-5.706-16.321-4.666-30.053-.734-41.058 13.47 13.558 36.389 22.363 61.22 21.097 23.631-1.233 43.795-39.664 70.614-32.741 26.819 6.923 26.489 49.364 45.942 62.829 69.681 48.191 112.777 27.901 127.837 5.405 3.412 15.973 2.658 38.929-20.213 57.954z"
			style={{
				fill: '#fff1e6',
			}}
		/>
		<Path
			d="M322.624 229.004c-.1.371-.2.731-.311 1.092a40.24 40.24 0 0 1-3.828 8.848c-6.182 10.561-16.553 16.844-26.754 15.631a21.106 21.106 0 0 1-3.016-.581 17.175 17.175 0 0 1-2.335-.792c-12.465-4.96-18.878-21.283-14.409-37.866 4.75-17.575 18.277-22.605 32.255-18.828 13.989 3.778 23.148 14.911 18.398 32.496z"
			style={{
				fill: '#605c5d',
			}}
		/>
		<Path
			d="M322.314 230.096a40.24 40.24 0 0 1-3.828 8.848c-6.182 10.561-16.553 16.844-26.754 15.631.03-.16.07-.321.11-.481 4.288-17.706 15.331-30.221 24.65-27.956 2.265.561 4.228 1.934 5.822 3.958z"
			style={{
				fill: '#fd80a6',
			}}
		/>
		<Path
			d="M294.307 260.256a26.89 26.89 0 0 1-7.024-.933c-8.42-2.271-15.174-8.41-19.017-17.286-3.655-8.442-4.226-18.433-1.61-28.134.989-3.669 2.365-7.005 4.089-9.914l9.482 5.619c-1.214 2.049-2.2 4.46-2.929 7.165-1.971 7.305-1.586 14.721 1.082 20.885 2.481 5.73 6.662 9.645 11.773 11.024 5.111 1.378 10.693.099 15.72-3.606 5.407-3.985 9.47-10.202 11.44-17.505.73-2.706 1.091-5.287 1.073-7.669l11.022-.084c.026 3.379-.463 6.953-1.452 10.623-2.618 9.702-8.137 18.05-15.543 23.508-5.644 4.159-11.889 6.307-18.106 6.307z"
			style={{
				fill: '#ffd5ae',
			}}
		/>
		<Path
			d="m310.894 192.969 2.633-9.757-10.642-2.871-2.633 9.757c-12.493-1.598-23.278 3.381-29.505 13.891a5.51 5.51 0 1 0 9.482 5.619c6.169-10.409 16.789-9.347 22.569-7.788 5.781 1.56 15.494 5.983 15.59 18.083a5.51 5.51 0 0 0 5.51 5.468h.045a5.511 5.511 0 0 0 5.467-5.555c-.098-12.217-6.916-21.944-18.516-26.847z"
			style={{
				fill: '#e2ab8c',
			}}
		/>
		<Path
			d="M235.091 208.299c-5.095 19.735-23.431 32.072-40.969 27.544a25.789 25.789 0 0 1-3.516-1.17c-3.456-5.316-6.441-11.359-8.851-18.225-5.706-16.321-4.666-30.053-.734-41.058.165-.482.344-.941.542-1.395 8.187-8.473 19.775-12.512 31.007-9.612 17.537 4.528 27.611 24.2 22.521 43.916z"
			style={{
				fill: '#ff9eb6',
			}}
		/>
		<Circle
			cx={395.068}
			cy={249.605}
			r={36.898}
			style={{
				fill: '#ff9eb6',
			}}
			transform="rotate(-86.256 395.05 249.597)"
		/>
		<Path
			d="M377.428 207.58c2.54-9.838-2.069-19.535-10.293-21.658-8.224-2.123-16.95 4.131-19.49 13.97-2.54 9.838 2.069 19.535 10.293 21.658 8.224 2.123 16.95-4.131 19.49-13.97zM264.908 178.534c2.54-9.838-2.069-19.535-10.293-21.658-8.224-2.123-16.951 4.131-19.49 13.97-2.54 9.838 2.069 19.535 10.293 21.658 8.224 2.122 16.95-4.132 19.49-13.97z"
			style={{
				fill: '#605c5d',
			}}
		/>
		<Path
			d="M319.075 177.5a6.255 6.255 0 0 0-8.551-2.266l-.722.42-.419-.722a6.255 6.255 0 1 0-10.817 6.285l1.49 2.565c2.88 4.956 9.232 6.64 14.188 3.76l2.565-1.49a6.256 6.256 0 0 0 2.266-8.552z"
			style={{
				fill: '#fd80a6',
			}}
		/>
		<Path
			d="m446.176 110.29-19.677-16.552c-5.927-4.986-5.002-14.399 1.811-18.082 11.507-6.219 26.284-10.384 35.871 1.17 8.933 10.755 4.058 22.727-2.945 31.931-3.602 4.735-10.507 5.363-15.06 1.533z"
			style={{
				fill: '#fff1e6',
			}}
		/>
		<Path
			d="M485.778 149.385c3.54-3.225 5.836-7.135 6.848-11.679 1.747-7.85-.526-17.014-6.741-27.281 9.628-12.524 11.546-27.024 4.851-41.275-7.738-16.472-24.022-27.994-43.558-30.819-14.204-2.053-28.383.747-40.468 7.633-9.226-4.312-18.171-7.611-26.599-9.786-14.033-3.623-31.124-5.205-48.897-4.712-8.608-14.882-22.968-25.639-39.901-29.751-16.316-3.962-32.934-.981-45.588 8.179-17.148 12.398-20.946 32.304-10.655 54.949-3.625 6.078-4.364 12.699-2.184 19.244-11.163 5.662-35.999 20.194-38.819 38.617-.735 4.798-.184 11.577 5.471 18.711-4.275 3.36-10.31 8.86-15.618 16.482-8.649 12.42-16.948 32.975-7.362 60.367 13.658 38.993 43.957 58.708 66.97 68.38l4.27-10.161c-20.953-8.807-48.517-26.688-60.838-61.861-15.321-43.78 22.17-66.696 23.762-67.644a5.512 5.512 0 0 0 .843-8.888c-5.16-4.538-7.32-9.023-6.605-13.713 2.145-14.059 27.732-28.312 37.408-32.616a5.51 5.51 0 0 0 2.512-7.838c-3.172-5.376-2.942-10.148.723-15.018 16.181-21.499 87.596-33.455 131.753-22.056 6.03 1.557 12.377 3.748 18.94 6.529a63.758 63.758 0 0 0-5.611 5.577 5.51 5.51 0 1 0 8.239 7.321c11.729-13.2 29.178-19.568 46.678-17.038 15.857 2.293 29.002 11.489 35.159 24.597 9.953 21.186-7.501 36.062-18.792 43.044a5.51 5.51 0 0 0 2.903 10.199c.989 0 1.99-.267 2.893-.825 3.789-2.343 7.195-4.845 10.207-7.476 3.517 6.53 4.865 12.172 3.894 16.533-.736 3.305-2.867 5.958-6.516 8.109a5.516 5.516 0 0 0-1.598 8.071c6.382 8.45 21.863 33.302 16.933 46.643-1.645 4.451-5.708 7.331-12.421 8.804a5.513 5.513 0 0 0-3.864 3.177 5.526 5.526 0 0 0 .294 4.998c.039.068.298.519.699 1.301 4.934 9.707 18.613 43.391-12.497 69.279-22.922 19.069-53.507 27.183-90.902 24.116l-.9 10.985c5.455.448 10.777.671 15.971.671 12.901 0 24.975-1.397 36.21-4.145 4.734 8.005 15.998 31.274 9.704 63.059a5.51 5.51 0 1 0 10.812 2.14c6.508-32.868-3.535-57.335-9.613-68.393 13.276-4.551 25.23-11.197 35.766-19.962 16.062-13.365 24.249-30.779 23.678-50.36-.343-11.786-3.789-21.976-6.429-28.141 8.392-3.507 12.153-9.168 13.832-13.721 6.451-17.473-8.219-42.189-15.247-52.556zM298.392 34.705c-24.357 4.192-43.792 11.665-55.18 21.014-7.222-19.623.567-30.818 8.972-36.895 10.038-7.266 23.352-9.597 36.527-6.399 12.093 2.937 22.591 9.968 29.806 19.748a229.93 229.93 0 0 0-20.125 2.532z"
			style={{
				fill: '#e2ab8c',
			}}
		/>
		<Path
			d="M318.045 255.608H82.106c-13.751 0-24.899 11.148-24.899 24.899v162.758c0 13.751 11.147 24.899 24.899 24.899h235.939c13.751 0 24.899-11.148 24.899-24.899V280.507c0-13.751-11.148-24.899-24.899-24.899z"
			style={{
				fill: '#91a2b5',
			}}
		/>
		<Path
			d="M318.044 473.676H82.106c-16.768 0-30.411-13.642-30.411-30.41V280.507c0-16.768 13.643-30.41 30.411-30.41h235.938c16.768 0 30.411 13.642 30.411 30.41v162.758c0 16.768-13.642 30.411-30.411 30.411zM82.106 261.119c-10.69 0-19.389 8.698-19.389 19.388v162.758c0 10.69 8.698 19.388 19.389 19.388h235.938c10.69 0 19.388-8.698 19.388-19.388V280.507c0-10.69-8.698-19.388-19.388-19.388H82.106z"
			style={{
				fill: '#678490',
			}}
		/>
		<Path
			d="M321.263 289.354v126.395c0 6.667-5.402 12.051-12.069 12.051H90.949c-6.667 0-12.069-5.384-12.069-12.051V289.354c0-6.667 5.402-12.069 12.069-12.069h218.245c6.666 0 12.069 5.402 12.069 12.069z"
			style={{
				fill: '#ffff9d',
			}}
		/>
		<Path
			d="M309.2 433.318H90.949c-9.69 0-17.573-7.883-17.573-17.573V289.35c0-9.69 7.883-17.573 17.573-17.573h218.252c9.69 0 17.573 7.884 17.573 17.573v126.394c.001 9.691-7.883 17.574-17.574 17.574zM90.949 282.799a6.558 6.558 0 0 0-6.551 6.551v126.395a6.558 6.558 0 0 0 6.551 6.551H309.2a6.56 6.56 0 0 0 6.552-6.552V289.35a6.558 6.558 0 0 0-6.551-6.551H90.949z"
			style={{
				fill: '#678490',
			}}
		/>
		<Path
			d="M255.127 506.489H145.024c-11.899 0-16.869-15.21-7.266-22.236l21.99-16.089h80.653l21.99 16.089c9.605 7.026 4.635 22.236-7.264 22.236z"
			style={{
				fill: '#91a2b5',
			}}
		/>
		<Path
			d="M255.126 512H145.023c-7.85 0-14.497-4.821-16.934-12.282-2.438-7.461.08-15.277 6.415-19.912l21.99-16.089a5.512 5.512 0 0 1 3.255-1.063h80.653c1.17 0 2.309.372 3.254 1.063l21.992 16.089c6.335 4.635 8.854 12.45 6.415 19.911-2.439 7.462-9.087 12.283-16.937 12.283zm-93.577-38.324-20.536 15.026c-3.69 2.699-2.805 6.494-2.446 7.593.359 1.099 1.886 4.684 6.457 4.684h110.103c4.573 0 6.099-3.585 6.458-4.684.359-1.098 1.244-4.893-2.445-7.592l-20.538-15.026h-77.053z"
			style={{
				fill: '#678490',
			}}
		/>
		<Path
			d="M386.028 327.658c-.182-42.327-12.508-68.86-58.203-54.445-30.603 9.655-23.885 56.086 24.899 44.918 0 0-8.841 74.302 42.079 67.835 19.123-2.428 24.385-22.419 23.492-46.46l-32.267-11.848z"
			style={{
				fill: '#ffd5ae',
			}}
		/>
		<Path
			d="M192.755 204.059v21.81H34.724v-21.81c0-10.524 8.528-19.052 19.052-19.052h119.927c10.524 0 19.052 8.528 19.052 19.052z"
			style={{
				fill: '#93f6f8',
			}}
		/>
		<Path
			d="M192.755 225.869v80.1c0 10.524-8.529 19.052-19.052 19.052H53.776c-10.524 0-19.052-8.528-19.052-19.052v-80.1h158.031z"
			style={{
				fill: '#fd80a6',
			}}
		/>
		<Path
			d="M173.703 179.496H53.785c-13.546 0-24.566 11.02-24.566 24.565v101.914c0 13.546 11.02 24.566 24.566 24.566h119.918c13.546 0 24.566-11.02 24.566-24.566V204.061c0-13.545-11.02-24.565-24.566-24.565zM53.785 190.518h119.918c7.468 0 13.544 6.076 13.544 13.543v16.305H40.241v-16.305c0-7.467 6.075-13.543 13.544-13.543zM173.703 319.52H53.785c-7.468 0-13.544-6.076-13.544-13.544v-74.587h147.006v74.587c0 7.468-6.076 13.544-13.544 13.544z"
			style={{
				fill: '#00d4d7',
			}}
		/>
		<Path
			d="M68.533 206.367c0 5.406-4.456 9.788-9.953 9.788-5.497 0-9.953-4.383-9.953-9.788 0-5.406 4.456-9.788 9.953-9.788 5.497 0 9.953 4.382 9.953 9.788z"
			style={{
				fill: '#fff',
			}}
		/>
		<Ellipse
			cx={89.715}
			cy={206.367}
			rx={9.953}
			ry={9.788}
			style={{
				fill: '#fff',
			}}
		/>
		<Path
			d="M251.919 229.14v21.81H93.888v-21.81c0-10.524 8.528-19.052 19.052-19.052h119.927c10.523 0 19.052 8.529 19.052 19.052z"
			style={{
				fill: '#65e1e9',
			}}
		/>
		<Path
			d="M251.919 250.951v80.1c0 10.524-8.529 19.052-19.052 19.052H112.94c-10.524 0-19.052-8.528-19.052-19.052v-80.1h158.031z"
			style={{
				fill: '#fff',
			}}
		/>
		<Path
			d="M232.867 204.577H112.948c-13.546 0-24.566 11.02-24.566 24.565v101.915c0 13.545 11.02 24.565 24.566 24.565h119.918c13.546 0 24.566-11.02 24.566-24.565V229.143c.001-13.545-11.02-24.566-24.565-24.566zM112.948 215.6h119.918c7.468 0 13.544 6.076 13.544 13.543v16.305H99.404v-16.305c0-7.468 6.076-13.543 13.544-13.543zm119.919 129.001H112.948c-7.468 0-13.544-6.076-13.544-13.543V256.47H246.41v74.588c0 7.467-6.075 13.543-13.543 13.543z"
			style={{
				fill: '#00d4d7',
			}}
		/>
		<Path
			d="M127.696 231.448c0 5.406-4.456 9.789-9.953 9.789s-9.953-4.383-9.953-9.789 4.456-9.788 9.953-9.788 9.953 4.382 9.953 9.788zM158.831 231.448c0 5.406-4.456 9.789-9.953 9.789s-9.953-4.383-9.953-9.789 4.456-9.788 9.953-9.788 9.953 4.382 9.953 9.788z"
			style={{
				fill: '#fff',
			}}
		/>
		<Path
			d="M290.811 287.045v21.81H132.78v-21.81c0-10.524 8.528-19.052 19.052-19.052h119.927c10.523 0 19.052 8.528 19.052 19.052z"
			style={{
				fill: '#93f6f8',
			}}
		/>
		<Path
			d="M290.811 308.855v80.1c0 10.524-8.528 19.052-19.052 19.052H151.832c-10.524 0-19.052-8.528-19.052-19.052v-80.1h158.031z"
			style={{
				fill: '#fd80a6',
			}}
		/>
		<Path
			d="M271.759 262.482H151.84c-13.545 0-24.565 11.02-24.565 24.566v101.915c0 13.545 11.02 24.565 24.565 24.565h119.919c13.545 0 24.565-11.02 24.565-24.565V287.048c0-13.546-11.02-24.566-24.565-24.566zM151.84 273.504h119.919c7.467 0 13.543 6.076 13.543 13.544v16.305H138.297v-16.305c0-7.468 6.076-13.544 13.543-13.544zm119.919 129.001H151.84c-7.467 0-13.543-6.076-13.543-13.543v-74.588h147.005v74.588c0 7.468-6.076 13.543-13.543 13.543z"
			style={{
				fill: '#00d4d7',
			}}
		/>
		<Path
			d="M166.589 289.353c0 5.406-4.456 9.789-9.953 9.789-5.497 0-9.953-4.382-9.953-9.789 0-5.406 4.456-9.788 9.953-9.788 5.496 0 9.953 4.382 9.953 9.788zM197.723 289.353c0 5.406-4.456 9.789-9.953 9.789-5.497 0-9.953-4.382-9.953-9.789 0-5.406 4.456-9.788 9.953-9.788 5.497 0 9.953 4.382 9.953 9.788zM219.589 358.431l14.128-14.128a5.51 5.51 0 1 0-7.793-7.794l-14.128 14.128-14.128-14.128a5.51 5.51 0 1 0-7.793 7.794l14.128 14.128-14.128 14.128a5.51 5.51 0 0 0 3.896 9.408 5.49 5.49 0 0 0 3.896-1.614l14.128-14.129 14.128 14.129a5.49 5.49 0 0 0 3.896 1.614 5.51 5.51 0 0 0 3.896-9.408l-14.126-14.128z"
			style={{
				fill: '#fff',
			}}
		/>
		<Path
			d="M172.908 325.726v21.81H14.877v-21.81c0-10.524 8.528-19.052 19.052-19.052h119.927c10.524 0 19.052 8.528 19.052 19.052z"
			style={{
				fill: '#65e1e9',
			}}
		/>
		<Path
			d="M172.908 347.536v80.1c0 10.524-8.528 19.052-19.052 19.052H33.929c-10.524 0-19.052-8.528-19.052-19.052v-80.1h158.031z"
			style={{
				fill: '#fff',
			}}
		/>
		<Path
			d="M153.856 301.163H33.937c-13.545 0-24.565 11.02-24.565 24.565v101.915c0 13.545 11.02 24.565 24.565 24.565h119.918c13.546 0 24.566-11.02 24.566-24.565V325.728c0-13.545-11.02-24.565-24.565-24.565zM33.937 312.185h119.918c7.468 0 13.544 6.076 13.544 13.543v16.305H20.394v-16.305c0-7.467 6.076-13.543 13.543-13.543zm119.919 129.001H33.937c-7.467 0-13.543-6.076-13.543-13.543v-74.588h147.005v74.588c0 7.467-6.075 13.543-13.543 13.543z"
			style={{
				fill: '#00d4d7',
			}}
		/>
		<Ellipse
			cx={38.733}
			cy={328.034}
			rx={9.953}
			ry={9.788}
			style={{
				fill: '#fff',
			}}
		/>
		<Path
			d="M79.821 328.034c0 5.406-4.456 9.788-9.953 9.788-5.497 0-9.953-4.383-9.953-9.788 0-5.406 4.456-9.788 9.953-9.788 5.497 0 9.953 4.382 9.953 9.788z"
			style={{
				fill: '#fff',
			}}
		/>
		<Path
			d="M90.208 405.56c-1.005-.969-1.646-2.354-1.922-4.156l-5.402-32.311c-.492-3.323.547-7.049 3.065-8.987 6.476-5.441 19.462-2.419 19.063 7.428 0 .693-.035 1.247-.104 1.662l-5.506 32.207c-.231 4.895-5.654 7.453-9.194 4.157zm-3.534 23.377c-6.152-6.182-1.839-17.524 7.221-17.246 5.577-.122 10.09 4.531 9.974 10.077.221 9.073-11.011 13.424-17.195 7.169z"
			style={{
				fill: '#fe518e',
			}}
		/>
		<Path
			d="M388.697 391.88c-10.553.001-19.356-3.439-26.238-10.268-15.385-15.263-16.278-43.45-15.737-56.804-9.901 1.283-18.747.281-25.893-2.975-8.17-3.723-13.878-10.222-16.072-18.297-4.113-15.135 5.091-30.43 21.41-35.578 20.221-6.38 35.415-5.567 46.449 2.486 12.783 9.328 18.795 27.501 18.923 57.191a5.51 5.51 0 0 1-5.487 5.534h-.025a5.511 5.511 0 0 1-5.51-5.488c-.11-25.534-4.819-41.344-14.398-48.335-7.895-5.761-20.22-6.056-36.636-.878-12.163 3.837-16.294 14.061-14.089 22.177 2.404 8.85 13.302 17.333 36.101 12.114a5.509 5.509 0 0 1 6.703 6.023c-.045.382-4.35 38.782 12.037 55.017 5.858 5.805 13.665 7.994 23.875 6.7 7.047-.895 11.777-4.66 14.888-11.847 2.973-6.871 4.249-16.608 3.791-28.941a5.51 5.51 0 0 1 5.303-5.712c3.008-.122 5.598 2.261 5.712 5.303.818 22.038-3.429 48.972-28.305 52.132-2.342.297-4.61.446-6.802.446z"
			style={{
				fill: '#e2ab8c',
			}}
		/>
		<Path
			d="M167.865 168.909c18.545 1.061 33.206 8.429 32.145 26.974s-16.956 32.719-35.501 31.657c-18.545-1.061-32.719-16.955-31.657-35.501 1.061-18.545 16.468-24.192 35.013-23.13z"
			style={{
				fill: '#ffd5ae',
			}}
		/>
		<Path
			d="M166.481 233.107c-.759 0-1.522-.022-2.287-.065-21.549-1.234-38.077-19.768-36.845-41.318 1.113-19.417 15.993-29.74 40.831-28.318 24.836 1.422 38.443 13.374 37.332 32.791-.597 10.439-5.223 20.02-13.028 26.979-7.232 6.45-16.39 9.931-26.003 9.931zm-2.979-58.816c-16.008 0-24.461 6.065-25.148 18.064-.885 15.482 10.989 28.798 26.471 29.684a27.961 27.961 0 0 0 20.324-7.087c5.606-5 8.93-11.883 9.359-19.383.743-12.973-8.327-20.091-26.957-21.157a70.16 70.16 0 0 0-4.049-.121z"
			style={{
				fill: '#e2ab8c',
			}}
		/>
	</Svg>
);
export default SvgComponent;
