import Svg, { Path, Circle, G } from 'react-native-svg';

export function WoodenDirectionSign(props: any) {
	return (
		<Svg
			viewBox="0 0 453.543 453.543"
			xmlns="http://www.w3.org/2000/svg"
			{...props}
		>
			<Path
				d="M180.786 450.675L140.302 64.497l74.642-61.742 82.233 66.803-11.387 381.117z"
				fill="#b25d32"
			/>
			<Path
				d="M45.683 201.878v-89.352l317.986-14.533 62.843 66.467-62.843 54.643zM407.861 263.725v89.352L89.874 367.61l-62.843-66.467 62.843-54.642z"
				fill="#ff9357"
			/>
			<Path
				d="M164.77 297.992l16.016 152.773H285.79l2.819-94.327c-44.969-10.097-88.614-29.296-123.839-58.446z"
				fill="#8e4c28"
			/>
			<Path
				d="M84.011 110.865l-38.327 1.752v89.352l53.229 2.884c-10.569-29.722-15.016-61.823-14.902-93.988zM121.83 250.843c-.578-.861-1.114-1.743-1.677-2.612l-30.279-1.64-62.843 54.643 62.843 66.467 207.201-9.47c-68.892-13.682-135.748-48.485-175.245-107.388z"
				fill="#fc7530"
			/>
			<Path
				d="M226.772 157.482a9.325 9.325 0 11-18.651 0 9.325 9.325 0 019.325-9.325 9.325 9.325 0 019.326 9.325z"
				fill="#412945"
			/>
			<Circle cx={220.918} cy={307.146} fill="#412945" r={9.326} />
			<G fill="#fff">
				<Path d="M368.912 162.995l3.45-5.817 6.93-1.034-4.672-1.361 4.905-5.458-5.896 1.725-1.782-6.368-2.13 7.307-4.287-1.121 3.005 3.736-3.833 3.561 4.975-1.019zM365.11 120.814l-12.801 6.7-13.756-5.898 6.963 7.719-15.042 4.414 12.653 3.483-3.907 13.575 12.073-10.89 6.535 6.848-1.269-10.162 10.962-2.171-10.186-3.734zM90.494 262.067l-37.935 31.865-5.461 4.587c-1.201 1.009-.97 2.964 0 4.006l40.996 44.032 5.871 6.306c2.49 2.674 6.49-1.339 4.006-4.006l-40.995-44.032-5.871-6.306v4.006L89.04 270.66l5.46-4.587c2.796-2.348-1.23-6.338-4.006-4.006zM183.767 372.553l4.34 55.175.615 7.821c.284 3.611 5.952 3.641 5.665 0l-4.34-55.175-.615-7.821c-.284-3.611-5.951-3.641-5.665 0zM57.379 124.049v66.092c0 3.645 5.665 3.651 5.665 0v-57.902-8.19c0-3.646-5.665-3.652-5.665 0zM192.595 447.426c3.645 0 3.652-5.665 0-5.665-3.645 0-3.651 5.665 0 5.665zM160.164 97.993l-2.345-28.14-.83 2.003 46.545-38.858 6.59-5.502c2.802-2.339-1.224-6.328-4.006-4.006l-30.882 25.782L157 64.497c-1.261 1.053-2.782 2.048-3.901 3.257-1.478 1.598-.786 4.01-.621 5.983l2.021 24.257c.3 3.606 5.968 3.638 5.665-.001zM217.089 20.612c3.645 0 3.652-5.665 0-5.665-3.645-.001-3.651 5.665 0 5.665z" />
			</G>
			<Path
				d="M299.18 67.6l-27.73-22.526-44.26-35.955L216.947.798c-1.277-1.037-2.721-1.063-4.006 0L167.616 38.29l-25.121 20.78c-1.333 1.103-3.053 2.161-4.196 3.471-1.107 1.269-.776 2.516-.621 3.997l.713 6.795 3.638 34.707c.154 1.468 1.174 2.909 2.833 2.833l51.232-2.341 81.556-3.727 18.585-.849c1.565-.072 2.785-1.241 2.833-2.833l.942-31.517c.109-3.647-5.556-3.643-5.665 0l-.942 31.517 2.833-2.833-51.231 2.341-81.557 3.727-18.585.849 2.833 2.833-4.56-43.496-.829 2.003 25.108-20.769 40.296-33.333 9.237-7.641h-4.006a548129.2 548129.2 0 0027.729 22.526l44.26 35.955 10.243 8.321c2.806 2.279 6.838-1.705 4.006-4.006zM292.823 212.478l-46.508-2.519-74.069-4.012-16.92-.916c-1.417-.077-2.987 1.365-2.833 2.833l4.452 42.469c.167 1.59 1.166 2.743 2.833 2.833l44.499 2.41 70.958 3.844 16.329.885c1.562.085 2.789-1.367 2.833-2.833l1.259-42.16c.109-3.647-5.556-3.644-5.665 0l-1.259 42.16 2.833-2.833-44.499-2.41-70.958-3.844-16.329-.885 2.833 2.833-4.452-42.469-2.833 2.833 46.508 2.519 74.069 4.012 16.92.916c3.643.196 3.632-5.47-.001-5.666zM180.786 453.553h105.006c1.565 0 2.787-1.299 2.833-2.833l2.411-80.688.342-11.456c.044-1.481-1.334-2.901-2.833-2.833l-39.512 1.806-62.944 2.877-14.402.658c-1.408.064-2.999 1.251-2.833 2.833l7.974 76.064 1.126 10.74c.376 3.59 6.046 3.628 5.665 0l-7.974-76.064-1.126-10.74-2.833 2.833 39.512-1.806 62.944-2.877 14.402-.658-2.833-2.833-2.411 80.688-.342 11.456 2.833-2.833H180.786c-3.646 0-3.652 5.666 0 5.666z"
				fill="#412945"
			/>
			<Path
				d="M365.673 221.151l54.944-47.775 7.898-6.867c1.177-1.024.993-2.955 0-4.006l-25.632-27.111a597153.22 597153.22 0 01-34.573-36.568c-.843-.892-1.651-1.961-2.598-2.747-1.363-1.132-2.76-.839-4.38-.765l-22.161 1.013-42.937 1.962-26.462 1.209-56.274 2.572-52.31 2.391-18.653.852-46.696 2.134-47.439 2.168-2.717.124c-1.53.07-2.833 1.241-2.833 2.833v89.353c0 1.592 1.301 2.75 2.833 2.833l65.776 3.563 48.241 2.613 75.909 4.112 57.267 3.102 68.558 3.714 2.235.121c3.643.197 3.632-5.469 0-5.665l-67.924-3.679-49.161-2.663-81.641-4.422-42.662-2.311-75.115-4.069-1.483-.08 2.833 2.833v-78.336-11.017l-2.833 2.833 68.129-3.114 42.262-1.932 81.292-3.715 58.768-2.686 65.197-2.98 2.338-.107-2.003-.83 55.178 58.361 7.664 8.106v-4.006l-54.944 47.775a55646.22 55646.22 0 01-7.898 6.867c-2.756 2.398 1.265 6.39 4.007 4.007zM159.779 247.499l-66.189-3.585c-2.343-.127-4.261-.593-6.17 1.021-2.713 2.293-5.364 4.664-8.044 6.994l-31.569 27.45-22.777 19.805c-1.178 1.024-.994 2.955 0 4.006l25.632 27.111 34.574 36.568c.843.892 1.651 1.961 2.597 2.747 1.297 1.077 2.483.851 4 .782l19.59-.895 53.78-2.458 21.277-.973 55.161-2.521 44.217-2.021 20.805-.951 56.089-2.564 42.835-1.958 2.276-.104c1.53-.07 2.833-1.241 2.833-2.833v-78.335-11.017c0-1.593-1.3-2.75-2.833-2.833l-43.882-2.377-63.641-3.447-25.101-1.36-66.616-3.608c-15.978-.865-32.04-2.301-48.04-2.602-.27-.003-.538-.027-.804-.042-3.643-.197-3.632 5.469 0 5.665l40.511 2.194 68.306 3.7 27.337 1.481 59.418 3.219 33.161 1.796c6.068.329 12.367 1.189 18.446.999.298-.009.605.033.903.049l-2.833-2.833V353.121l2.833-2.833-63.326 2.894-56.59 2.586-70.185 3.208-50.885 2.326-75.043 3.43-1.957.089 2.003.83-55.179-58.361-7.664-8.106v4.006l54.944-47.775 7.898-6.867-2.003.83 61.212 3.316 8.692.471c3.644.197 3.633-5.469.001-5.666z"
				fill="#412945"
			/>
		</Svg>
	);
}

export function BunnyMoonStare(props: any) {
	return (
		<Svg
			height={512}
			viewBox="0 0 450 460.121"
			width={512}
			xmlns="http://www.w3.org/2000/svg"
			{...props}
		>
			<Circle cx={225} cy={225} fill="#ffe38c" r={225} />
			<Circle cx={217} cy={233} fill="#ffd24d" r={217} />
			<Path
				d="M277.98 407.995c-128.719-.814-233.797-105.582-234.97-234.298-.007-.781-.01-1.562-.01-2.341.007-12.086-17.108-14.356-20.346-2.712-4.93 17.728-7.593 36.4-7.653 55.686-.36 115.264 93.307 209.897 208.569 210.665 43.606.29 84.152-12.72 117.84-35.2-20.201 5.466-41.467 8.339-63.43 8.2z"
				fill="#f2b838"
			/>
			<G>
				<Path
					d="M409.04 373.223c-2.15 12.09-4.6 18.67-12.27 28.25-17.22 21.51-32.06 23.49-39.05 25.48-6.99 1.98-24 3.11-24 3.11-14.98.36-27.09-.31-37.6-1.95 0 0-.01-.01-.02 0-10.47-1.64-19.35-4.25-27.91-7.78-2.85-1.16-11.03-5.3-17.1-10.81-.91-.82-1.77-1.68-2.55-2.56a37.09 37.09 0 01-4.41-6.11c-3.27-5.62-5.23-12.09-5.9-18.39v-.02c.39-3.2 1.11-6.4.91-9.62-.07-1.13-.25-2.24-.52-3.32-.38-1.57-.96-3.08-1.67-4.55 0-.01-.01-.02-.01-.03-5.69-18.72-5.45-38.61-4.05-58.25 1.24-17.53 3.43-35.08 3.14-52.6-16.65-11.61-25.05-27.78-26.96-48.47.55-7.85 3.76-17.41 8.84-23.42 4.69-5.53 9.4-11.09 14.93-15.77 5.4-4.59 11.53-8.27 17.96-11.24 4.51-2.08 9.19-3.81 14.02-4.97 2.1-.51 4.24-.91 6.39-1.18 20.27-2.51 40.8 6.94 55.01 21.6 14.22 14.67 22.77 33.99 27.49 54.1a706.428 706.428 0 0134.37 45.48c6.11 8.8 12.08 20.82 16.18 30.73 8.92 21.57 8.85 49.32 4.78 72.29z"
					fill="#fff0e7"
				/>
				<Path
					d="M235.36 216.933c2.93 17.99 13.17 33.87 18.91 51.17 11.41 34.38 4.47 71.84-2.57 107.38-1.72 8.67-3.55 17.59-7.57 25.37-3.27-5.62-5.23-12.09-5.9-18.39.39-3.21 1.11-6.41.91-9.64-.17-2.77-.99-5.38-2.19-7.87-5.7-18.73-5.46-38.63-4.06-58.28 1.24-17.53 3.43-35.08 3.14-52.6-16.65-11.61-25.05-27.78-26.96-48.47.55-7.85 3.76-17.41 8.84-23.42 4.69-5.53 9.4-11.09 14.93-15.77 5.4-4.59 11.53-8.27 17.96-11.24 4.51-2.08 9.19-3.81 14.02-4.97-1.97 2.18-4.89 4.51-7.93 7.25-16.28 14.63-25.06 37.75-21.53 59.48z"
					fill="#fff"
				/>
				<Path
					d="M402.02 394.063c-1.42 2.36-3.14 4.77-5.25 7.41-17.22 21.51-32.06 23.49-39.05 25.48-6.99 1.98-24 3.12-24 3.12-14.99.35-27.09-.32-37.6-1.96h-.01c-10.48-1.65-19.36-4.25-27.92-7.77-2.84-1.17-11.03-5.31-17.09-10.82-.91-.82-1.78-1.68-2.56-2.56-5.98-6.69-9.38-15.76-10.31-24.5v-.02c.39-3.2 1.11-6.4.91-9.62-.07-1.13-.25-2.24-.52-3.32 1.01-6.26 3.21-12.34 6.37-17.88.72-1.26 1.5-2.49 2.31-3.7 1.27-1.85 2.64-3.62 4.12-5.3 1.32-1.5 2.73-2.93 4.24-4.25 1.09 5.03-5.06 12.44-6.32 17.12-1.88 7.01-2.07 14.51-.38 21.58 3.94 16.53 16.86 30.07 32.28 37.23s35.04 13.03 51.91 10.95c18.45-2.28 32.46.97 51.22-16.82 3.7-3.52 7.74-11.46 12.55-13.16 1.63-.57 3.36-1 5.1-1.21z"
					fill="#cc9f6e"
				/>
				<Path
					d="M296.107 428.11a333.45 333.45 0 01-23.945 1.093 334.435 334.435 0 01-44.195-2.492c-2.271-.276-4.865-.787-5.992-2.781-1.012-1.786-.37-4.099.838-5.758 1.85-2.534 4.797-4.01 7.722-5.133a53.295 53.295 0 0112.71-3.147 53.208 53.208 0 017.85-.366c6.06 5.503 14.25 9.644 17.099 10.814 8.552 3.522 17.435 6.128 27.913 7.77z"
					fill="#fff"
				/>
				<Path
					d="M296.107 428.11a333.45 333.45 0 01-23.945 1.093 64.038 64.038 0 01-20.862-11.958c-1.595-1.369-5.103-4.295-8.054-7.352a53.208 53.208 0 017.85-.366c6.06 5.503 14.25 9.644 17.099 10.814 8.551 3.521 17.434 6.127 27.912 7.769z"
					fill="#ead0c2"
				/>
				<Path
					d="M351.035 214.786c-12.379-5.477-22.665-14.994-30.889-25.757-6.349-8.301-12.26-17.571-16.75-27.024-2.943-6.196-1.135-7.327 2.109-6.57 7.693 3.819 14.76 9.049 20.717 15.194 11.856 12.226 19.769 27.692 24.813 44.157z"
					fill="#cc9f6e"
				/>
				<Path d="M231.616 189.574c.668-.972 3.133-2.576 5.804-2.533.492.008 1.015.077 1.396.388.553.451.64 1.265.55 1.972-.353 2.769-3.013 5.045-5.803 4.966-1.03-.029-2.096-.374-2.78-1.145s.165-2.676.833-3.648z" />
				<Path
					d="M288.671 225.904c7.378 14.564 18.123 29.256 34.01 33.02 6.471 1.533 14.674.234 17.451-5.809 2.305-5.018-.176-10.842-2.803-15.699a223.058 223.058 0 00-48.776-61.228c-3.271-2.876-12.117-9.789-16.563-4.876-2.731 3.018.916 11.145 1.757 14.519a190.873 190.873 0 0014.924 40.073z"
					fill="#cc9f6e"
				/>
				<Path
					d="M272.42 167.755c8.871-1.151 17.933 1.485 25.674 5.967s14.312 10.722 20.446 17.233c15.489 16.441 28.983 35.619 34.191 57.598l.039.064c-7.046 5.306-16.932 4.882-25.376 2.336-13.034-3.931-24.644-12.422-32.339-23.653-8.098-11.82-11.703-26.037-16.891-39.393-2.285-5.882-5.955-12.459-12.226-13.163z"
					fill="#fff"
				/>
				<Path
					d="M276.664 174.305c19.446 8.368 35.456 24.428 43.763 43.901 1.084 2.541 2.058 5.24 1.846 7.995-.211 2.754-1.911 5.572-4.585 6.265-2.22.575-4.61-.426-6.279-1.999s-2.766-3.645-3.812-5.686c-4.116-8.037-13.755-25.897-19.424-33.268-5.671-7.372-11.509-17.208-11.509-17.208z"
					fill="#ffd3d3"
				/>
				<Path
					d="M248.974 313.588c-9.601 5.822-17.314 14.705-21.731 25.029-.813 1.9-1.776 4.091-3.769 4.637-2.602.713-4.88-1.869-6.111-4.269-6.278-12.241-4.42-28.186 4.503-38.656 2.819-3.308 6.227-6.059 9.246-9.186a52.593 52.593 0 0010.015-14.723z"
					fill="#fff"
				/>
				<Path
					d="M293.388 151.944c8.186-3.593 18.983-4.811 27.633-2.891s17.839 5.021 25.505 9.269c19.357 10.728 36.998 23.542 48.021 42.308l.055.048c-5.296 6.901-14.887 9.332-23.679 9.396-13.571.099-26.197-5.996-36.653-14.148-11.005-8.58-19.194-19.066-27.831-29.892-3.804-4.768-9.126-9.78-15.33-8.639l2.168-4.58"
					fill="#fff0e7"
				/>
				<Path
					d="M379.016 389.966c5.208-3.443 12.011-4.548 17.902-2.483 5.892 2.065 10.624 7.413 11.515 13.592.903 6.266-2.102 12.669-6.756 16.96-4.655 4.292-10.763 6.705-16.94 8.093-5.221 1.173-10.74 1.666-15.882.184s-9.851-5.224-11.401-10.346c-1.802-5.955.992-12.535 5.414-16.911s10.919-5.633 16.148-9.089z"
					fill="#ead0c2"
				/>
				<Path
					d="M284.926 408.841a53.975 53.975 0 01-5.429 14.366c-2.879 5.217-6.625 9.942-11.131 13.887-8.362 7.343-18.653 12.232-29.312 15.473-15.501 4.718-32.116 6.058-48.047 3.097a85.355 85.355 0 01-7.815-1.826c-10.072-2.838-19.658-7.473-27.986-13.771a77.502 77.502 0 01-6.988-5.969 576.575 576.575 0 01-1.723-2.147 229.711 229.711 0 01-2.277-2.892c-5.142-6.646-9.88-13.668-12.547-21.634a47.638 47.638 0 01-1.217-4.321c-2.256-9.422-1.983-19.329-2.311-29.141-.089-2.626-.212-5.244-.451-7.843-.875-9.791-3.227-19.405-4.185-29.189-2.099-21.258 3.453-44.601 20.396-57.934 5.709-4.082 12.745-5.88 19.712-6.708a78.453 78.453 0 019.128-.554c10.885-.034 21.77 2.167 31.65 6.694 12.656 5.805 23.582 15.473 30.447 27.582 3.419 6.037 5.819 12.595 7.932 19.206.554 1.75 1.114 3.535 2.167 5.039 1.737 2.475 4.574 3.863 7.186 5.381 9.19 5.367 16.56 13.388 22.885 21.948 5.538 7.48 8.246 17.1 10.482 26.133 2.237 9.034 2.231 12.487-.566 25.123z"
					fill="#fff0e7"
				/>
				<Path
					d="M282.053 426.095c-2.879 5.217-6.625 9.942-11.131 13.887-8.362 7.343-18.653 12.232-29.312 15.473-15.501 4.718-32.116 6.058-48.047 3.097a85.355 85.355 0 01-7.815-1.826c-10.072-2.838-19.658-7.473-27.986-13.771a77.502 77.502 0 01-6.988-5.969 576.575 576.575 0 01-1.723-2.147c15.822 10.653 34.666 16.834 53.742 17.442 23.623.759 47.431-7.049 66.022-21.641 3.18-2.496 7.07-4.157 11.097-4.52a14.283 14.283 0 012.141-.025z"
					fill="#cc9f6e"
				/>
				<Path
					d="M183.523 454.508c-9.553 1.536-19.395.317-29.029-.908-1.632-.207-3.396-.48-4.518-1.676-1.587-1.683-1.174-4.474 0-6.475 1.255-2.141 3.263-3.802 5.567-4.718 8.327 6.298 17.91 10.934 27.98 13.777z"
					fill="#cc9f6e"
				/>
				<Path
					d="M128.477 374.633c.325 9.812.052 19.72 2.311 29.14-2.532 2.34-4.489 5.722-7.833 5.751-1.462.015-2.85-.679-3.987-1.587-2.665-2.126-4.216-5.419-4.858-8.763-.642-3.352-.465-6.8-.221-10.203.207-2.983.509-6.076 2.052-8.631 1.691-2.813 4.747-4.629 7.951-5.33 1.506-.333 3.049-.437 4.585-.377z"
					fill="#fff"
				/>
				<Path
					d="M235.174 306.681c-6.866-12.108-17.793-21.779-30.447-27.582a71.25 71.25 0 00-7.507-2.935c-4.847-.033-8.369 4.713-12.998 6.281 0 0 3.939 8.125 8.128 12.88s7.567 10.223 11.619 15.104c5.135 6.186 11.496 11.485 18.967 14.071 6.301 2.182 13.451 2.233 19.572-.442-1.971-5.986-4.231-11.895-7.334-17.377z"
					fill="#cc9f6e"
				/>
				<Path
					d="M173.077 272.403c-1.887.964-7.84 3.265-9.117 3.955-9.609 5.193-12.74 11.573-15.457 22.54-4.768 19.246-10.448 38.256-9.025 58.029 1.415 19.774-.206 28.781.779 48.582.226 4.513 0 13.675 4.295 24.216-5.142-6.646-9.88-13.668-12.547-21.634a47.638 47.638 0 01-1.217-4.321c-2.256-9.422-1.983-19.329-2.311-29.141-.089-2.626-.212-5.244-.451-7.843-.875-9.791-3.227-19.405-4.185-29.189-2.099-21.258 3.453-44.601 20.396-57.934 5.709-4.082 12.745-5.88 19.712-6.708a78.907 78.907 0 019.128-.552z"
					fill="#fff"
				/>
				<Path
					d="M143.377 304.837a1.341 1.341 0 01-1.235-1.863c1.041-2.47.246-5.593-1.849-7.265a1.343 1.343 0 011.674-2.098c3 2.394 4.139 6.868 2.648 10.405a1.343 1.343 0 01-1.238.821z"
					fill="#603813"
				/>
				<Path
					d="M169.666 296.905c1.362 3.461 4.943 5.284 8.152 7.014a91.703 91.703 0 0117.381 12.17c6.324 5.62 12.118 12.587 13.643 21.075.489 2.724.52 5.516.467 8.29-.117 6.126-3.113 17.512-3.113 17.512-7.595 1.919-15.82.945-22.748-2.693-3.133-1.645-5.988-3.803-8.655-6.161-3.46-3.059-6.656-6.51-8.933-10.584-4.598-8.226-5.074-18.247-4.374-27.757.341-4.634.9-9.499-.89-13.744z"
					fill="#cc9f6e"
				/>
				<Path
					d="M167.873 295.061c1.9 3.231 5.825 4.525 9.357 5.78a95.812 95.812 0 0119.542 9.569c7.285 4.661 14.227 10.73 17.032 18.912.9 2.625 1.341 5.384 1.695 8.136.781 6.078-.607 17.77-.607 17.77-7.476 2.979-16.021 3.186-23.632.572-3.442-1.182-6.675-2.911-9.746-4.864-3.983-2.534-7.755-5.494-10.679-9.201-5.905-7.485-7.864-17.332-8.546-26.842-.332-4.634-.476-9.527-2.928-13.473z"
					fill="#fff"
				/>
				<Path
					d="M200.942 344.263c2.373-3.318 1.135-14.516-3.382-20.116s-10.979-9.222-17.291-12.675-10.882-7.54-15.508-13.05c0 0-3.118.567-1.984 3.685s3.402 14.458 5.953 20.411 6.237 20.128 15.875 24.097c9.638 3.968 13.964.966 16.337-2.352z"
					fill="#ffd3d3"
				/>
				<G>
					<Path
						d="M183.532 278.925c10.286-5.073 22.404-6.066 33.548-3.357s21.294 9.004 29.166 17.345c5.382 5.702 8.905 20.091 8.905 20.091-6.257 5.348-15.135 7.017-23.236 5.564-8.102-1.454-15.476-5.754-21.724-11.113-4.93-4.229-9.257-9.136-14.308-13.22s-11.077-7.387-17.569-7.602z"
						fill="#fff0e7"
					/>
				</G>
				<Path
					d="M256.221 420.364c-4.315 1.858-7.617 5.786-8.992 10.278s-.882 9.472 1.074 13.744c.823 1.797 1.914 3.501 3.402 4.802 1.631 1.427 3.67 2.312 5.75 2.922 5.942 1.741 12.587 1.295 18.03-1.658 5.443-2.952 9.524-8.49 10.273-14.636.75-6.147-2.056-12.707-7.271-16.045-6.787-4.346-15.683-2.243-22.266.593z"
					fill="#cc9f6e"
				/>
				<G>
					<Path
						d="M285.494 383.72c-2.236-9.032-4.944-18.652-10.482-26.133-5.653-7.652-12.146-14.866-20.023-20.146 21.114 24.22 29.45 54.435 24.911 85.002a53.962 53.962 0 005.026-13.604c2.797-12.634 2.803-16.087.568-25.119z"
						fill="#cc9f6e"
					/>
				</G>
				<Path
					d="M252.215 417.697c-4.51 1.858-7.961 5.786-9.398 10.278-1.438 4.492-.922 9.472 1.122 13.744.86 1.797 2.001 3.501 3.555 4.802 1.705 1.427 3.836 2.312 6.01 2.922 6.211 1.741 13.156 1.295 18.845-1.658 5.689-2.952 9.954-8.49 10.737-14.636.784-6.147-2.149-12.707-7.599-16.045-7.094-4.345-16.392-2.242-23.272.593z"
					fill="#fff"
				/>
				<Path
					d="M379.016 389.966c5.208-3.443 12.011-4.548 17.902-2.483 5.892 2.065 10.624 7.413 11.515 13.592.903 6.266-2.102 12.669-6.756 16.96-4.655 4.292-10.763 6.705-16.94 8.093-5.221 1.173-10.74 1.666-15.882.184s-9.851-5.224-11.401-10.346c-1.802-5.955.992-12.535 5.414-16.911s10.919-5.633 16.148-9.089z"
					fill="#cc9f6e"
				/>
				<Path
					d="M377.218 387.802c4.996-3.283 11.522-4.336 17.175-2.368 5.652 1.969 10.193 7.068 11.047 12.96.867 5.975-2.016 12.079-6.481 16.171s-10.326 6.393-16.252 7.717c-5.009 1.119-10.304 1.589-15.237.175-4.933-1.413-9.451-4.981-10.938-9.865-1.728-5.678.952-11.951 5.194-16.124s10.476-5.371 15.492-8.666z"
					fill="#fff"
				/>
			</G>
			<G>
				<Path
					d="M77.323 126.181c.173-.135.346-.274.514-.415 2.56-2.164 3.97-5.204 5.806-7.951 6.128-3.001 13.095-1.373 19.147 1.98 6.052 3.356 11.077 8.117 17.086 11.537 7.929 4.518 17.475 6.295 26.715 5.421 7.708-.723 15.203-3.287 21.375-7.641 7.905-4.319 19.23-24.491 29.826-29.381 10.596-4.891 30.269-8.19 36.015-5.608 8.641 3.886 19.193 4.874 27.798.919 8.602-3.955 14.365-13.51 11.769-22.089-1.353 5.506-3.295 11.558-8.352 14.933-4.972 3.318-11.96 3.123-17.5.692a19.442 19.442 0 01-3.156-1.721c-5.038-3.421-7.533-9.168-11.726-13.461-5.4-5.531-13.877-9.05-21.763-7.505-18.79 3.681-26.706 17.184-34.685 20.798-18.331 8.304-24.453-11.004-36.147-24.702-3.606-4.224-9.954-5.446-15.696-5.782-4.325-.252-9.04.094-12.596-2.209-1.565-1.01-2.742-2.449-3.889-3.862-2.298-2.826-4.592-5.648-6.887-8.474-3.613-4.44-7.434-9.044-12.849-11.427-6.156-2.713-13.424-2.102-20.014-.477-4.907 1.213-9.803 3.035-13.423 6.341-4.561 4.17-6.533 10.134-9.87 15.204-2.99 4.542-7.144 8.412-12.025 11.2-3.939 2.254-8.336 3.809-12.066 6.353-9.778 6.668-13.148 20.257-7.489 30.219 1.306 2.3 3.11 4.466 5.612 5.634 2.813 1.312 6.132 1.208 9.153 2.031 3.048.832 5.775 2.643 7.605 5.055 2.522 4.059 4.89 8.558 8.375 12.285 3.489 3.727 8.278 6.657 13.578 7.051 3.035.224 6.06-.381 9.028-.997 3.792-.787 7.743-1.687 10.731-3.951z"
					fill="#c8e4ec"
				/>
				<Path
					d="M77.837 125.767c-.168.141-.341.28-.514.415 2.089-.715 5.098-1.165 7.486-.983 5.323-.294 10.397 2.063 14.817 4.829 4.417 2.77 8.544 6.04 13.445 7.983 10.353 4.104 22.588 1.253 33.519-1.254l-.001-.003c-9.24.874-18.786-.903-26.715-5.421-6.009-3.42-11.034-8.181-17.086-11.537-6.052-3.352-13.018-4.981-19.147-1.98-1.834 2.746-3.244 5.787-5.804 7.951z"
					fill="#add3de"
				/>
				<Path
					d="M53.143 87.345c.024-.774.047-1.504.028-2.233-.028-1.034-.142-2.06-.261-3.145-.131-1.189-.267-2.42-.281-3.665C52.55 71.26 56.601 64.5 62.95 61.078c6.569-3.533 15.253-3.107 21.119 1.039 1.448 1.024 2.713 2.236 3.936 3.409 1.853 1.776 3.604 3.455 5.826 4.372 2.344.969 4.999 1.007 7.81 1.048 2.059.03 4.189.06 6.277.473 6.915 1.368 12.51 7.04 13.607 13.793 1.034 6.339-1.931 13.187-7.552 17.447-3.847 2.914-8.588 4.526-13.174 6.085-5.612 1.907-10.913 3.71-14.403 7.678-.527.6-1.038 1.278-1.567 2.078-.386.578-.796 1.423-1.27 2.401-.634 1.308-1.401 2.881-2.432 4.434-1.373.177-2.715.474-3.805.848-.365.276-.745.532-1.136.77 2.356-2.035 3.739-4.874 4.825-7.115.515-1.063.959-1.98 1.44-2.699a21.597 21.597 0 011.78-2.356c3.976-4.519 9.889-6.529 15.608-8.473 4.369-1.485 8.886-3.02 12.368-5.659 4.872-3.691 7.445-9.599 6.556-15.05-.913-5.618-5.718-10.514-11.427-11.644-1.822-.36-3.724-.387-5.738-.416-2.968-.042-6.037-.087-8.904-1.271-2.716-1.122-4.74-3.062-6.697-4.938-1.204-1.154-2.342-2.244-3.622-3.15-4.993-3.529-12.406-3.882-18.024-.859-5.493 2.96-8.998 8.83-8.929 14.953.013 1.126.136 2.244.267 3.428.12 1.086.244 2.209.275 3.345.021.8-.004 1.6-.028 2.373-.052 1.648-.1 3.206.273 4.676.827 3.251 3.914 6.068 7.865 7.176 4.394 1.231 8.898.315 11.901-.67 3.767-1.24 6.534-3.014 8.224-5.276 1.925-2.568 2.24-5.96.768-8.247-.792-1.226-2.236-2.138-3.865-2.439-1.367-.255-2.65-.029-3.611.632-.619.425-1.495.305-1.954-.271s-.328-1.388.292-1.814c1.603-1.102 3.67-1.489 5.82-1.09 2.388.442 4.525 1.806 5.715 3.651 2.05 3.185 1.699 7.629-.871 11.059-2.03 2.716-5.255 4.816-9.586 6.241-3.398 1.115-8.522 2.142-13.641.708-4.888-1.37-8.725-4.927-9.777-9.063-.457-1.804-.4-3.607-.346-5.35z"
					fill="#87b7c4"
				/>
			</G>
		</Svg>
	);
}
