//! `SeaORM` Entity, @generated by sea-orm-codegen 1.1.0

use sea_orm::entity::prelude::*;
use serde::{Deserialize, Serialize};

#[derive(Clone, Debug, PartialEq, DeriveEntityModel, Serialize, Deserialize)]
#[sea_orm(table_name = "meal_ingredient")]
pub struct Model {
    #[sea_orm(primary_key, auto_increment = false)]
    pub ingredient_id: i32,
    #[sea_orm(primary_key, auto_increment = false)]
    pub meal_id: i32,
    #[sea_orm(column_type = "Float")]
    pub quantity: f32,
}

#[derive(Copy, Clone, Debug, EnumIter, DeriveRelation)]
pub enum Relation {
    #[sea_orm(
        belongs_to = "super::ingredient::Entity",
        from = "Column::IngredientId",
        to = "super::ingredient::Column::Id",
        on_update = "NoAction",
        on_delete = "NoAction"
    )]
    Ingredient,
    #[sea_orm(
        belongs_to = "super::meal::Entity",
        from = "Column::MealId",
        to = "super::meal::Column::Id",
        on_update = "NoAction",
        on_delete = "NoAction"
    )]
    Meal,
}

impl Related<super::ingredient::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::Ingredient.def()
    }
}

impl Related<super::meal::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::Meal.def()
    }
}

impl ActiveModelBehavior for ActiveModel {}
