//! `SeaORM` Entity, @generated by sea-orm-codegen 1.1.0

use sea_orm::entity::prelude::*;
use serde::{Deserialize, Serialize};

#[derive(Clone, Debug, PartialEq, DeriveEntityModel, Eq, Serialize, Deserialize)]
#[sea_orm(table_name = "meal")]
pub struct Model {
    #[sea_orm(primary_key)]
    pub id: i32,
    #[sea_orm(unique)]
    pub name: String,
    pub light: bool,
    pub meat: bool,
    pub month_start: u8,
    pub month_end: u8,
    pub source: String,
    pub category_id: i32,
    #[sea_orm(column_type = "Text")]
    pub recipe: String,
}

#[derive(Copy, Clone, Debug, EnumIter, DeriveRelation)]
pub enum Relation {
    #[sea_orm(
        belongs_to = "super::category::Entity",
        from = "Column::CategoryId",
        to = "super::category::Column::Id",
        on_update = "NoAction",
        on_delete = "NoAction"
    )]
    Category,
    #[sea_orm(has_many = "super::meal_ingredient::Entity")]
    MealIngredient,
}

impl Related<super::category::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::Category.def()
    }
}

impl Related<super::meal_ingredient::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::MealIngredient.def()
    }
}

impl Related<super::ingredient::Entity> for Entity {
    fn to() -> RelationDef {
        super::meal_ingredient::Relation::Ingredient.def()
    }
    fn via() -> Option<RelationDef> {
        Some(super::meal_ingredient::Relation::Meal.def().rev())
    }
}

impl ActiveModelBehavior for ActiveModel {}
