/** @typedef {typeof __propDef.props}  SxProps */
/** @typedef {typeof __propDef.events}  SxEvents */
/** @typedef {typeof __propDef.slots}  SxSlots */
/**
 * [Go to docs](https://svelte-flag-icons.codewithshin.com)
 * ## Props
 * @prop export let size = ctx.size || '24';
 * @prop export let role = ctx.role || 'img';
 * @prop export let ariaLabel = 'flag of sx';
 */
export default class Sx extends SvelteComponentTyped<{
    [x: string]: any;
    size?: any;
    role?: any;
    ariaLabel?: string | undefined;
}, {
    click: MouseEvent;
    keydown: KeyboardEvent;
    keyup: KeyboardEvent;
    focus: FocusEvent;
    blur: FocusEvent;
    mouseenter: MouseEvent;
    mouseleave: MouseEvent;
    mouseover: MouseEvent;
    mouseout: MouseEvent;
} & {
    [evt: string]: CustomEvent<any>;
}, {}> {
}
export type SxProps = typeof __propDef.props;
export type SxEvents = typeof __propDef.events;
export type SxSlots = typeof __propDef.slots;
import { SvelteComponentTyped } from "svelte";
declare const __propDef: {
    props: {
        [x: string]: any;
        size?: any;
        role?: any;
        ariaLabel?: string | undefined;
    };
    events: {
        click: MouseEvent;
        keydown: KeyboardEvent;
        keyup: KeyboardEvent;
        focus: FocusEvent;
        blur: FocusEvent;
        mouseenter: MouseEvent;
        mouseleave: MouseEvent;
        mouseover: MouseEvent;
        mouseout: MouseEvent;
    } & {
        [evt: string]: CustomEvent<any>;
    };
    slots: {};
};
export {};
