import { SvelteComponentTyped } from "svelte";
import { type TransitionConfig } from 'svelte/transition';
import type { ColorVariant, ToastPositionType } from '../types';
declare const __propDef: {
    props: {
        [x: string]: any;
        dismissable?: boolean | undefined;
        color?: ColorVariant | undefined;
        position?: ToastPositionType | undefined;
        divClass?: string | undefined;
        defaultIconClass?: string | undefined;
        contentClass?: string | undefined;
        align?: boolean | undefined;
        transition?: ((node: HTMLElement, params: any) => TransitionConfig) | undefined;
        params?: {} | undefined;
        toastStatus?: boolean | undefined;
    };
    events: {
        close: CustomEvent<any>;
    } & {
        [evt: string]: CustomEvent<any>;
    };
    slots: {
        icon: {};
        default: {};
    };
};
export type ToastProps = typeof __propDef.props;
export type ToastEvents = typeof __propDef.events;
export type ToastSlots = typeof __propDef.slots;
/**
 * [Go to docs](https://flowbite-svelte.com/)
 * ## Props
 * @prop export let dismissable: boolean = true;
 * @prop export let color: ColorVariant = 'primary';
 * @prop export let position: ToastPositionType = 'none';
 * @prop export let divClass: string = 'w-full max-w-xs p-4 text-gray-500 bg-white shadow dark:text-gray-400 dark:bg-gray-800 gap-3';
 * @prop export let defaultIconClass: string = 'w-8 h-8';
 * @prop export let contentClass: string = 'w-full text-sm font-normal';
 * @prop export let div2class: string = '';
 * @prop export let div3class: string = '';
 * @prop export let align: boolean = true;
 * @prop export let transition: TransitionFunc = fade;
 * @prop export let params = {};
 * @prop export let toastStatus: boolean = true;
 */
export default class Toast extends SvelteComponentTyped<ToastProps, ToastEvents, ToastSlots> {
}
export {};
