import { SvelteComponentTyped } from "svelte";
import type { ActivityType } from '../types';
declare const __propDef: {
    props: {
        [x: string]: any;
        activities: ActivityType[];
        liClass?: string | undefined;
        spanClass?: string | undefined;
        imgClass?: string | undefined;
        outerDivClass?: string | undefined;
        innerDivClass?: string | undefined;
        timeClass?: string | undefined;
        titleClass?: string | undefined;
        textClass?: string | undefined;
    };
    events: {
        [evt: string]: CustomEvent<any>;
    };
    slots: {};
};
export type ActivityItemProps = typeof __propDef.props;
export type ActivityItemEvents = typeof __propDef.events;
export type ActivityItemSlots = typeof __propDef.slots;
/**
 * [Go to docs](https://flowbite-svelte.com/)
 * ## Props
 * @prop export let activities: ActivityType[];
 * @prop export let liClass: string = 'mb-10 ms-6';
 * @prop export let spanClass: string = 'flex absolute -start-3 justify-center items-center w-6 h-6 bg-blue-200 rounded-full ring-8 ring-white dark:ring-gray-900 dark:bg-blue-900';
 * @prop export let imgClass: string = 'rounded-full shadow-lg';
 * @prop export let outerDivClass: string = 'p-4 bg-white rounded-lg border border-gray-200 shadow-sm dark:bg-gray-700 dark:border-gray-600';
 * @prop export let innerDivClass: string = 'justify-between items-center mb-3 sm:flex';
 * @prop export let timeClass: string = 'mb-1 text-xs font-normal text-gray-400 sm:order-last sm:mb-0';
 * @prop export let titleClass: string = 'text-sm font-normal text-gray-500 lex dark:text-gray-300';
 * @prop export let textClass: string = 'p-3 text-xs italic font-normal text-gray-500 bg-gray-50 rounded-lg border border-gray-200 dark:bg-gray-600 dark:border-gray-500 dark:text-gray-300';
 */
export default class ActivityItem extends SvelteComponentTyped<ActivityItemProps, ActivityItemEvents, ActivityItemSlots> {
}
export {};
