import { SvelteComponentTyped } from "svelte";
declare const __propDef: {
    props: {
        [x: string]: any;
        divClass?: string | undefined;
        inputValue?: string | undefined;
        striped?: boolean | undefined;
        hoverable?: boolean | undefined;
        placeholder?: string | undefined;
        customColor?: string | undefined;
        color?: ("blue" | "green" | "red" | "yellow" | "purple" | "default" | "custom") | undefined;
        innerDivClass?: string | undefined;
        searchClass?: string | undefined;
        svgDivClass?: string | undefined;
        svgClass?: string | undefined;
        inputClass?: string | undefined;
    };
    events: {
        [evt: string]: CustomEvent<any>;
    };
    slots: {
        svgSearch: {};
        header: {};
        default: {};
        footer: {};
    };
};
export type TableSearchProps = typeof __propDef.props;
export type TableSearchEvents = typeof __propDef.events;
export type TableSearchSlots = typeof __propDef.slots;
/**
 * [Go to docs](https://flowbite-svelte.com/)
 * ## Props
 * @prop export let divClass: string = 'relative overflow-x-auto shadow-md sm:rounded-lg';
 * @prop export let inputValue: string = '';
 * @prop export let striped: boolean = false;
 * @prop export let hoverable: boolean = false;
 * @prop export let placeholder: string = 'Search';
 * @prop export let customColor: string = '';
 * @prop export let color: 'blue' | 'green' | 'red' | 'yellow' | 'purple' | 'default' | 'custom' = 'default';
 * @prop export let innerDivClass: string = 'p-4';
 * @prop export let searchClass: string = 'relative mt-1';
 * @prop export let svgDivClass: string = 'absolute inset-y-0 start-0 flex items-center ps-3 pointer-events-none';
 * @prop export let svgClass: string = 'w-5 h-5 text-gray-500 dark:text-gray-400';
 * @prop export let inputClass: string = 'bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-80 p-2.5 ps-10 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500';
 */
export default class TableSearch extends SvelteComponentTyped<TableSearchProps, TableSearchEvents, TableSearchSlots> {
}
export {};
