import { SvelteComponentTyped } from "svelte";
import type { TableColorType } from '../types';
declare class __sveltets_Render<T> {
    props(): {
        [x: string]: any;
        divClass?: string | undefined;
        striped?: boolean | undefined;
        hoverable?: boolean | undefined;
        noborder?: boolean | undefined;
        shadow?: boolean | undefined;
        color?: TableColorType | undefined;
        customeColor?: string | undefined;
        items?: T[] | undefined;
        filter?: ((t: T, term: string) => boolean) | null | undefined;
        placeholder?: string | undefined;
        innerDivClass?: string | undefined;
        searchClass?: string | undefined;
        svgDivClass?: string | undefined;
        svgClass?: string | undefined;
        inputClass?: string | undefined;
    };
    events(): {} & {
        [evt: string]: CustomEvent<any>;
    };
    slots(): {
        search: {};
        svgSearch: {};
        header: {};
        default: {};
    };
}
export type TableProps<T> = ReturnType<__sveltets_Render<T>['props']>;
export type TableEvents<T> = ReturnType<__sveltets_Render<T>['events']>;
export type TableSlots<T> = ReturnType<__sveltets_Render<T>['slots']>;
/**
 * [Go to docs](https://flowbite-svelte.com/)
 * ## Props
 * @prop export let divClass: string = 'relative overflow-x-auto';
 * @prop export let striped: boolean = false;
 * @prop export let hoverable: boolean = false;
 * @prop export let noborder: boolean = false;
 * @prop export let shadow: boolean = false;
 * @prop export let color: TableColorType = 'default';
 * @prop export let customeColor: string = '';
 * @prop export let items: T[] = [];
 * @prop export let filter: ((t: T, term: string) => boolean) | null = null;
 * @prop export let placeholder: string = 'Search';
 * @prop export let innerDivClass: string = 'p-4';
 * @prop export let searchClass: string = 'relative mt-1';
 * @prop export let svgDivClass: string = 'absolute inset-y-0 start-0 flex items-center ps-3 pointer-events-none';
 * @prop export let svgClass: string = 'w-5 h-5 text-gray-500 dark:text-gray-400';
 * @prop export let inputClass: string = 'bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-80 p-2.5 ps-10 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500';
 */
export default class Table<T> extends SvelteComponentTyped<TableProps<T>, TableEvents<T>, TableSlots<T>> {
}
export {};
