import { SvelteComponentTyped } from "svelte";
import type { EasingFunction } from 'svelte/transition';
declare const __propDef: {
    props: {
        [x: string]: any;
        progress?: (string | number) | undefined;
        precision?: number | undefined;
        tweenDuration?: number | undefined;
        animate?: boolean | undefined;
        size?: string | undefined;
        labelInside?: boolean | undefined;
        labelOutside?: string | undefined;
        easing?: EasingFunction | undefined;
        color?: ("primary" | "blue" | "gray" | "red" | "green" | "yellow" | "purple" | "indigo") | undefined;
        labelInsideClass?: string | undefined;
        divClass?: string | undefined;
        progressClass: string;
    };
    events: {
        [evt: string]: CustomEvent<any>;
    };
    slots: {};
};
export type ProgressbarProps = typeof __propDef.props;
export type ProgressbarEvents = typeof __propDef.events;
export type ProgressbarSlots = typeof __propDef.slots;
/**
 * [Go to docs](https://flowbite-svelte.com/)
 * ## Props
 * @prop export let progress: string | number = '45';
 * @prop export let precision: number = 0
 * export let tweenDuration: number = 400;
 * @prop export let animate: boolean = false;
 * @prop export let size: string = 'h-2.5';
 * @prop export let labelInside: boolean = false;
 * @prop export let labelOutside: string = '';
 * @prop export let easing: EasingFunction = cubicOut;
 * @prop export let color: 'primary' | 'blue' | 'gray' | 'red' | 'green' | 'yellow' | 'purple' | 'indigo' = 'primary';
 * @prop export let labelInsideClass: string = 'text-primary-100 text-xs font-medium text-center p-0.5 leading-none rounded-full';
 * @prop export let divClass: string = 'w-full bg-gray-200 rounded-full dark:bg-gray-700';
 * @prop export let progressClass: string;
 */
export default class Progressbar extends SvelteComponentTyped<ProgressbarProps, ProgressbarEvents, ProgressbarSlots> {
}
export {};
