import { SvelteComponentTyped } from "svelte";
import type { LinkType } from '../types';
declare const __propDef: {
    props: {
        [x: string]: any;
        pages?: LinkType[] | undefined;
        activeClass?: string | undefined;
        normalClass?: string | undefined;
        ulClass?: string | undefined;
        table?: boolean | undefined;
        large?: boolean | undefined;
        ariaLabel?: string | undefined;
    };
    events: {
        blur: FocusEvent;
        change: Event;
        click: MouseEvent;
        focus: FocusEvent;
        keydown: KeyboardEvent;
        keypress: KeyboardEvent;
        keyup: KeyboardEvent;
        mouseenter: MouseEvent;
        mouseleave: MouseEvent;
        mouseover: MouseEvent;
        previous: CustomEvent<any>;
        next: CustomEvent<any>;
    } & {
        [evt: string]: CustomEvent<any>;
    };
    slots: {
        prev: {};
        next: {};
    };
};
export type PaginationProps = typeof __propDef.props;
export type PaginationEvents = typeof __propDef.events;
export type PaginationSlots = typeof __propDef.slots;
/**
 * [Go to docs](https://flowbite-svelte.com/)
 * ## Props
 * @prop export let pages: LinkType[] = [];
 * @prop export let activeClass: string = 'text-blue-600 border border-gray-300 bg-blue-50 hover:bg-blue-100 hover:text-blue-700 dark:border-gray-700 dark:bg-gray-700 dark:text-white';
 * @prop export let normalClass: string = 'text-gray-500 bg-white hover:bg-gray-100 hover:text-gray-700 dark:bg-gray-800 dark:border-gray-700 dark:text-gray-400 dark:hover:bg-gray-700 dark:hover:text-white';
 * @prop export let ulClass: string = 'inline-flex -space-x-px rtl:space-x-reverse items-center';
 * @prop export let table: boolean = false;
 * @prop export let large: boolean = false;
 * @prop export let ariaLabel: string = 'Page navigation';
 */
export default class Pagination extends SvelteComponentTyped<PaginationProps, PaginationEvents, PaginationSlots> {
}
export {};
