import { SvelteComponentTyped } from "svelte";
declare const __propDef: {
    props: {
        [x: string]: any;
        active?: boolean | undefined;
        current?: boolean | undefined;
        disabled?: boolean | undefined;
        href?: string | undefined;
        currentClass?: string | undefined;
        normalClass?: string | undefined;
        disabledClass?: string | undefined;
        focusClass?: string | undefined;
        hoverClass?: string | undefined;
        itemDefaultClass?: string | undefined;
        attrs?: any;
    };
    events: {
        blur: FocusEvent;
        change: Event;
        click: MouseEvent;
        focus: FocusEvent;
        keydown: KeyboardEvent;
        keypress: KeyboardEvent;
        keyup: KeyboardEvent;
        mouseenter: MouseEvent;
        mouseleave: MouseEvent;
        mouseover: MouseEvent;
    } & {
        [evt: string]: CustomEvent<any>;
    };
    slots: {
        default: {
            item: SvelteAllProps;
        };
    };
};
export type ListgroupItemProps = typeof __propDef.props;
export type ListgroupItemEvents = typeof __propDef.events;
export type ListgroupItemSlots = typeof __propDef.slots;
/**
 * [Go to docs](https://flowbite-svelte.com/)
 * ## Props
 * @prop export let active: boolean = getContext('active');
 * @prop export let current: boolean = false;
 * @prop export let disabled: boolean = false;
 * @prop export let href: string = '';
 * @prop export let currentClass: string = 'text-white bg-primary-700 dark:text-white dark:bg-gray-800';
 * @prop export let normalClass: string = '';
 * @prop export let disabledClass: string = 'text-gray-900 bg-gray-100 dark:bg-gray-600 dark:text-gray-400';
 * @prop export let focusClass: string = 'focus:z-40 focus:outline-none focus:ring-2 focus:ring-primary-700 focus:text-primary-700 dark:focus:ring-gray-500 dark:focus:text-white';
 * @prop export let hoverClass: string = 'hover:bg-gray-100 hover:text-primary-700 dark:hover:bg-gray-600 dark:hover:text-white';
 * @prop export let itemDefaultClass: string = 'py-2 px-4 w-full text-sm font-medium list-none first:rounded-t-lg last:rounded-b-lg';
 * @prop export let attrs: any = undefined;
 */
export default class ListgroupItem extends SvelteComponentTyped<ListgroupItemProps, ListgroupItemEvents, ListgroupItemSlots> {
}
export {};
