import { SvelteComponentTyped } from "svelte";
import type { SizeType, FormSizeType } from '../types';
export declare function clampSize(s: SizeType): "sm" | "lg" | "md";
import type { InputType } from '../types';
declare const __propDef: {
    props: {
        [x: string]: any;
        type?: InputType | undefined;
        value?: any;
        size?: FormSizeType | undefined;
        clearable?: boolean | undefined;
        defaultClass?: string | undefined;
        color?: ("base" | "green" | "red") | undefined;
        floatClass?: string | undefined;
    };
    events: {
        blur: FocusEvent;
        change: CustomEvent<any>;
        click: MouseEvent;
        contextmenu: MouseEvent;
        focus: FocusEvent;
        keydown: KeyboardEvent;
        keypress: KeyboardEvent;
        keyup: KeyboardEvent;
        mouseover: MouseEvent;
        mouseenter: MouseEvent;
        mouseleave: MouseEvent;
        paste: ClipboardEvent;
        input: Event;
    } & {
        [evt: string]: CustomEvent<any>;
    };
    slots: {
        left: {};
        default: {
            props: {
                class: string;
            };
        };
        right: {};
    };
};
export type InputProps = typeof __propDef.props;
export type InputEvents = typeof __propDef.events;
export type InputSlots = typeof __propDef.slots;
/**
 * [Go to docs](https://flowbite-svelte.com/)
 * ## Props
 * @prop export let type: InputType = 'text';
 * @prop export let value: any = undefined;
 * @prop export let size: FormSizeType | undefined = undefined;
 * @prop export let clearable = false;
 * @prop export let defaultClass: string = 'block w-full disabled:cursor-not-allowed disabled:opacity-50 rtl:text-right';
 * @prop export let color: 'base' | 'green' | 'red' = 'base';
 * @prop export let floatClass: string = 'flex absolute inset-y-0 items-center text-gray-500 dark:text-gray-400';
 */
export default class Input extends SvelteComponentTyped<InputProps, InputEvents, InputSlots> {
}
export {};
