import { SvelteComponentTyped } from "svelte";
import type { InputType } from '../types';
declare const __propDef: {
    props: {
        [x: string]: any;
        id?: string | undefined;
        style?: ("filled" | "outlined" | "standard") | undefined;
        type?: InputType | undefined;
        size?: ("small" | "default") | undefined;
        color?: ("base" | "green" | "red") | undefined;
        value?: any;
    };
    events: {
        blur: FocusEvent;
        change: Event;
        click: MouseEvent;
        focus: FocusEvent;
        input: Event;
        keydown: KeyboardEvent;
        keypress: KeyboardEvent;
        keyup: KeyboardEvent;
        mouseenter: MouseEvent;
        mouseleave: MouseEvent;
        mouseover: MouseEvent;
        paste: ClipboardEvent;
    } & {
        [evt: string]: CustomEvent<any>;
    };
    slots: {
        default: {};
    };
};
export type FloatingLabelInputProps = typeof __propDef.props;
export type FloatingLabelInputEvents = typeof __propDef.events;
export type FloatingLabelInputSlots = typeof __propDef.slots;
/**
 * [Go to docs](https://flowbite-svelte.com/)
 * ## Props
 * @prop export let id: string = generateId();
 * @prop export let style: 'filled' | 'outlined' | 'standard' = 'standard';
 * @prop export let type: InputType = 'text';
 * @prop export let size: 'small' | 'default' = 'default';
 * @prop export let color: 'base' | 'green' | 'red' = 'base';
 * @prop export let value: any = undefined;
 */
export default class FloatingLabelInput extends SvelteComponentTyped<FloatingLabelInputProps, FloatingLabelInputEvents, FloatingLabelInputSlots> {
}
export {};
