import { SvelteComponentTyped } from "svelte";
export type DropdownType = {
    activeClass: string;
};
import type { Placement } from '@floating-ui/dom';
import type { FrameColor } from '../utils/Frame.svelte';
declare const __propDef: {
    props: {
        [x: string]: any;
        activeUrl?: string | undefined;
        open?: boolean | undefined;
        containerClass?: string | undefined;
        classContainer?: string | undefined;
        headerClass?: string | undefined;
        classHeader?: string | undefined;
        footerClass?: string | undefined;
        classFooter?: string | undefined;
        activeClass?: string | undefined;
        classActive?: string | undefined;
        arrow?: boolean | undefined;
        trigger?: ("hover" | "click" | "focus") | undefined;
        placement?: Placement | undefined;
        color?: FrameColor | undefined;
        shadow?: boolean | undefined;
        rounded?: boolean | undefined;
    };
    events: {
        show: CustomEvent<any>;
    } & {
        [evt: string]: CustomEvent<any>;
    };
    slots: {
        header: {};
        default: {};
        footer: {};
    };
};
export type DropdownProps = typeof __propDef.props;
export type DropdownEvents = typeof __propDef.events;
export type DropdownSlots = typeof __propDef.slots;
/**
 * [Go to docs](https://flowbite-svelte.com/)
 * ## Props
 * @prop export let activeUrl: string = '';
 * @prop export let open: boolean = false;
 * @prop export let containerClass: string = 'divide-y z-50';
 * @prop export let classContainer: string | undefined = undefined;
 * @prop export let headerClass: string = 'py-1 overflow-hidden rounded-t-lg';
 * @prop export let classHeader: string | undefined = undefined;
 * @prop export let footerClass: string = 'py-1 overflow-hidden rounded-b-lg';
 * @prop export let classFooter: string | undefined = undefined;
 * @prop export let activeClass: string = 'text-primary-700 dark:text-primary-700 hover:text-primary-900 dark:hover:text-primary-900';
 * @prop export let classActive: string | undefined = undefined;
 * @prop export let arrow: boolean = false;
 * @prop export let trigger: 'hover' | 'click' | 'focus' = 'click';
 * @prop export let placement: Placement = 'bottom';
 * @prop export let color: FrameColor = 'dropdown';
 * @prop export let shadow: boolean = true;
 * @prop export let rounded: boolean = true;
 */
export default class Dropdown extends SvelteComponentTyped<DropdownProps, DropdownEvents, DropdownSlots> {
}
export {};
