import { SvelteComponentTyped } from "svelte";
import type { SizeType } from '../types';
declare const __propDef: {
    props: import("svelte/elements").HTMLAnchorAttributes & {
        tag?: string;
        color?: import("../utils/Frame.svelte").FrameColor;
        rounded?: boolean;
        border?: boolean;
        shadow?: boolean;
        node?: HTMLElement | undefined;
        use?: import("svelte/action").Action<HTMLElement, any>;
        options?: object;
        class?: string;
        role?: string;
        open?: boolean;
        transition?: (node: HTMLElement, params: any) => import("svelte/transition").TransitionConfig;
        params?: any;
    } & {
        horizontal?: boolean;
        reverse?: boolean;
        img?: string;
        padding?: SizeType | "none";
        size?: SizeType | "none";
        imgClass?: string;
    };
    events: {
        click: MouseEvent;
        focusin: FocusEvent;
        focusout: FocusEvent;
        mouseenter: MouseEvent;
        mouseleave: MouseEvent;
    } & {
        [evt: string]: CustomEvent<any>;
    };
    slots: {
        default: {};
    };
};
export type CardProps = typeof __propDef.props;
export type CardEvents = typeof __propDef.events;
export type CardSlots = typeof __propDef.slots;
/**
 * [Go to docs](https://flowbite-svelte.com/)
 * ## Props
 * @prop export let href: string | null | undefined = undefined;
 * @prop export let horizontal: boolean = false;
 * @prop export let reverse: boolean = false;
 * @prop export let img: string | undefined = undefined;
 * @prop export let padding: SizeType | 'none' = 'lg';
 * @prop export let size: SizeType | 'none' = 'sm';
 * @prop export let imgClass: string = '';
 */
export default class Card extends SvelteComponentTyped<CardProps, CardEvents, CardSlots> {
}
export {};
