import { SvelteComponentTyped } from "svelte";
import type { HTMLButtonAttributes } from 'svelte/elements';
declare const __propDef: {
    props: {
        [x: string]: any;
        pill?: boolean | undefined;
        outline?: boolean | undefined;
        size?: ("xs" | "sm" | "md" | "lg" | "xl") | undefined;
        href?: string | undefined;
        type?: HTMLButtonAttributes["type"];
        color?: ("red" | "yellow" | "green" | "purple" | "blue" | "light" | "dark" | "primary" | "none" | "alternative") | undefined;
        shadow?: boolean | undefined;
        tag?: string | undefined;
        checked?: boolean | undefined;
        disabled?: boolean | undefined;
    };
    events: {
        click: MouseEvent;
        change: Event;
        keydown: KeyboardEvent;
        keyup: KeyboardEvent;
        touchstart: TouchEvent;
        touchend: TouchEvent;
        touchcancel: TouchEvent;
        mouseenter: MouseEvent;
        mouseleave: MouseEvent;
    } & {
        [evt: string]: CustomEvent<any>;
    };
    slots: {
        default: {};
    };
};
export type ButtonProps = typeof __propDef.props;
export type ButtonEvents = typeof __propDef.events;
export type ButtonSlots = typeof __propDef.slots;
/**
 * [Go to docs](https://flowbite-svelte.com/)
 * ## Props
 * @prop export let pill: boolean = false;
 * @prop export let outline: boolean = false;
 * @prop export let size: 'xs' | 'sm' | 'md' | 'lg' | 'xl' = group ? 'sm' : 'md';
 * @prop export let href: string | undefined = undefined;
 * @prop export let type: HTMLButtonAttributes['type'] = 'button';
 * @prop export let color: ButtonColor = group ? (outline ? 'dark' : 'alternative') : 'primary';
 * @prop export let shadow: boolean = false;
 * @prop export let tag: string = 'button';
 * @prop export let checked: boolean | undefined = undefined;
 * @prop export let disabled: boolean = false;
 */
export default class Button extends SvelteComponentTyped<ButtonProps, ButtonEvents, ButtonSlots> {
}
export {};
