import { SvelteComponentTyped } from "svelte";
import type { TransitionTypes, TransitionParamTypes } from '../types';
declare const __propDef: {
    props: {
        [x: string]: any;
        tag?: string | undefined;
        open?: boolean | undefined;
        activeClass?: string | undefined;
        inactiveClass?: string | undefined;
        defaultClass?: string | undefined;
        transitionType?: TransitionTypes | undefined;
        transitionParams?: TransitionParamTypes | undefined;
        paddingFlush?: string | undefined;
        paddingDefault?: string | undefined;
        textFlushOpen?: string | undefined;
        textFlushDefault?: string | undefined;
        borderClass?: string | undefined;
        borderOpenClass?: string | undefined;
        borderBottomClass?: string | undefined;
        borderSharedClass?: string | undefined;
        classActive?: string | undefined;
        classInactive?: string | undefined;
    };
    events: {
        [evt: string]: CustomEvent<any>;
    };
    slots: {
        header: {};
        arrowup: {};
        arrowdown: {};
        default: {};
    };
};
export type AccordionItemProps = typeof __propDef.props;
export type AccordionItemEvents = typeof __propDef.events;
export type AccordionItemSlots = typeof __propDef.slots;
/**
 * [Go to docs](https://flowbite-svelte.com/)
 * ## Props
 * @prop export let tag: string = 'h2';
 * @prop export let open: boolean = false;
 * @prop export let activeClass: string | undefined = undefined;
 * @prop export let inactiveClass: string | undefined = undefined;
 * @prop export let defaultClass: string = 'flex items-center justify-between w-full font-medium text-left group-first:rounded-t-xl border-gray-200 dark:border-gray-700';
 * @prop export let transitionType: TransitionTypes = 'slide';
 * @prop export let transitionParams: TransitionParamTypes = {};
 * @prop export let paddingFlush: string = 'py-5';
 * @prop export let paddingDefault: string = 'p-5';
 * @prop export let textFlushOpen: string = 'text-gray-900 dark:text-white';
 * @prop export let textFlushDefault: string = 'text-gray-500 dark:text-gray-400';
 * @prop export let borderClass: string = 'border-s border-e group-first:border-t';
 * @prop export let borderOpenClass: string = 'border-s border-e';
 * @prop export let borderBottomClass: string = 'border-b';
 * @prop export let borderSharedClass: string = 'border-gray-200 dark:border-gray-700';
 * @prop export let classActive: string | undefined = undefined;
 * @prop export let classInactive: string | undefined = undefined;
 */
export default class AccordionItem extends SvelteComponentTyped<AccordionItemProps, AccordionItemEvents, AccordionItemSlots> {
}
export {};
