import { SvelteComponentTyped } from "svelte";
declare const __propDef: {
    props: {
        [x: string]: any;
        size?: "xs" | "sm" | "md" | "lg" | "xl" | undefined;
        role?: string | undefined;
        color?: string | undefined;
        withEvents?: boolean | undefined;
        title?: {
            id?: string | undefined;
            title?: string | undefined;
        } | undefined;
        desc?: {
            id?: string | undefined;
            desc?: string | undefined;
        } | undefined;
        ariaLabel?: string | undefined;
    };
    events: {
        click: MouseEvent;
        keydown: KeyboardEvent;
        keyup: KeyboardEvent;
        focus: FocusEvent;
        blur: FocusEvent;
        mouseenter: MouseEvent;
        mouseleave: MouseEvent;
        mouseover: MouseEvent;
        mouseout: MouseEvent;
    } & {
        [evt: string]: CustomEvent<any>;
    };
    slots: {};
};
export type UsersGroupSolidProps = typeof __propDef.props;
export type UsersGroupSolidEvents = typeof __propDef.events;
export type UsersGroupSolidSlots = typeof __propDef.slots;
/**
 * [Go to docs](https://flowbite-svelte-icons.codewithshin.com/)
 * ## Props
 * @prop export let size: Props['size'] = ctx.size || 'md';
 * @prop export let role: Props['role'] = ctx.role || 'img';
 * @prop export let color: Props['color'] = ctx.color || 'currentColor';
 * @prop export let withEvents: Props['withEvents'] = ctx.withEvents || false;
 * @prop export let title: TitleType = {};
 * @prop export let desc: DescType = {};
 * @prop export let ariaLabel = 'users group solid';
 */
export default class UsersGroupSolid extends SvelteComponentTyped<UsersGroupSolidProps, UsersGroupSolidEvents, UsersGroupSolidSlots> {
}
export {};
