import { SvelteComponentTyped } from "svelte";
declare const __propDef: {
    props: {
        [x: string]: any;
        size?: "xs" | "sm" | "md" | "lg" | "xl" | undefined;
        role?: string | undefined;
        color?: string | undefined;
        withEvents?: boolean | undefined;
        title?: {
            id?: string | undefined;
            title?: string | undefined;
        } | undefined;
        strokeWidth?: string | undefined;
        desc?: {
            id?: string | undefined;
            desc?: string | undefined;
        } | undefined;
        ariaLabel?: string | undefined;
    };
    events: {
        click: MouseEvent;
        keydown: KeyboardEvent;
        keyup: KeyboardEvent;
        focus: FocusEvent;
        blur: FocusEvent;
        mouseenter: MouseEvent;
        mouseleave: MouseEvent;
        mouseover: MouseEvent;
        mouseout: MouseEvent;
    } & {
        [evt: string]: CustomEvent<any>;
    };
    slots: {};
};
export type LockTimeOutlineProps = typeof __propDef.props;
export type LockTimeOutlineEvents = typeof __propDef.events;
export type LockTimeOutlineSlots = typeof __propDef.slots;
/**
 * [Go to docs](https://flowbite-svelte-icons.codewithshin.com/)
 * ## Props
 * @prop export let size: Props['size'] = ctx.size || 'md';
 * @prop export let role: Props['role'] = ctx.role || 'img';
 * @prop export let color: Props['color'] = ctx.color || 'currentColor';
 * @prop export let withEvents: Props['withEvents'] = ctx.withEvents || false;
 * @prop export let title: TitleType = {};
 * @prop export let strokeWidth: Props['strokeWidth'] = ctx.strokeWidth || '2';
 * @prop export let desc: DescType = {};
 * @prop export let ariaLabel = 'lock time outline';
 */
export default class LockTimeOutline extends SvelteComponentTyped<LockTimeOutlineProps, LockTimeOutlineEvents, LockTimeOutlineSlots> {
}
export {};
