// Prevents additional console window on Windows in release, DO NOT REMOVE!!
#![cfg_attr(
    all(not(debug_assertions), target_os = "windows"),
    windows_subsystem = "windows"
)]

// With tauri
#[cfg(feature = "tauri")]
use menu_generator_lib::start_with_tauri;

#[cfg(feature = "tauri")]
pub fn main() {
    start_with_tauri();
}

// Without tauri
#[cfg(feature = "diesel")]
use rocket::{fs::FileServer, launch};

#[cfg(feature = "diesel")]
use menu_generator_lib::backend;

#[cfg(feature = "diesel")]
#[launch]
fn rocket() -> _ {
    use menu_generator_lib::config::Config;
    use std::path::PathBuf;

    // Get directories
    let current_dir = PathBuf::from(".");

    let config = Config::new(&current_dir);
    backend::get_rocket(current_dir).mount("/", FileServer::from(config.frontend_path()))
}
