import v8 from 'node:v8';
import { c as createForksRpcOptions, u as unwrapSerializableConfig } from '../chunks/utils.Cn0zI1t3.js';
import { r as runVmTests } from '../chunks/vm.CPXwWp4C.js';
import '@vitest/utils';
import 'node:vm';
import 'node:url';
import 'pathe';
import '../chunks/console.DI3gHgtH.js';
import 'node:stream';
import 'node:console';
import 'node:path';
import 'tinyrainbow';
import '../chunks/date.W2xKR2qe.js';
import '@vitest/runner/utils';
import '../chunks/utils.Ck2hJTRs.js';
import '../chunks/env.CmHVDJnw.js';
import 'std-env';
import '../chunks/execute._eQQfgI8.js';
import 'node:fs';
import 'vite-node/client';
import 'vite-node/utils';
import '@vitest/utils/error';
import '../path.js';
import '@vitest/mocker';
import 'node:module';
import 'vite-node/constants';

class ForksVmWorker {
  getRpcOptions() {
    return createForksRpcOptions(v8);
  }
  async executeTests(method, state) {
    const exit = process.exit;
    state.ctx.config = unwrapSerializableConfig(state.ctx.config);
    try {
      await runVmTests(method, state);
    } finally {
      process.exit = exit;
    }
  }
  runTests(state) {
    return this.executeTests("run", state);
  }
  collectTests(state) {
    return this.executeTests("collect", state);
  }
}
var vmForks = new ForksVmWorker();

export { vmForks as default };
