import { UserConfig as UserConfig$1, Plugin, ResolvedConfig as ResolvedConfig$1, createServer as createServer$1 } from 'vite';
import * as vite from 'vite';
export { vite as Vite };
export { createLogger as createViteLogger, isFileServingAllowed, parseAst, parseAstAsync } from 'vite';
import { w as VitestRunMode, z as UserConfig, H as VitestOptions, V as Vitest, E as ResolvedConfig, J as WorkspaceProject, A as ApiConfig, L as Logger, K as TestSequencer, M as WorkspaceSpec, N as TestModule, O as ModuleDiagnostic } from './chunks/reporters.WnPwkmgA.js';
export { B as BaseCoverageOptions, G as BenchmarkUserOptions, a5 as BrowserBuiltinProvider, a6 as BrowserCommand, a7 as BrowserCommandContext, s as BrowserConfigOptions, ab as BrowserOrchestrator, a0 as BrowserProvider, $ as BrowserProviderInitializationOptions, a2 as BrowserProviderModule, a4 as BrowserProviderOptions, r as BrowserScript, a8 as BrowserServer, a9 as BrowserServerState, aa as BrowserServerStateContext, t as BuiltinEnvironment, a1 as CDPSession, v as CSSModuleScopeStrategy, o as CoverageIstanbulOptions, n as CoverageOptions, C as CoverageProvider, a as CoverageProviderModule, l as CoverageReporter, b as CoverageV8Options, p as CustomProviderOptions, D as DepsOptimizationOptions, ae as HTMLOptions, I as InlineConfig, ad as JUnitOptions, ac as JsonOptions, P as Pool, u as PoolOptions, Q as ProcessPool, F as ProjectConfig, k as ReportContext, a3 as ResolvedBrowserOptions, R as ResolvedCoverageOptions, ap as ResolvedProjectConfig, aj as TaskOptions, af as TestCase, ai as TestCollection, ak as TestDiagnostic, ah as TestProject, al as TestResult, an as TestResultFailed, am as TestResultPassed, ao as TestResultSkipped, _ as TestSequencerConstructor, Z as TestSpecification, ag as TestSuite, x as TransformModePatterns, g as TypeCheckCollectLineNumbers, h as TypeCheckCollectLines, j as TypeCheckContext, T as TypeCheckErrorInfo, f as TypeCheckRawErrorsMap, i as TypeCheckRootAndTarget, y as TypecheckConfig, U as UserWorkspaceConfig, e as VitestEnvironment, Y as VitestPackageInstaller, X as getFilePoolName } from './chunks/reporters.WnPwkmgA.js';
import { Writable } from 'node:stream';
import { P as ProvidedContext } from './chunks/environment.C5eAp3K6.js';
export { f as EnvironmentOptions, H as HappyDOMOptions, J as JSDOMOptions, O as OnServerRestartHandler } from './chunks/environment.C5eAp3K6.js';
import { R as RuntimeRPC } from './chunks/worker.CmPmTxgH.js';
import createDebug from 'debug';
export { W as WorkerContext } from './chunks/worker.Bws9Zuxu.js';
export { SequenceHooks, SequenceSetupFiles } from '@vitest/runner';
export { b as RuntimeConfig } from './chunks/config.CHuotKvS.js';
import '@vitest/pretty-format';
import 'vite-node';
import '@vitest/snapshot';
import 'vite-node/client';
import '@vitest/snapshot/manager';
import 'vite-node/server';
import '@vitest/utils';
import '@vitest/utils/source-map';
import 'node:fs';
import 'chai';
import './chunks/benchmark.puBFxyfE.js';
import '@vitest/runner/utils';
import 'tinybench';
import 'node:worker_threads';
import '@vitest/snapshot/environment';

declare function createVitest(mode: VitestRunMode, options: UserConfig, viteOverrides?: UserConfig$1, vitestOptions?: VitestOptions): Promise<Vitest>;

declare function VitestPlugin(options?: UserConfig, ctx?: Vitest): Promise<Plugin[]>;

interface CliOptions extends UserConfig {
    /**
     * Override the watch mode
     */
    run?: boolean;
    /**
     * Removes colors from the console output
     */
    color?: boolean;
    /**
     * Output collected tests as JSON or to a file
     */
    json?: string | boolean;
    /**
     * Output collected test files only
     */
    filesOnly?: boolean;
}
/**
 * Start Vitest programmatically
 *
 * Returns a Vitest instance if initialized successfully.
 */
declare function startVitest(mode: VitestRunMode, cliFilters?: string[], options?: CliOptions, viteOverrides?: UserConfig$1, vitestOptions?: VitestOptions): Promise<Vitest | undefined>;

interface CLIOptions {
    allowUnknownOptions?: boolean;
}
declare function parseCLI(argv: string | string[], config?: CLIOptions): {
    filter: string[];
    options: CliOptions;
};

declare function registerConsoleShortcuts(ctx: Vitest, stdin: NodeJS.ReadStream | undefined, stdout: NodeJS.WriteStream | Writable): () => void;

interface GlobalSetupContext {
    config: ResolvedConfig;
    provide: <T extends keyof ProvidedContext & string>(key: T, value: ProvidedContext[T]) => void;
}

interface MethodsOptions {
    cacheFs?: boolean;
}
declare function createMethodsRPC(project: WorkspaceProject, options?: MethodsOptions): RuntimeRPC;

declare function createDebugger(namespace: `vitest:${string}`): createDebug.Debugger | undefined;

declare function resolveFsAllow(projectRoot: string, rootConfigFile: string | false | undefined): string[];

declare function resolveApiServerConfig<Options extends ApiConfig & UserConfig>(options: Options, defaultPort: number): ApiConfig | undefined;
declare function resolveConfig(mode: VitestRunMode, options: UserConfig, viteConfig: ResolvedConfig$1, logger: Logger): ResolvedConfig;

declare class FilesNotFoundError extends Error {
    code: string;
    constructor(mode: 'test' | 'benchmark');
}
declare class GitNotFoundError extends Error {
    code: string;
    constructor();
}

declare const rootDir: string;
declare const distDir: string;

declare class BaseSequencer implements TestSequencer {
    protected ctx: Vitest;
    constructor(ctx: Vitest);
    shard(files: WorkspaceSpec[]): Promise<WorkspaceSpec[]>;
    sort(files: WorkspaceSpec[]): Promise<WorkspaceSpec[]>;
}

/** @deprecated use `createViteServer` instead */
declare const createServer: typeof createServer$1;
declare const createViteServer: typeof createServer$1;

/**
 * @deprecated Use `TestModule` instead
 */
declare const TestFile: typeof TestModule;

/**
 * @deprecated Use `ModuleDiagnostic` instead
 */
type FileDiagnostic = ModuleDiagnostic;

export { ApiConfig, BaseSequencer, type FileDiagnostic, GitNotFoundError, type GlobalSetupContext, ModuleDiagnostic, ResolvedConfig, TestFile, TestModule, TestSequencer, FilesNotFoundError as TestsNotFoundError, UserConfig, Vitest, VitestPlugin, VitestRunMode, WorkspaceProject, WorkspaceSpec, createDebugger, createMethodsRPC, createServer, createViteServer, createVitest, distDir, parseCLI, registerConsoleShortcuts, resolveApiServerConfig, resolveConfig, resolveFsAllow, rootDir, startVitest };
