import { SvelteComponentTyped } from "svelte";
import type { Placement } from '@floating-ui/dom';
declare const __propDef: {
    props: import("svelte/elements").HTMLAnchorAttributes & {
        tag?: string;
        color?: import("./Frame.svelte").FrameColor;
        rounded?: boolean;
        border?: boolean;
        shadow?: boolean;
        node?: HTMLElement | undefined;
        use?: import("svelte/action").Action<HTMLElement, any>;
        options?: object;
        class?: string;
        role?: string;
        open?: boolean;
        transition?: (node: HTMLElement, params: any) => import("svelte/transition").TransitionConfig;
        params?: any;
    } & {
        activeContent?: boolean;
        arrow?: boolean;
        offset?: number;
        placement?: Placement;
        trigger?: "hover" | "click" | "focus";
        triggeredBy?: string;
        reference?: string;
        strategy?: "absolute" | "fixed";
        open?: boolean;
        yOnly?: boolean;
    };
    events: {
        show: CustomEvent<any>;
    } & {
        [evt: string]: CustomEvent<any>;
    };
    slots: {
        default: {};
    };
};
export type PopperProps = typeof __propDef.props;
export type PopperEvents = typeof __propDef.events;
export type PopperSlots = typeof __propDef.slots;
/**
 * [Go to docs](https://flowbite-svelte.com/)
 * ## Props
 * @prop export let activeContent: boolean = false;
 * @prop export let arrow: boolean = true;
 * @prop export let offset: number = 8;
 * @prop export let placement: Placement = 'top';
 * @prop export let trigger: 'hover' | 'click' | 'focus' = 'hover';
 * @prop export let triggeredBy: string | undefined = undefined;
 * @prop export let reference: string | undefined = undefined;
 * @prop export let strategy: 'absolute' | 'fixed' = 'absolute';
 * @prop export let open: boolean = false;
 * @prop export let yOnly: boolean = false;
 * @prop export let middlewares: Middleware[] = [dom.flip(), dom.shift()];
 */
export default class Popper extends SvelteComponentTyped<PopperProps, PopperEvents, PopperSlots> {
}
export {};
