import { SvelteComponentTyped } from "svelte";
import type { GroupTimelineType } from '../types';
declare const __propDef: {
    props: {
        [x: string]: any;
        timelines: GroupTimelineType[];
        aClass?: string | undefined;
        imgClass?: string | undefined;
        divClass?: string | undefined;
        titleClass?: string | undefined;
        spanClass?: string | undefined;
        isPrivacy?: boolean | undefined;
    };
    events: {
        [evt: string]: CustomEvent<any>;
    };
    slots: {};
};
export type GroupItemProps = typeof __propDef.props;
export type GroupItemEvents = typeof __propDef.events;
export type GroupItemSlots = typeof __propDef.slots;
/**
 * [Go to docs](https://flowbite-svelte.com/)
 * ## Props
 * @prop export let timelines: GroupTimelineType[];
 * @prop export let aClass: string = 'block items-center p-3 sm:flex hover:bg-gray-100 dark:hover:bg-gray-700';
 * @prop export let imgClass: string = 'me-3 mb-3 w-12 h-12 rounded-full sm:mb-0';
 * @prop export let divClass: string = 'text-gray-600 dark:text-gray-400';
 * @prop export let titleClass: string = 'text-base font-normal';
 * @prop export let spanClass: string = 'inline-flex items-center text-xs font-normal text-gray-500 dark:text-gray-400';
 * @prop export let isPrivacy: boolean = true;
 */
export default class GroupItem extends SvelteComponentTyped<GroupItemProps, GroupItemEvents, GroupItemSlots> {
}
export {};
