import { SvelteComponentTyped } from "svelte";
import type { Placement } from '@floating-ui/dom';
export interface SpeedCtxType {
    pill: boolean;
    tooltip: Placement | 'none';
    textOutside: boolean;
}
declare const __propDef: {
    props: {
        [x: string]: any;
        defaultClass?: string | undefined;
        popperDefaultClass?: string | undefined;
        placement?: Placement | undefined;
        pill?: boolean | undefined;
        tooltip?: (Placement | "none") | undefined;
        trigger?: ("hover" | "click" | "focus") | undefined;
        textOutside?: boolean | undefined;
        id?: string | undefined;
        name?: string | undefined;
        gradient?: boolean | undefined;
        open?: boolean | undefined;
    };
    events: {
        [evt: string]: CustomEvent<any>;
    };
    slots: {
        button: {};
        icon: {};
        default: {};
    };
};
export type SpeedDialProps = typeof __propDef.props;
export type SpeedDialEvents = typeof __propDef.events;
export type SpeedDialSlots = typeof __propDef.slots;
/**
 * [Go to docs](https://flowbite-svelte.com/)
 * ## Props
 * @prop export let defaultClass: string = 'fixed end-6 bottom-6';
 * @prop export let popperDefaultClass: string = 'flex items-center mb-4 gap-2';
 * @prop export let placement: Placement = 'top';
 * @prop export let pill: boolean = true;
 * @prop export let tooltip: Placement | 'none' = 'left';
 * @prop export let trigger: 'hover' | 'click' | 'focus' = 'hover';
 * @prop export let textOutside: boolean = false;
 * @prop export let id: string = generateId();
 * @prop export let name: string = 'Open actions menu';
 * @prop export let gradient: boolean = false;
 * @prop export let open: boolean = false;
 */
export default class SpeedDial extends SvelteComponentTyped<SpeedDialProps, SpeedDialEvents, SpeedDialSlots> {
}
export {};
