import { SvelteComponentTyped } from "svelte";
import type { ComponentType } from 'svelte';
import type { HTMLAttributes } from 'svelte/elements';
declare const __propDef: {
    props: HTMLAttributes<HTMLDivElement> & {
        divClass?: string;
        size?: number;
        total?: number;
        rating: number;
        partialId?: string;
        icon?: ComponentType;
        count?: boolean;
        iconFillColor?: string;
        iconStrokeColor?: string;
    };
    events: {
        [evt: string]: CustomEvent<any>;
    };
    slots: {
        default: {};
        text: {};
    };
};
export type RatingProps = typeof __propDef.props;
export type RatingEvents = typeof __propDef.events;
export type RatingSlots = typeof __propDef.slots;
/**
 * [Go to docs](https://flowbite-svelte.com/)
 * ## Props
 * @prop export let divClass: $$Props['divClass'] = 'flex items-center';
 * @prop export let size: $$Props['size'] = 24;
 * @prop export let total: NonNullable<$$Props['total']> = 5;
 * @prop export let rating: $$Props['rating'] = 4;
 * @prop export let partialId: $$Props['partialId'] = 'partialStar' + generateId();
 * @prop export let icon: $$Props['icon'] = Star;
 * @prop export let count: $$Props['count'] = false;
 * @prop export let iconFillColor: $$Props['iconFillColor'];
 * @prop export let iconStrokeColor: $$Props['iconStrokeColor'];
 */
export default class Rating extends SvelteComponentTyped<RatingProps, RatingEvents, RatingSlots> {
}
export {};
