import { SvelteComponentTyped } from "svelte";
import type { SelectOptionType } from '../types';
declare const __propDef: {
    props: {
        [x: string]: any;
        items?: SelectOptionType<any>[] | undefined;
        value?: any;
        placeholder?: string | undefined;
        underline?: boolean | undefined;
        size?: ("sm" | "md" | "lg") | undefined;
        defaultClass?: string | undefined;
        underlineClass?: string | undefined;
    };
    events: {
        change: Event;
        contextmenu: MouseEvent;
        input: Event;
    } & {
        [evt: string]: CustomEvent<any>;
    };
    slots: {
        default: {};
    };
};
export type SelectProps = typeof __propDef.props;
export type SelectEvents = typeof __propDef.events;
export type SelectSlots = typeof __propDef.slots;
/**
 * [Go to docs](https://flowbite-svelte.com/)
 * ## Props
 * @prop export let items: SelectOptionType<any>[] = [];
 * @prop export let value: any = '';
 * @prop export let placeholder: string = 'Choose option ...';
 * @prop export let underline: boolean = false;
 * @prop export let size: 'sm' | 'md' | 'lg' = 'md';
 * @prop export let defaultClass: string = 'text-gray-900 disabled:text-gray-400 bg-gray-50 border border-gray-300 rounded-lg focus:ring-primary-500 focus:border-primary-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:disabled:text-gray-500 dark:focus:ring-primary-500 dark:focus:border-primary-500';
 * @prop export let underlineClass: string = 'text-gray-500 disabled:text-gray-400 bg-transparent border-0 border-b-2 border-gray-200 appearance-none dark:text-gray-400 dark:disabled:text-gray-500 dark:border-gray-700 focus:outline-none focus:ring-0 focus:border-gray-200 peer';
 */
export default class Select extends SvelteComponentTyped<SelectProps, SelectEvents, SelectSlots> {
}
export {};
