import { SvelteComponentTyped } from "svelte";
export declare const labelClass: (inline: boolean, extraClass: string) => string;
export declare const inputClass: (custom: boolean, color: FormColorType, rounded: boolean, tinted: boolean, spacing: string, extraClass: string) => string;
import type { FormColorType } from '../types';
declare const __propDef: {
    props: {
        [x: string]: any;
        color?: FormColorType | undefined;
        custom?: boolean | undefined;
        inline?: boolean | undefined;
        group?: number | string | undefined;
        value?: (number | string) | undefined;
        spacing?: string | undefined;
        checked?: boolean | undefined;
    };
    events: {
        blur: FocusEvent;
        change: Event;
        click: MouseEvent;
        focus: FocusEvent;
        keydown: KeyboardEvent;
        keypress: KeyboardEvent;
        keyup: KeyboardEvent;
        mouseenter: MouseEvent;
        mouseleave: MouseEvent;
        mouseover: MouseEvent;
        paste: ClipboardEvent;
    } & {
        [evt: string]: CustomEvent<any>;
    };
    slots: {
        default: {};
    };
};
export type RadioProps = typeof __propDef.props;
export type RadioEvents = typeof __propDef.events;
export type RadioSlots = typeof __propDef.slots;
/**
 * [Go to docs](https://flowbite-svelte.com/)
 * ## Props
 * @prop export let color: FormColorType = 'primary';
 * @prop export let custom: boolean = false;
 * @prop export let inline: boolean = false;
 * @prop export let group: number | string | undefined = undefined;
 * @prop export let value: number | string = '';
 * @prop export let spacing: string = $$slots.default ? 'me-2' : '';
 * @prop export let checked: boolean = false;
 */
export default class Radio extends SvelteComponentTyped<RadioProps, RadioEvents, RadioSlots> {
}
export {};
