import { SvelteComponentTyped } from "svelte";
import type { ButtonColorType, SizeType } from '../types';
declare const __propDef: {
    props: {
        [x: string]: any;
        group?: (string | number)[] | undefined;
        value?: (string | number) | undefined;
        checked?: boolean | undefined;
        inline?: boolean | undefined;
        pill?: boolean | undefined;
        outline?: boolean | undefined;
        size?: SizeType | undefined;
        color?: ButtonColorType | undefined;
        shadow?: boolean | undefined;
    };
    events: {
        keyup: KeyboardEvent;
        keydown: KeyboardEvent;
        keypress: KeyboardEvent;
        focus: FocusEvent;
        blur: FocusEvent;
        click: MouseEvent;
        mouseover: MouseEvent;
        mouseenter: MouseEvent;
        mouseleave: MouseEvent;
        paste: ClipboardEvent;
        change: Event;
    } & {
        [evt: string]: CustomEvent<any>;
    };
    slots: {
        default: {};
    };
};
export type CheckboxButtonProps = typeof __propDef.props;
export type CheckboxButtonEvents = typeof __propDef.events;
export type CheckboxButtonSlots = typeof __propDef.slots;
/**
 * [Go to docs](https://flowbite-svelte.com/)
 * ## Props
 * @prop export let group: (string | number)[] = [];
 * @prop export let value: string | number = 'on';
 * @prop export let checked: boolean | undefined = undefined;
 * @prop export let inline: boolean = true;
 * @prop export let pill: boolean = false;
 * @prop export let outline: boolean = false;
 * @prop export let size: SizeType | undefined = undefined;
 * @prop export let color: ButtonColorType | undefined = undefined;
 * @prop export let shadow: boolean = false;
 */
export default class CheckboxButton extends SvelteComponentTyped<CheckboxButtonProps, CheckboxButtonEvents, CheckboxButtonSlots> {
}
export {};
