import { SvelteComponentTyped } from "svelte";
import type { FormColorType } from '../types';
import type { CheckboxItem } from '../types';
declare const __propDef: {
    props: {
        [x: string]: any;
        name?: string | undefined;
        color?: FormColorType | undefined;
        custom?: boolean | undefined;
        inline?: boolean | undefined;
        group?: string[] | undefined;
        choices?: CheckboxItem[] | undefined;
        value?: (string | number) | undefined;
        checked?: boolean | undefined;
        spacing?: string | undefined;
        groupLabelClass?: string | undefined;
        groupInputClass?: string | undefined;
    };
    events: {
        keyup: KeyboardEvent;
        keydown: KeyboardEvent;
        keypress: KeyboardEvent;
        focus: FocusEvent;
        blur: FocusEvent;
        click: MouseEvent;
        mouseover: MouseEvent;
        mouseenter: MouseEvent;
        mouseleave: MouseEvent;
        paste: ClipboardEvent;
        change: Event;
    } & {
        [evt: string]: CustomEvent<any>;
    };
    slots: {
        default: {};
    };
};
export type CheckboxProps = typeof __propDef.props;
export type CheckboxEvents = typeof __propDef.events;
export type CheckboxSlots = typeof __propDef.slots;
/**
 * [Go to docs](https://flowbite-svelte.com/)
 * ## Props
 * @prop export let name: string | undefined = undefined;
 * @prop export let color: FormColorType = 'primary';
 * @prop export let custom: boolean = false;
 * @prop export let inline: boolean = false;
 * @prop export let group: string[] = [];
 * @prop export let choices: CheckboxItem[] = [];
 * @prop export let value: string | number = 'on';
 * @prop export let checked: boolean | undefined = undefined;
 * @prop export let spacing: string = $$slots.default ? 'me-2' : '';
 * @prop export let groupLabelClass: string = '';
 * @prop export let groupInputClass: string = '';
 */
export default class Checkbox extends SvelteComponentTyped<CheckboxProps, CheckboxEvents, CheckboxSlots> {
}
export {};
