import { SvelteComponentTyped } from "svelte";
import type { drawerTransitionParamTypes, drawerTransitionTypes } from '../types';
declare const __propDef: {
    props: {
        [x: string]: any;
        activateClickOutside?: boolean | undefined;
        hidden?: boolean | undefined;
        position?: ("fixed" | "absolute") | undefined;
        leftOffset?: string | undefined;
        rightOffset?: string | undefined;
        topOffset?: string | undefined;
        bottomOffset?: string | undefined;
        width?: string | undefined;
        backdrop?: boolean | undefined;
        bgColor?: string | undefined;
        bgOpacity?: string | undefined;
        placement?: ("left" | "right" | "top" | "bottom") | undefined;
        id?: string | undefined;
        divClass?: string | undefined;
        transitionParams?: drawerTransitionParamTypes | undefined;
        transitionType?: drawerTransitionTypes;
    };
    events: {
        [evt: string]: CustomEvent<any>;
    };
    slots: {
        default: {
            hidden: boolean;
        };
    };
};
export type DrawerProps = typeof __propDef.props;
export type DrawerEvents = typeof __propDef.events;
export type DrawerSlots = typeof __propDef.slots;
/**
 * [Go to docs](https://flowbite-svelte.com/)
 * ## Props
 * @prop export let activateClickOutside: boolean = true;
 * @prop export let hidden: boolean = true;
 * @prop export let position: 'fixed' | 'absolute' = 'fixed';
 * @prop export let leftOffset: string = 'inset-y-0 start-0';
 * @prop export let rightOffset: string = 'inset-y-0 end-0';
 * @prop export let topOffset: string = 'inset-x-0 top-0';
 * @prop export let bottomOffset: string = 'inset-x-0 bottom-0';
 * @prop export let width: string = 'w-80';
 * @prop export let backdrop: boolean = true;
 * @prop export let bgColor: string = 'bg-gray-900';
 * @prop export let bgOpacity: string = 'bg-opacity-75';
 * @prop export let placement: 'left' | 'right' | 'top' | 'bottom' = 'left';
 * @prop export let id: string = 'drawer-example';
 * @prop export let divClass: string = 'overflow-y-auto z-50 p-4 bg-white dark:bg-gray-800';
 * @prop export let transitionParams: drawerTransitionParamTypes = {};
 * @prop export let transitionType: drawerTransitionTypes = 'fly';
 */
export default class Drawer extends SvelteComponentTyped<DrawerProps, DrawerEvents, DrawerSlots> {
}
export {};
