import { SvelteComponentTyped } from "svelte";
declare module 'svelte/elements' {
    interface HTMLAttributes<T> {
        [x: `data-${string}`]: any;
        'date-rangepicker'?: boolean;
        datepicker?: boolean;
        'datepicker-buttons'?: boolean;
        'datepicker-format'?: string;
        'datepicker-orientation'?: string;
        'datepicker-title'?: string;
    }
}
declare const __propDef: {
    props: {
        [x: string]: any;
        range?: boolean | undefined;
        datepickerButtons?: boolean | undefined;
        datepickerFormat?: string | undefined;
        datepickerOrientation?: string | undefined;
        datepickerTitle?: string | undefined;
        attribute?: string | undefined;
        inputClass?: string | undefined;
    };
    events: {
        [evt: string]: CustomEvent<any>;
    };
    slots: {
        default: {};
    };
};
export type DatepickerProps = typeof __propDef.props;
export type DatepickerEvents = typeof __propDef.events;
export type DatepickerSlots = typeof __propDef.slots;
/**
 * [Go to docs](https://flowbite-svelte.com/)
 * ## Props
 * @prop export let range: boolean = false;
 * @prop export let autoHide: boolean = false;
 * @prop export let datepickerButtons: boolean = false;
 * @prop export let datepickerFormat: string = 'mm/dd/yyyy';
 * @prop export let datepickerOrientation: string = 'bottom';
 * @prop export let datepickerTitle: string = 'Flowbite datepicker';
 * @prop export let attribute: string = '';
 * @prop export let inputClass: string = 'bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full ps-10 p-2.5  dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500';
 */
export default class Datepicker extends SvelteComponentTyped<DatepickerProps, DatepickerEvents, DatepickerSlots> {
}
export {};
