import { SvelteComponentTyped } from "svelte";
import { type TransitionConfig } from 'svelte/transition';
declare const __propDef: {
    props: {
        [x: string]: any;
        position?: ("static" | "fixed" | "absolute" | "relative" | "sticky") | undefined;
        dismissable?: boolean | undefined;
        bannerType?: ("default" | "bottom" | "cta" | "signup" | "info") | undefined;
        divClass?: string | undefined;
        innerClass?: string | undefined;
        bannerStatus?: boolean | undefined;
        transition?: ((node: HTMLElement, params: any) => TransitionConfig) | undefined;
        params?: {} | undefined;
    };
    events: {
        click: MouseEvent;
        change: CustomEvent<any>;
        keydown: CustomEvent<any>;
        keyup: CustomEvent<any>;
        focus: CustomEvent<any>;
        blur: CustomEvent<any>;
        mouseenter: CustomEvent<any>;
        mouseleave: CustomEvent<any>;
    } & {
        [evt: string]: CustomEvent<any>;
    };
    slots: {
        header: {};
        default: {};
    };
};
export type BannerProps = typeof __propDef.props;
export type BannerEvents = typeof __propDef.events;
export type BannerSlots = typeof __propDef.slots;
/**
 * [Go to docs](https://flowbite-svelte.com/)
 * ## Props
 * @prop export let position: 'static' | 'fixed' | 'absolute' | 'relative' | 'sticky' = 'sticky';
 * @prop export let dismissable: boolean = true;
 * @prop export let bannerType: 'default' | 'bottom' | 'cta' | 'signup' | 'info' = 'default';
 * @prop export let divClass: string = 'z-10 flex justify-between p-4 dark:bg-gray-700 dark:border-gray-600';
 * @prop export let innerClass: string = 'flex';
 * @prop export let bannerStatus: boolean = true;
 * @prop export let transition: TransitionFunc = fade;
 * @prop export let params = {};
 */
export default class Banner extends SvelteComponentTyped<BannerProps, BannerEvents, BannerSlots> {
}
export {};
