import { SvelteComponentTyped } from "svelte";
import { type Writable } from 'svelte/store';
export interface AccordionCtxType {
    flush: boolean;
    activeClass: string;
    inactiveClass: string;
    selected?: Writable<object>;
    classActive?: string;
    classInactive?: string;
}
declare const __propDef: {
    props: import("svelte/elements").HTMLAnchorAttributes & {
        tag?: string;
        color?: import("../utils/Frame.svelte").FrameColor;
        rounded?: boolean;
        border?: boolean;
        shadow?: boolean;
        node?: HTMLElement | undefined;
        use?: import("svelte/action").Action<HTMLElement, any>;
        options?: object;
        class?: string;
        role?: string;
        open?: boolean;
        transition?: (node: HTMLElement, params: any) => import("svelte/transition").TransitionConfig;
        params?: any;
    } & {
        multiple?: boolean;
        flush?: boolean;
        activeClass?: string;
        inactiveClass?: string;
        defaultClass?: string;
        classActive?: string;
        classInactive?: string;
    };
    events: {
        [evt: string]: CustomEvent<any>;
    };
    slots: {
        default: {};
    };
};
export type AccordionProps = typeof __propDef.props;
export type AccordionEvents = typeof __propDef.events;
export type AccordionSlots = typeof __propDef.slots;
/**
 * [Go to docs](https://flowbite-svelte.com/)
 * ## Props
 * @prop export let multiple: boolean = false;
 * @prop export let flush: boolean = false;
 * @prop export let activeClass: string = 'bg-gray-100 dark:bg-gray-800 text-gray-900 dark:text-white focus:ring-4 focus:ring-gray-200 dark:focus:ring-gray-800';
 * @prop export let inactiveClass: string = 'text-gray-500 dark:text-gray-400 hover:bg-gray-100 hover:dark:bg-gray-800';
 * @prop export let defaultClass: string = 'text-gray-500 dark:text-gray-400';
 */
export default class Accordion extends SvelteComponentTyped<AccordionProps, AccordionEvents, AccordionSlots> {
}
export {};
