package io.homeassistant.companion.android.common.compose.theme

import androidx.compose.ui.unit.dp
import androidx.compose.ui.unit.sp

/**
 * Object defining spacing constants for Home Assistant UI components.
 */
object HADimens {
    val SPACE0 = 0.dp
    val SPACE1 = 4.dp
    val SPACE2 = 8.dp
    val SPACE3 = 12.dp
    val SPACE4 = 16.dp
    val SPACE5 = 20.dp
    val SPACE6 = 24.dp
    val SPACE7 = 28.dp
    val SPACE8 = 32.dp
    val SPACE9 = 36.dp
    val SPACE10 = 40.dp
    val SPACE11 = 44.dp
    val SPACE12 = 48.dp
    val SPACE13 = 52.dp
    val SPACE14 = 56.dp
    val SPACE15 = 60.dp
    val SPACE16 = 64.dp
    val SPACE17 = 68.dp
    val SPACE18 = 72.dp
    val SPACE19 = 76.dp
    val SPACE20 = 80.dp
}

/**
 * Object defining general size constants for Home Assistant UI components.
 */
object HASize {
    /** Extra extra small size (8dp, equivalent to 0.5rem). */
    val X2S = 8.dp

    /** Extra small size (10dp, equivalent to 0.625rem). */
    val XS = 10.dp

    /** Small size (12dp, equivalent to 0.75rem). */
    val S = 12.dp

    /** Medium size (14dp, equivalent to 0.875rem). */
    val M = 14.dp

    /** Large size (16dp, equivalent to 1rem). */
    val L = 16.dp

    /** Extra large size (20dp, equivalent to 1.25rem). */
    val XL = 20.dp

    /** Extra extra large size (24dp, equivalent to 1.5rem). */
    val X2L = 24.dp

    /** Extra extra extra large size (28dp, equivalent to 1.75rem). */
    val X3L = 28.dp

    /** Extra extra extra extra large size (32dp, equivalent to 2rem). */
    val X4L = 32.dp

    /** Extra extra extra extra extra large size (40dp, equivalent to 2.5rem). */
    val X5L = 40.dp
}

/**
 * Object defining radius constants for Home Assistant UI components.
 */
object HARadius {
    /** Square radius (0dp). */
    val Square = 0.dp

    /** Small radius (4dp, equivalent to 0.25rem). */
    val S = 4.dp

    /** Medium radius (8dp, equivalent to 0.5rem). */
    val M = 8.dp

    /** Large radius (12dp, equivalent to 0.75rem). */
    val L = 12.dp

    /** Extra large radius (16dp, equivalent to 1rem). */
    val XL = 16.dp

    /** Extra extra large radius (20dp, equivalent to 1.25rem). */
    val X2L = 20.dp

    /** Extra extra extra large radius (24dp, equivalent to 1.5rem). */
    val X3L = 24.dp

    /** Circle radius (50dp, equivalent to 3.125rem). */
    val Circle = 50.dp

    /** Pill radius (1000dp, equivalent to 624.9375rem, for pill shapes). */
    val Pill = 1000.dp
}

/**
 * Object defining border width constants for Home Assistant UI components.
 */
object HABorderWidth {
    /** Small border width (1dp, equivalent to 0.0625rem). */
    val S = 1.dp

    /** Medium border width (2dp, equivalent to 0.125rem). */
    val M = 2.dp

    /** Large border width (3dp, equivalent to 0.1875rem). */
    val L = 3.dp
}

/**
 * Object defining font size constants for Home Assistant UI components.
 */
object HAFontSize {
    /** Extra small font size (10sp, equivalent to 0.625rem). */
    val XS = 10.sp

    /** Small font size (12sp, equivalent to 0.75rem). */
    val S = 12.sp

    /** Medium font size (14sp, equivalent to 0.875rem). */
    val M = 14.sp

    /** Large font size (16sp, equivalent to 1rem). */
    val L = 16.sp

    /** Extra large font size (20sp, equivalent to 1.25rem). */
    val XL = 20.sp

    /** Extra extra large font size (24sp, equivalent to 1.5rem). */
    val X2L = 24.sp

    /** Extra extra extra large font size (28sp, equivalent to 1.75rem). */
    val X3L = 28.sp

    /** Extra extra extra extra large font size (32sp, equivalent to 2rem). */
    val X4L = 32.sp

    /** Extra extra extra extra extra large font size (40sp, equivalent to 2.5rem). */
    val X5L = 40.sp
}

val MaxButtonWidth = 380.dp
