package org.gradle.accessors.dm;

import org.jspecify.annotations.NullMarked;
import org.gradle.api.artifacts.MinimalExternalModuleDependency;
import org.gradle.plugin.use.PluginDependency;
import org.gradle.api.artifacts.ExternalModuleDependencyBundle;
import org.gradle.api.artifacts.MutableVersionConstraint;
import org.gradle.api.provider.Provider;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.internal.catalog.AbstractExternalDependencyFactory;
import org.gradle.api.internal.catalog.DefaultVersionCatalog;
import java.util.Map;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.api.internal.artifacts.dsl.CapabilityNotationParser;
import javax.inject.Inject;
import org.gradle.api.GradleException;

/**
 * A catalog of dependencies accessible via the {@code libs} extension.
 */
@NullMarked
public class LibrariesForLibs extends AbstractExternalDependencyFactory {

    private final AbstractExternalDependencyFactory owner = this;
    private final AccompanistLibraryAccessors laccForAccompanistLibraryAccessors = new AccompanistLibraryAccessors(owner);
    private final ActivityLibraryAccessors laccForActivityLibraryAccessors = new ActivityLibraryAccessors(owner);
    private final AndroidLibraryAccessors laccForAndroidLibraryAccessors = new AndroidLibraryAccessors(owner);
    private final AndroidxLibraryAccessors laccForAndroidxLibraryAccessors = new AndroidxLibraryAccessors(owner);
    private final CarLibraryAccessors laccForCarLibraryAccessors = new CarLibraryAccessors(owner);
    private final CoilLibraryAccessors laccForCoilLibraryAccessors = new CoilLibraryAccessors(owner);
    private final CommunityLibraryAccessors laccForCommunityLibraryAccessors = new CommunityLibraryAccessors(owner);
    private final ComposeLibraryAccessors laccForComposeLibraryAccessors = new ComposeLibraryAccessors(owner);
    private final CoreLibraryAccessors laccForCoreLibraryAccessors = new CoreLibraryAccessors(owner);
    private final CronetLibraryAccessors laccForCronetLibraryAccessors = new CronetLibraryAccessors(owner);
    private final FirebaseLibraryAccessors laccForFirebaseLibraryAccessors = new FirebaseLibraryAccessors(owner);
    private final FragmentLibraryAccessors laccForFragmentLibraryAccessors = new FragmentLibraryAccessors(owner);
    private final HazeLibraryAccessors laccForHazeLibraryAccessors = new HazeLibraryAccessors(owner);
    private final HiltLibraryAccessors laccForHiltLibraryAccessors = new HiltLibraryAccessors(owner);
    private final IconicsLibraryAccessors laccForIconicsLibraryAccessors = new IconicsLibraryAccessors(owner);
    private final JunitLibraryAccessors laccForJunitLibraryAccessors = new JunitLibraryAccessors(owner);
    private final KotlinLibraryAccessors laccForKotlinLibraryAccessors = new KotlinLibraryAccessors(owner);
    private final KotlinxLibraryAccessors laccForKotlinxLibraryAccessors = new KotlinxLibraryAccessors(owner);
    private final LeakcanaryLibraryAccessors laccForLeakcanaryLibraryAccessors = new LeakcanaryLibraryAccessors(owner);
    private final LintLibraryAccessors laccForLintLibraryAccessors = new LintLibraryAccessors(owner);
    private final Media3LibraryAccessors laccForMedia3LibraryAccessors = new Media3LibraryAccessors(owner);
    private final NavigationLibraryAccessors laccForNavigationLibraryAccessors = new NavigationLibraryAccessors(owner);
    private final OkhttpLibraryAccessors laccForOkhttpLibraryAccessors = new OkhttpLibraryAccessors(owner);
    private final PagingLibraryAccessors laccForPagingLibraryAccessors = new PagingLibraryAccessors(owner);
    private final PlayLibraryAccessors laccForPlayLibraryAccessors = new PlayLibraryAccessors(owner);
    private final PreferenceLibraryAccessors laccForPreferenceLibraryAccessors = new PreferenceLibraryAccessors(owner);
    private final RetrofitLibraryAccessors laccForRetrofitLibraryAccessors = new RetrofitLibraryAccessors(owner);
    private final ScreenshotLibraryAccessors laccForScreenshotLibraryAccessors = new ScreenshotLibraryAccessors(owner);
    private final SentryLibraryAccessors laccForSentryLibraryAccessors = new SentryLibraryAccessors(owner);
    private final ToolsLibraryAccessors laccForToolsLibraryAccessors = new ToolsLibraryAccessors(owner);
    private final WearLibraryAccessors laccForWearLibraryAccessors = new WearLibraryAccessors(owner);
    private final VersionAccessors vaccForVersionAccessors = new VersionAccessors(providers, config);
    private final BundleAccessors baccForBundleAccessors = new BundleAccessors(objects, providers, config, attributesFactory, capabilityNotationParser);
    private final PluginAccessors paccForPluginAccessors = new PluginAccessors(providers, config);

    @Inject
    public LibrariesForLibs(DefaultVersionCatalog config, ProviderFactory providers, ObjectFactory objects, AttributesFactory attributesFactory, CapabilityNotationParser capabilityNotationParser) {
        super(config, providers, objects, attributesFactory, capabilityNotationParser);
    }

    /**
     * Dependency provider for <b>appcompat</b> with <b>androidx.appcompat:appcompat</b> coordinates and
     * with version reference <b>appcompat</b>
     * <p>
     * This dependency was declared in catalog libs.versions.toml
     */
    public Provider<MinimalExternalModuleDependency> getAppcompat() {
        return create("appcompat");
    }

    /**
     * Dependency provider for <b>biometric</b> with <b>androidx.biometric:biometric</b> coordinates and
     * with version reference <b>biometric</b>
     * <p>
     * This dependency was declared in catalog libs.versions.toml
     */
    public Provider<MinimalExternalModuleDependency> getBiometric() {
        return create("biometric");
    }

    /**
     * Dependency provider for <b>blurView</b> with <b>com.github.Dimezis:BlurView</b> coordinates and
     * with version reference <b>blurView</b>
     * <p>
     * This dependency was declared in catalog libs.versions.toml
     */
    public Provider<MinimalExternalModuleDependency> getBlurView() {
        return create("blurView");
    }

    /**
     * Dependency provider for <b>changeLog</b> with <b>com.github.AppDevNext:ChangeLog</b> coordinates and
     * with version reference <b>changeLog</b>
     * <p>
     * This dependency was declared in catalog libs.versions.toml
     */
    public Provider<MinimalExternalModuleDependency> getChangeLog() {
        return create("changeLog");
    }

    /**
     * Dependency provider for <b>constraintlayout</b> with <b>androidx.constraintlayout:constraintlayout</b> coordinates and
     * with version reference <b>constraintlayout</b>
     * <p>
     * This dependency was declared in catalog libs.versions.toml
     */
    public Provider<MinimalExternalModuleDependency> getConstraintlayout() {
        return create("constraintlayout");
    }

    /**
     * Dependency provider for <b>emojiJava</b> with <b>com.vdurmont:emoji-java</b> coordinates and
     * with version reference <b>emojiJava</b>
     * <p>
     * This dependency was declared in catalog libs.versions.toml
     */
    public Provider<MinimalExternalModuleDependency> getEmojiJava() {
        return create("emojiJava");
    }

    /**
     * Dependency provider for <b>guava</b> with <b>com.google.guava:guava</b> coordinates and
     * with version reference <b>guava</b>
     * <p>
     * This dependency was declared in catalog libs.versions.toml
     */
    public Provider<MinimalExternalModuleDependency> getGuava() {
        return create("guava");
    }

    /**
     * Dependency provider for <b>improv</b> with <b>org.openhomefoundation.improv-wifi:sdk-android</b> coordinates and
     * with version reference <b>improv</b>
     * <p>
     * This dependency was declared in catalog libs.versions.toml
     */
    public Provider<MinimalExternalModuleDependency> getImprov() {
        return create("improv");
    }

    /**
     * Dependency provider for <b>material</b> with <b>com.google.android.material:material</b> coordinates and
     * with version reference <b>material</b>
     * <p>
     * This dependency was declared in catalog libs.versions.toml
     */
    public Provider<MinimalExternalModuleDependency> getMaterial() {
        return create("material");
    }

    /**
     * Dependency provider for <b>mockk</b> with <b>io.mockk:mockk</b> coordinates and
     * with version reference <b>mockk</b>
     * <p>
     * This dependency was declared in catalog libs.versions.toml
     */
    public Provider<MinimalExternalModuleDependency> getMockk() {
        return create("mockk");
    }

    /**
     * Dependency provider for <b>recyclerview</b> with <b>androidx.recyclerview:recyclerview</b> coordinates and
     * with version reference <b>recyclerview</b>
     * <p>
     * This dependency was declared in catalog libs.versions.toml
     */
    public Provider<MinimalExternalModuleDependency> getRecyclerview() {
        return create("recyclerview");
    }

    /**
     * Dependency provider for <b>reorderable</b> with <b>sh.calvin.reorderable:reorderable</b> coordinates and
     * with version reference <b>reorderable</b>
     * <p>
     * This dependency was declared in catalog libs.versions.toml
     */
    public Provider<MinimalExternalModuleDependency> getReorderable() {
        return create("reorderable");
    }

    /**
     * Dependency provider for <b>robolectric</b> with <b>org.robolectric:robolectric</b> coordinates and
     * with version reference <b>robolectric</b>
     * <p>
     * This dependency was declared in catalog libs.versions.toml
     */
    public Provider<MinimalExternalModuleDependency> getRobolectric() {
        return create("robolectric");
    }

    /**
     * Dependency provider for <b>timber</b> with <b>com.jakewharton.timber:timber</b> coordinates and
     * with version reference <b>timber</b>
     * <p>
     * This dependency was declared in catalog libs.versions.toml
     */
    public Provider<MinimalExternalModuleDependency> getTimber() {
        return create("timber");
    }

    /**
     * Dependency provider for <b>turbine</b> with <b>app.cash.turbine:turbine</b> coordinates and
     * with version reference <b>turbine</b>
     * <p>
     * This dependency was declared in catalog libs.versions.toml
     */
    public Provider<MinimalExternalModuleDependency> getTurbine() {
        return create("turbine");
    }

    /**
     * Dependency provider for <b>webkit</b> with <b>androidx.webkit:webkit</b> coordinates and
     * with version reference <b>webkit</b>
     * <p>
     * This dependency was declared in catalog libs.versions.toml
     */
    public Provider<MinimalExternalModuleDependency> getWebkit() {
        return create("webkit");
    }

    /**
     * Dependency provider for <b>zxing</b> with <b>com.journeyapps:zxing-android-embedded</b> coordinates and
     * with version reference <b>zxing</b>
     * <p>
     * This dependency was declared in catalog libs.versions.toml
     */
    public Provider<MinimalExternalModuleDependency> getZxing() {
        return create("zxing");
    }

    /**
     * Group of libraries at <b>accompanist</b>
     */
    public AccompanistLibraryAccessors getAccompanist() {
        return laccForAccompanistLibraryAccessors;
    }

    /**
     * Group of libraries at <b>activity</b>
     */
    public ActivityLibraryAccessors getActivity() {
        return laccForActivityLibraryAccessors;
    }

    /**
     * Group of libraries at <b>android</b>
     */
    public AndroidLibraryAccessors getAndroid() {
        return laccForAndroidLibraryAccessors;
    }

    /**
     * Group of libraries at <b>androidx</b>
     */
    public AndroidxLibraryAccessors getAndroidx() {
        return laccForAndroidxLibraryAccessors;
    }

    /**
     * Group of libraries at <b>car</b>
     */
    public CarLibraryAccessors getCar() {
        return laccForCarLibraryAccessors;
    }

    /**
     * Group of libraries at <b>coil</b>
     */
    public CoilLibraryAccessors getCoil() {
        return laccForCoilLibraryAccessors;
    }

    /**
     * Group of libraries at <b>community</b>
     */
    public CommunityLibraryAccessors getCommunity() {
        return laccForCommunityLibraryAccessors;
    }

    /**
     * Group of libraries at <b>compose</b>
     */
    public ComposeLibraryAccessors getCompose() {
        return laccForComposeLibraryAccessors;
    }

    /**
     * Group of libraries at <b>core</b>
     */
    public CoreLibraryAccessors getCore() {
        return laccForCoreLibraryAccessors;
    }

    /**
     * Group of libraries at <b>cronet</b>
     */
    public CronetLibraryAccessors getCronet() {
        return laccForCronetLibraryAccessors;
    }

    /**
     * Group of libraries at <b>firebase</b>
     */
    public FirebaseLibraryAccessors getFirebase() {
        return laccForFirebaseLibraryAccessors;
    }

    /**
     * Group of libraries at <b>fragment</b>
     */
    public FragmentLibraryAccessors getFragment() {
        return laccForFragmentLibraryAccessors;
    }

    /**
     * Group of libraries at <b>haze</b>
     */
    public HazeLibraryAccessors getHaze() {
        return laccForHazeLibraryAccessors;
    }

    /**
     * Group of libraries at <b>hilt</b>
     */
    public HiltLibraryAccessors getHilt() {
        return laccForHiltLibraryAccessors;
    }

    /**
     * Group of libraries at <b>iconics</b>
     */
    public IconicsLibraryAccessors getIconics() {
        return laccForIconicsLibraryAccessors;
    }

    /**
     * Group of libraries at <b>junit</b>
     */
    public JunitLibraryAccessors getJunit() {
        return laccForJunitLibraryAccessors;
    }

    /**
     * Group of libraries at <b>kotlin</b>
     */
    public KotlinLibraryAccessors getKotlin() {
        return laccForKotlinLibraryAccessors;
    }

    /**
     * Group of libraries at <b>kotlinx</b>
     */
    public KotlinxLibraryAccessors getKotlinx() {
        return laccForKotlinxLibraryAccessors;
    }

    /**
     * Group of libraries at <b>leakcanary</b>
     */
    public LeakcanaryLibraryAccessors getLeakcanary() {
        return laccForLeakcanaryLibraryAccessors;
    }

    /**
     * Group of libraries at <b>lint</b>
     */
    public LintLibraryAccessors getLint() {
        return laccForLintLibraryAccessors;
    }

    /**
     * Group of libraries at <b>media3</b>
     */
    public Media3LibraryAccessors getMedia3() {
        return laccForMedia3LibraryAccessors;
    }

    /**
     * Group of libraries at <b>navigation</b>
     */
    public NavigationLibraryAccessors getNavigation() {
        return laccForNavigationLibraryAccessors;
    }

    /**
     * Group of libraries at <b>okhttp</b>
     */
    public OkhttpLibraryAccessors getOkhttp() {
        return laccForOkhttpLibraryAccessors;
    }

    /**
     * Group of libraries at <b>paging</b>
     */
    public PagingLibraryAccessors getPaging() {
        return laccForPagingLibraryAccessors;
    }

    /**
     * Group of libraries at <b>play</b>
     */
    public PlayLibraryAccessors getPlay() {
        return laccForPlayLibraryAccessors;
    }

    /**
     * Group of libraries at <b>preference</b>
     */
    public PreferenceLibraryAccessors getPreference() {
        return laccForPreferenceLibraryAccessors;
    }

    /**
     * Group of libraries at <b>retrofit</b>
     */
    public RetrofitLibraryAccessors getRetrofit() {
        return laccForRetrofitLibraryAccessors;
    }

    /**
     * Group of libraries at <b>screenshot</b>
     */
    public ScreenshotLibraryAccessors getScreenshot() {
        return laccForScreenshotLibraryAccessors;
    }

    /**
     * Group of libraries at <b>sentry</b>
     */
    public SentryLibraryAccessors getSentry() {
        return laccForSentryLibraryAccessors;
    }

    /**
     * Group of libraries at <b>tools</b>
     */
    public ToolsLibraryAccessors getTools() {
        return laccForToolsLibraryAccessors;
    }

    /**
     * Group of libraries at <b>wear</b>
     */
    public WearLibraryAccessors getWear() {
        return laccForWearLibraryAccessors;
    }

    /**
     * Group of versions at <b>versions</b>
     */
    public VersionAccessors getVersions() {
        return vaccForVersionAccessors;
    }

    /**
     * Group of bundles at <b>bundles</b>
     */
    public BundleAccessors getBundles() {
        return baccForBundleAccessors;
    }

    /**
     * Group of plugins at <b>plugins</b>
     */
    public PluginAccessors getPlugins() {
        return paccForPluginAccessors;
    }

    public static class AccompanistLibraryAccessors extends SubDependencyFactory {

        public AccompanistLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>permissions</b> with <b>com.google.accompanist:accompanist-permissions</b> coordinates and
         * with version reference <b>accompanist</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getPermissions() {
            return create("accompanist.permissions");
        }

    }

    public static class ActivityLibraryAccessors extends SubDependencyFactory {

        public ActivityLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>compose</b> with <b>androidx.activity:activity-compose</b> coordinates and
         * with version reference <b>activity.compose</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getCompose() {
            return create("activity.compose");
        }

        /**
         * Dependency provider for <b>ktx</b> with <b>androidx.activity:activity-ktx</b> coordinates and
         * with version reference <b>activity.compose</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getKtx() {
            return create("activity.ktx");
        }

    }

    public static class AndroidLibraryAccessors extends SubDependencyFactory {
        private final AndroidBeaconLibraryAccessors laccForAndroidBeaconLibraryAccessors = new AndroidBeaconLibraryAccessors(owner);
        private final AndroidGradleLibraryAccessors laccForAndroidGradleLibraryAccessors = new AndroidGradleLibraryAccessors(owner);

        public AndroidLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Group of libraries at <b>android.beacon</b>
         */
        public AndroidBeaconLibraryAccessors getBeacon() {
            return laccForAndroidBeaconLibraryAccessors;
        }

        /**
         * Group of libraries at <b>android.gradle</b>
         */
        public AndroidGradleLibraryAccessors getGradle() {
            return laccForAndroidGradleLibraryAccessors;
        }

    }

    public static class AndroidBeaconLibraryAccessors extends SubDependencyFactory {

        public AndroidBeaconLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>library</b> with <b>org.altbeacon:android-beacon-library</b> coordinates and
         * with version reference <b>androidBeaconLibrary</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getLibrary() {
            return create("android.beacon.library");
        }

    }

    public static class AndroidGradleLibraryAccessors extends SubDependencyFactory {

        public AndroidGradleLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>plugin</b> with <b>com.android.tools.build:gradle</b> coordinates and
         * with version reference <b>androidGradlePlugin</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getPlugin() {
            return create("android.gradle.plugin");
        }

    }

    public static class AndroidxLibraryAccessors extends SubDependencyFactory {
        private final AndroidxConcurrentLibraryAccessors laccForAndroidxConcurrentLibraryAccessors = new AndroidxConcurrentLibraryAccessors(owner);
        private final AndroidxGlanceLibraryAccessors laccForAndroidxGlanceLibraryAccessors = new AndroidxGlanceLibraryAccessors(owner);
        private final AndroidxHealthLibraryAccessors laccForAndroidxHealthLibraryAccessors = new AndroidxHealthLibraryAccessors(owner);
        private final AndroidxHiltLibraryAccessors laccForAndroidxHiltLibraryAccessors = new AndroidxHiltLibraryAccessors(owner);
        private final AndroidxLifecycleLibraryAccessors laccForAndroidxLifecycleLibraryAccessors = new AndroidxLifecycleLibraryAccessors(owner);
        private final AndroidxRoomLibraryAccessors laccForAndroidxRoomLibraryAccessors = new AndroidxRoomLibraryAccessors(owner);
        private final AndroidxRuntimeLibraryAccessors laccForAndroidxRuntimeLibraryAccessors = new AndroidxRuntimeLibraryAccessors(owner);
        private final AndroidxTestLibraryAccessors laccForAndroidxTestLibraryAccessors = new AndroidxTestLibraryAccessors(owner);
        private final AndroidxWatchfaceLibraryAccessors laccForAndroidxWatchfaceLibraryAccessors = new AndroidxWatchfaceLibraryAccessors(owner);
        private final AndroidxWorkLibraryAccessors laccForAndroidxWorkLibraryAccessors = new AndroidxWorkLibraryAccessors(owner);

        public AndroidxLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>media</b> with <b>androidx.media:media</b> coordinates and
         * with version reference <b>media</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getMedia() {
            return create("androidx.media");
        }

        /**
         * Group of libraries at <b>androidx.concurrent</b>
         */
        public AndroidxConcurrentLibraryAccessors getConcurrent() {
            return laccForAndroidxConcurrentLibraryAccessors;
        }

        /**
         * Group of libraries at <b>androidx.glance</b>
         */
        public AndroidxGlanceLibraryAccessors getGlance() {
            return laccForAndroidxGlanceLibraryAccessors;
        }

        /**
         * Group of libraries at <b>androidx.health</b>
         */
        public AndroidxHealthLibraryAccessors getHealth() {
            return laccForAndroidxHealthLibraryAccessors;
        }

        /**
         * Group of libraries at <b>androidx.hilt</b>
         */
        public AndroidxHiltLibraryAccessors getHilt() {
            return laccForAndroidxHiltLibraryAccessors;
        }

        /**
         * Group of libraries at <b>androidx.lifecycle</b>
         */
        public AndroidxLifecycleLibraryAccessors getLifecycle() {
            return laccForAndroidxLifecycleLibraryAccessors;
        }

        /**
         * Group of libraries at <b>androidx.room</b>
         */
        public AndroidxRoomLibraryAccessors getRoom() {
            return laccForAndroidxRoomLibraryAccessors;
        }

        /**
         * Group of libraries at <b>androidx.runtime</b>
         */
        public AndroidxRuntimeLibraryAccessors getRuntime() {
            return laccForAndroidxRuntimeLibraryAccessors;
        }

        /**
         * Group of libraries at <b>androidx.test</b>
         */
        public AndroidxTestLibraryAccessors getTest() {
            return laccForAndroidxTestLibraryAccessors;
        }

        /**
         * Group of libraries at <b>androidx.watchface</b>
         */
        public AndroidxWatchfaceLibraryAccessors getWatchface() {
            return laccForAndroidxWatchfaceLibraryAccessors;
        }

        /**
         * Group of libraries at <b>androidx.work</b>
         */
        public AndroidxWorkLibraryAccessors getWork() {
            return laccForAndroidxWorkLibraryAccessors;
        }

    }

    public static class AndroidxConcurrentLibraryAccessors extends SubDependencyFactory {

        public AndroidxConcurrentLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>ktx</b> with <b>androidx.concurrent:concurrent-futures-ktx</b> coordinates and
         * with version reference <b>androidxConcurrent</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getKtx() {
            return create("androidx.concurrent.ktx");
        }

    }

    public static class AndroidxGlanceLibraryAccessors extends SubDependencyFactory {
        private final AndroidxGlanceAppwidgetLibraryAccessors laccForAndroidxGlanceAppwidgetLibraryAccessors = new AndroidxGlanceAppwidgetLibraryAccessors(owner);

        public AndroidxGlanceLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>material</b> with <b>androidx.glance:glance-material</b> coordinates and
         * with version reference <b>glance</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getMaterial() {
            return create("androidx.glance.material");
        }

        /**
         * Dependency provider for <b>preview</b> with <b>androidx.glance:glance-preview</b> coordinates and
         * with version reference <b>glance</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getPreview() {
            return create("androidx.glance.preview");
        }

        /**
         * Dependency provider for <b>testing</b> with <b>androidx.glance:glance-testing</b> coordinates and
         * with version reference <b>glance</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getTesting() {
            return create("androidx.glance.testing");
        }

        /**
         * Group of libraries at <b>androidx.glance.appwidget</b>
         */
        public AndroidxGlanceAppwidgetLibraryAccessors getAppwidget() {
            return laccForAndroidxGlanceAppwidgetLibraryAccessors;
        }

    }

    public static class AndroidxGlanceAppwidgetLibraryAccessors extends SubDependencyFactory implements DependencyNotationSupplier {

        public AndroidxGlanceAppwidgetLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>appwidget</b> with <b>androidx.glance:glance-appwidget</b> coordinates and
         * with version reference <b>glance</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> asProvider() {
            return create("androidx.glance.appwidget");
        }

        /**
         * Dependency provider for <b>preview</b> with <b>androidx.glance:glance-appwidget-preview</b> coordinates and
         * with version reference <b>glance</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getPreview() {
            return create("androidx.glance.appwidget.preview");
        }

        /**
         * Dependency provider for <b>testing</b> with <b>androidx.glance:glance-appwidget-testing</b> coordinates and
         * with version reference <b>glance</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getTesting() {
            return create("androidx.glance.appwidget.testing");
        }

    }

    public static class AndroidxHealthLibraryAccessors extends SubDependencyFactory {
        private final AndroidxHealthConnectLibraryAccessors laccForAndroidxHealthConnectLibraryAccessors = new AndroidxHealthConnectLibraryAccessors(owner);
        private final AndroidxHealthServicesLibraryAccessors laccForAndroidxHealthServicesLibraryAccessors = new AndroidxHealthServicesLibraryAccessors(owner);

        public AndroidxHealthLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Group of libraries at <b>androidx.health.connect</b>
         */
        public AndroidxHealthConnectLibraryAccessors getConnect() {
            return laccForAndroidxHealthConnectLibraryAccessors;
        }

        /**
         * Group of libraries at <b>androidx.health.services</b>
         */
        public AndroidxHealthServicesLibraryAccessors getServices() {
            return laccForAndroidxHealthServicesLibraryAccessors;
        }

    }

    public static class AndroidxHealthConnectLibraryAccessors extends SubDependencyFactory {

        public AndroidxHealthConnectLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>client</b> with <b>androidx.health.connect:connect-client</b> coordinates and
         * with version reference <b>connectClient</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getClient() {
            return create("androidx.health.connect.client");
        }

    }

    public static class AndroidxHealthServicesLibraryAccessors extends SubDependencyFactory {

        public AndroidxHealthServicesLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>client</b> with <b>androidx.health:health-services-client</b> coordinates and
         * with version reference <b>healthServicesClient</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getClient() {
            return create("androidx.health.services.client");
        }

    }

    public static class AndroidxHiltLibraryAccessors extends SubDependencyFactory {
        private final AndroidxHiltNavigationLibraryAccessors laccForAndroidxHiltNavigationLibraryAccessors = new AndroidxHiltNavigationLibraryAccessors(owner);

        public AndroidxHiltLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Group of libraries at <b>androidx.hilt.navigation</b>
         */
        public AndroidxHiltNavigationLibraryAccessors getNavigation() {
            return laccForAndroidxHiltNavigationLibraryAccessors;
        }

    }

    public static class AndroidxHiltNavigationLibraryAccessors extends SubDependencyFactory {

        public AndroidxHiltNavigationLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>compose</b> with <b>androidx.hilt:hilt-navigation-compose</b> coordinates and
         * with version reference <b>androidxHiltNavigationCompose</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getCompose() {
            return create("androidx.hilt.navigation.compose");
        }

    }

    public static class AndroidxLifecycleLibraryAccessors extends SubDependencyFactory {
        private final AndroidxLifecycleRuntimeLibraryAccessors laccForAndroidxLifecycleRuntimeLibraryAccessors = new AndroidxLifecycleRuntimeLibraryAccessors(owner);
        private final AndroidxLifecycleViewmodelLibraryAccessors laccForAndroidxLifecycleViewmodelLibraryAccessors = new AndroidxLifecycleViewmodelLibraryAccessors(owner);

        public AndroidxLifecycleLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>service</b> with <b>androidx.lifecycle:lifecycle-service</b> coordinates and
         * with version reference <b>lifecycle</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getService() {
            return create("androidx.lifecycle.service");
        }

        /**
         * Group of libraries at <b>androidx.lifecycle.runtime</b>
         */
        public AndroidxLifecycleRuntimeLibraryAccessors getRuntime() {
            return laccForAndroidxLifecycleRuntimeLibraryAccessors;
        }

        /**
         * Group of libraries at <b>androidx.lifecycle.viewmodel</b>
         */
        public AndroidxLifecycleViewmodelLibraryAccessors getViewmodel() {
            return laccForAndroidxLifecycleViewmodelLibraryAccessors;
        }

    }

    public static class AndroidxLifecycleRuntimeLibraryAccessors extends SubDependencyFactory {

        public AndroidxLifecycleRuntimeLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>compose</b> with <b>androidx.lifecycle:lifecycle-runtime-compose</b> coordinates and
         * with version reference <b>lifecycle</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getCompose() {
            return create("androidx.lifecycle.runtime.compose");
        }

        /**
         * Dependency provider for <b>ktx</b> with <b>androidx.lifecycle:lifecycle-runtime-ktx</b> coordinates and
         * with version reference <b>lifecycle</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getKtx() {
            return create("androidx.lifecycle.runtime.ktx");
        }

    }

    public static class AndroidxLifecycleViewmodelLibraryAccessors extends SubDependencyFactory {

        public AndroidxLifecycleViewmodelLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>ktx</b> with <b>androidx.lifecycle:lifecycle-viewmodel-ktx</b> coordinates and
         * with version reference <b>lifecycle</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getKtx() {
            return create("androidx.lifecycle.viewmodel.ktx");
        }

    }

    public static class AndroidxRoomLibraryAccessors extends SubDependencyFactory {

        public AndroidxRoomLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>compiler</b> with <b>androidx.room:room-compiler</b> coordinates and
         * with version reference <b>room</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getCompiler() {
            return create("androidx.room.compiler");
        }

        /**
         * Dependency provider for <b>ktx</b> with <b>androidx.room:room-ktx</b> coordinates and
         * with version reference <b>room</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getKtx() {
            return create("androidx.room.ktx");
        }

        /**
         * Dependency provider for <b>paging</b> with <b>androidx.room:room-paging</b> coordinates and
         * with version reference <b>room</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getPaging() {
            return create("androidx.room.paging");
        }

        /**
         * Dependency provider for <b>runtime</b> with <b>androidx.room:room-runtime</b> coordinates and
         * with version reference <b>room</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getRuntime() {
            return create("androidx.room.runtime");
        }

    }

    public static class AndroidxRuntimeLibraryAccessors extends SubDependencyFactory {

        public AndroidxRuntimeLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>lint</b> with <b>androidx.compose.runtime:runtime-lint</b> coordinates and
         * with version reference <b>runtimeLint</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getLint() {
            return create("androidx.runtime.lint");
        }

    }

    public static class AndroidxTestLibraryAccessors extends SubDependencyFactory {

        public AndroidxTestLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>core</b> with <b>androidx.test:core</b> coordinates and
         * with version reference <b>androidxTestCore</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getCore() {
            return create("androidx.test.core");
        }

        /**
         * Dependency provider for <b>ext</b> with <b>androidx.test.ext:junit-ktx</b> coordinates and
         * with version reference <b>androidxTestExt</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getExt() {
            return create("androidx.test.ext");
        }

        /**
         * Dependency provider for <b>rules</b> with <b>androidx.test:rules</b> coordinates and
         * with version reference <b>androidxTestRules</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getRules() {
            return create("androidx.test.rules");
        }

        /**
         * Dependency provider for <b>runner</b> with <b>androidx.test:runner</b> coordinates and
         * with version reference <b>androidxTestRunner</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getRunner() {
            return create("androidx.test.runner");
        }

    }

    public static class AndroidxWatchfaceLibraryAccessors extends SubDependencyFactory {
        private final AndroidxWatchfaceComplicationsLibraryAccessors laccForAndroidxWatchfaceComplicationsLibraryAccessors = new AndroidxWatchfaceComplicationsLibraryAccessors(owner);

        public AndroidxWatchfaceLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Group of libraries at <b>androidx.watchface.complications</b>
         */
        public AndroidxWatchfaceComplicationsLibraryAccessors getComplications() {
            return laccForAndroidxWatchfaceComplicationsLibraryAccessors;
        }

    }

    public static class AndroidxWatchfaceComplicationsLibraryAccessors extends SubDependencyFactory {
        private final AndroidxWatchfaceComplicationsDataLibraryAccessors laccForAndroidxWatchfaceComplicationsDataLibraryAccessors = new AndroidxWatchfaceComplicationsDataLibraryAccessors(owner);

        public AndroidxWatchfaceComplicationsLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Group of libraries at <b>androidx.watchface.complications.data</b>
         */
        public AndroidxWatchfaceComplicationsDataLibraryAccessors getData() {
            return laccForAndroidxWatchfaceComplicationsDataLibraryAccessors;
        }

    }

    public static class AndroidxWatchfaceComplicationsDataLibraryAccessors extends SubDependencyFactory {
        private final AndroidxWatchfaceComplicationsDataSourceLibraryAccessors laccForAndroidxWatchfaceComplicationsDataSourceLibraryAccessors = new AndroidxWatchfaceComplicationsDataSourceLibraryAccessors(owner);

        public AndroidxWatchfaceComplicationsDataLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Group of libraries at <b>androidx.watchface.complications.data.source</b>
         */
        public AndroidxWatchfaceComplicationsDataSourceLibraryAccessors getSource() {
            return laccForAndroidxWatchfaceComplicationsDataSourceLibraryAccessors;
        }

    }

    public static class AndroidxWatchfaceComplicationsDataSourceLibraryAccessors extends SubDependencyFactory {

        public AndroidxWatchfaceComplicationsDataSourceLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>ktx</b> with <b>androidx.wear.watchface:watchface-complications-data-source-ktx</b> coordinates and
         * with version reference <b>watchfaceComplicationsDataSourceKtx</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getKtx() {
            return create("androidx.watchface.complications.data.source.ktx");
        }

    }

    public static class AndroidxWorkLibraryAccessors extends SubDependencyFactory {
        private final AndroidxWorkRuntimeLibraryAccessors laccForAndroidxWorkRuntimeLibraryAccessors = new AndroidxWorkRuntimeLibraryAccessors(owner);

        public AndroidxWorkLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Group of libraries at <b>androidx.work.runtime</b>
         */
        public AndroidxWorkRuntimeLibraryAccessors getRuntime() {
            return laccForAndroidxWorkRuntimeLibraryAccessors;
        }

    }

    public static class AndroidxWorkRuntimeLibraryAccessors extends SubDependencyFactory {

        public AndroidxWorkRuntimeLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>ktx</b> with <b>androidx.work:work-runtime-ktx</b> coordinates and
         * with version reference <b>workRuntime</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getKtx() {
            return create("androidx.work.runtime.ktx");
        }

    }

    public static class CarLibraryAccessors extends SubDependencyFactory {

        public CarLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>automotive</b> with <b>androidx.car.app:app-automotive</b> coordinates and
         * with version reference <b>car.versions</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getAutomotive() {
            return create("car.automotive");
        }

        /**
         * Dependency provider for <b>core</b> with <b>androidx.car.app:app</b> coordinates and
         * with version reference <b>car.versions</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getCore() {
            return create("car.core");
        }

        /**
         * Dependency provider for <b>projected</b> with <b>androidx.car.app:app-projected</b> coordinates and
         * with version reference <b>car.versions</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getProjected() {
            return create("car.projected");
        }

    }

    public static class CoilLibraryAccessors extends SubDependencyFactory {

        public CoilLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>okhttp</b> with <b>io.coil-kt.coil3:coil-network-okhttp</b> coordinates and
         * with version reference <b>coil</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getOkhttp() {
            return create("coil.okhttp");
        }

        /**
         * Dependency provider for <b>svg</b> with <b>io.coil-kt.coil3:coil-svg</b> coordinates and
         * with version reference <b>coil</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getSvg() {
            return create("coil.svg");
        }

        /**
         * Dependency provider for <b>views</b> with <b>io.coil-kt.coil3:coil</b> coordinates and
         * with version reference <b>coil</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getViews() {
            return create("coil.views");
        }

    }

    public static class CommunityLibraryAccessors extends SubDependencyFactory {
        private final CommunityMaterialLibraryAccessors laccForCommunityMaterialLibraryAccessors = new CommunityMaterialLibraryAccessors(owner);

        public CommunityLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Group of libraries at <b>community.material</b>
         */
        public CommunityMaterialLibraryAccessors getMaterial() {
            return laccForCommunityMaterialLibraryAccessors;
        }

    }

    public static class CommunityMaterialLibraryAccessors extends SubDependencyFactory {

        public CommunityMaterialLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>typeface</b> with <b>com.mikepenz:community-material-typeface</b> coordinates and
         * with version reference <b>community.material.typeface</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getTypeface() {
            return create("community.material.typeface");
        }

    }

    public static class ComposeLibraryAccessors extends SubDependencyFactory {
        private final ComposeLintLibraryAccessors laccForComposeLintLibraryAccessors = new ComposeLintLibraryAccessors(owner);
        private final ComposeMaterialLibraryAccessors laccForComposeMaterialLibraryAccessors = new ComposeMaterialLibraryAccessors(owner);
        private final ComposeScreenshotLibraryAccessors laccForComposeScreenshotLibraryAccessors = new ComposeScreenshotLibraryAccessors(owner);
        private final ComposeUiLibraryAccessors laccForComposeUiLibraryAccessors = new ComposeUiLibraryAccessors(owner);

        public ComposeLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>animation</b> with <b>androidx.compose.animation:animation</b> coordinates and
         * with <b>no version specified</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getAnimation() {
            return create("compose.animation");
        }

        /**
         * Dependency provider for <b>bom</b> with <b>androidx.compose:compose-bom</b> coordinates and
         * with version reference <b>compose.bom</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getBom() {
            return create("compose.bom");
        }

        /**
         * Dependency provider for <b>foundation</b> with <b>androidx.compose.foundation:foundation</b> coordinates and
         * with <b>no version specified</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getFoundation() {
            return create("compose.foundation");
        }

        /**
         * Dependency provider for <b>material3</b> with <b>androidx.compose.material3:material3-android</b> coordinates and
         * with <b>no version specified</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getMaterial3() {
            return create("compose.material3");
        }

        /**
         * Dependency provider for <b>runtime</b> with <b>androidx.compose.runtime:runtime</b> coordinates and
         * with <b>no version specified</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getRuntime() {
            return create("compose.runtime");
        }

        /**
         * Dependency provider for <b>uiTooling</b> with <b>androidx.compose.ui:ui-tooling</b> coordinates and
         * with <b>no version specified</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getUiTooling() {
            return create("compose.uiTooling");
        }

        /**
         * Group of libraries at <b>compose.lint</b>
         */
        public ComposeLintLibraryAccessors getLint() {
            return laccForComposeLintLibraryAccessors;
        }

        /**
         * Group of libraries at <b>compose.material</b>
         */
        public ComposeMaterialLibraryAccessors getMaterial() {
            return laccForComposeMaterialLibraryAccessors;
        }

        /**
         * Group of libraries at <b>compose.screenshot</b>
         */
        public ComposeScreenshotLibraryAccessors getScreenshot() {
            return laccForComposeScreenshotLibraryAccessors;
        }

        /**
         * Group of libraries at <b>compose.ui</b>
         */
        public ComposeUiLibraryAccessors getUi() {
            return laccForComposeUiLibraryAccessors;
        }

    }

    public static class ComposeLintLibraryAccessors extends SubDependencyFactory {

        public ComposeLintLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>checks</b> with <b>com.slack.lint.compose:compose-lint-checks</b> coordinates and
         * with version reference <b>composeLintChecks</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getChecks() {
            return create("compose.lint.checks");
        }

    }

    public static class ComposeMaterialLibraryAccessors extends SubDependencyFactory implements DependencyNotationSupplier {
        private final ComposeMaterialIconsLibraryAccessors laccForComposeMaterialIconsLibraryAccessors = new ComposeMaterialIconsLibraryAccessors(owner);

        public ComposeMaterialLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>material</b> with <b>androidx.compose.material:material</b> coordinates and
         * with <b>no version specified</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> asProvider() {
            return create("compose.material");
        }

        /**
         * Group of libraries at <b>compose.material.icons</b>
         */
        public ComposeMaterialIconsLibraryAccessors getIcons() {
            return laccForComposeMaterialIconsLibraryAccessors;
        }

    }

    public static class ComposeMaterialIconsLibraryAccessors extends SubDependencyFactory {

        public ComposeMaterialIconsLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>core</b> with <b>androidx.compose.material:material-icons-core</b> coordinates and
         * with <b>no version specified</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getCore() {
            return create("compose.material.icons.core");
        }

        /**
         * Dependency provider for <b>extended</b> with <b>androidx.compose.material:material-icons-extended</b> coordinates and
         * with <b>no version specified</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getExtended() {
            return create("compose.material.icons.extended");
        }

    }

    public static class ComposeScreenshotLibraryAccessors extends SubDependencyFactory {
        private final ComposeScreenshotGradleLibraryAccessors laccForComposeScreenshotGradleLibraryAccessors = new ComposeScreenshotGradleLibraryAccessors(owner);

        public ComposeScreenshotLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Group of libraries at <b>compose.screenshot.gradle</b>
         */
        public ComposeScreenshotGradleLibraryAccessors getGradle() {
            return laccForComposeScreenshotGradleLibraryAccessors;
        }

    }

    public static class ComposeScreenshotGradleLibraryAccessors extends SubDependencyFactory {

        public ComposeScreenshotGradleLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>plugin</b> with <b>com.android.compose.screenshot:screenshot-test-gradle-plugin</b> coordinates and
         * with version reference <b>screenshot</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getPlugin() {
            return create("compose.screenshot.gradle.plugin");
        }

    }

    public static class ComposeUiLibraryAccessors extends SubDependencyFactory implements DependencyNotationSupplier {

        public ComposeUiLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>ui</b> with <b>androidx.compose.ui:ui</b> coordinates and
         * with <b>no version specified</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> asProvider() {
            return create("compose.ui");
        }

        /**
         * Dependency provider for <b>test</b> with <b>androidx.compose.ui:ui-test-junit4</b> coordinates and
         * with <b>no version specified</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getTest() {
            return create("compose.ui.test");
        }

        /**
         * Dependency provider for <b>testManifest</b> with <b>androidx.compose.ui:ui-test-manifest</b> coordinates and
         * with <b>no version specified</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getTestManifest() {
            return create("compose.ui.testManifest");
        }

    }

    public static class CoreLibraryAccessors extends SubDependencyFactory {

        public CoreLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>ktx</b> with <b>androidx.core:core-ktx</b> coordinates and
         * with version reference <b>coreKtx</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getKtx() {
            return create("core.ktx");
        }

        /**
         * Dependency provider for <b>remoteviews</b> with <b>androidx.core:core-remoteviews</b> coordinates and
         * with version reference <b>core.remoteviews</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getRemoteviews() {
            return create("core.remoteviews");
        }

        /**
         * Dependency provider for <b>splashscreen</b> with <b>androidx.core:core-splashscreen</b> coordinates and
         * with version reference <b>core.splashscreen</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getSplashscreen() {
            return create("core.splashscreen");
        }

    }

    public static class CronetLibraryAccessors extends SubDependencyFactory {

        public CronetLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>embedded</b> with <b>org.chromium.net:cronet-embedded</b> coordinates and
         * with version reference <b>cronet.embedded</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getEmbedded() {
            return create("cronet.embedded");
        }

    }

    public static class FirebaseLibraryAccessors extends SubDependencyFactory {

        public FirebaseLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>bom</b> with <b>com.google.firebase:firebase-bom</b> coordinates and
         * with version reference <b>firebase.bom</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getBom() {
            return create("firebase.bom");
        }

        /**
         * Dependency provider for <b>messaging</b> with <b>com.google.firebase:firebase-messaging</b> coordinates and
         * with <b>no version specified</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getMessaging() {
            return create("firebase.messaging");
        }

    }

    public static class FragmentLibraryAccessors extends SubDependencyFactory {

        public FragmentLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>ktx</b> with <b>androidx.fragment:fragment-ktx</b> coordinates and
         * with version reference <b>fragment.ktx</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getKtx() {
            return create("fragment.ktx");
        }

    }

    public static class HazeLibraryAccessors extends SubDependencyFactory implements DependencyNotationSupplier {

        public HazeLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>haze</b> with <b>dev.chrisbanes.haze:haze</b> coordinates and
         * with version reference <b>haze</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> asProvider() {
            return create("haze");
        }

        /**
         * Dependency provider for <b>materials</b> with <b>dev.chrisbanes.haze:haze-materials</b> coordinates and
         * with version reference <b>haze</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getMaterials() {
            return create("haze.materials");
        }

    }

    public static class HiltLibraryAccessors extends SubDependencyFactory {
        private final HiltAndroidLibraryAccessors laccForHiltAndroidLibraryAccessors = new HiltAndroidLibraryAccessors(owner);

        public HiltLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Group of libraries at <b>hilt.android</b>
         */
        public HiltAndroidLibraryAccessors getAndroid() {
            return laccForHiltAndroidLibraryAccessors;
        }

    }

    public static class HiltAndroidLibraryAccessors extends SubDependencyFactory implements DependencyNotationSupplier {

        public HiltAndroidLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>android</b> with <b>com.google.dagger:hilt-android</b> coordinates and
         * with version reference <b>hilt</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> asProvider() {
            return create("hilt.android");
        }

        /**
         * Dependency provider for <b>compiler</b> with <b>com.google.dagger:hilt-android-compiler</b> coordinates and
         * with version reference <b>hilt</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getCompiler() {
            return create("hilt.android.compiler");
        }

        /**
         * Dependency provider for <b>testing</b> with <b>com.google.dagger:hilt-android-testing</b> coordinates and
         * with version reference <b>hilt</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getTesting() {
            return create("hilt.android.testing");
        }

    }

    public static class IconicsLibraryAccessors extends SubDependencyFactory {

        public IconicsLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>compose</b> with <b>com.mikepenz:iconics-compose</b> coordinates and
         * with version reference <b>iconics</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getCompose() {
            return create("iconics.compose");
        }

        /**
         * Dependency provider for <b>core</b> with <b>com.mikepenz:iconics-core</b> coordinates and
         * with version reference <b>iconics</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getCore() {
            return create("iconics.core");
        }

    }

    public static class JunitLibraryAccessors extends SubDependencyFactory {
        private final JunitJupiterLibraryAccessors laccForJunitJupiterLibraryAccessors = new JunitJupiterLibraryAccessors(owner);
        private final JunitPlatformLibraryAccessors laccForJunitPlatformLibraryAccessors = new JunitPlatformLibraryAccessors(owner);
        private final JunitVintageLibraryAccessors laccForJunitVintageLibraryAccessors = new JunitVintageLibraryAccessors(owner);

        public JunitLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>bom</b> with <b>org.junit:junit-bom</b> coordinates and
         * with version reference <b>junit</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getBom() {
            return create("junit.bom");
        }

        /**
         * Group of libraries at <b>junit.jupiter</b>
         */
        public JunitJupiterLibraryAccessors getJupiter() {
            return laccForJunitJupiterLibraryAccessors;
        }

        /**
         * Group of libraries at <b>junit.platform</b>
         */
        public JunitPlatformLibraryAccessors getPlatform() {
            return laccForJunitPlatformLibraryAccessors;
        }

        /**
         * Group of libraries at <b>junit.vintage</b>
         */
        public JunitVintageLibraryAccessors getVintage() {
            return laccForJunitVintageLibraryAccessors;
        }

    }

    public static class JunitJupiterLibraryAccessors extends SubDependencyFactory implements DependencyNotationSupplier {

        public JunitJupiterLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>jupiter</b> with <b>org.junit.jupiter:junit-jupiter</b> coordinates and
         * with <b>no version specified</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> asProvider() {
            return create("junit.jupiter");
        }

        /**
         * Dependency provider for <b>params</b> with <b>org.junit.jupiter:junit-jupiter-params</b> coordinates and
         * with <b>no version specified</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getParams() {
            return create("junit.jupiter.params");
        }

    }

    public static class JunitPlatformLibraryAccessors extends SubDependencyFactory {

        public JunitPlatformLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>launcher</b> with <b>org.junit.platform:junit-platform-launcher</b> coordinates and
         * with <b>no version specified</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getLauncher() {
            return create("junit.platform.launcher");
        }

    }

    public static class JunitVintageLibraryAccessors extends SubDependencyFactory {

        public JunitVintageLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>engine</b> with <b>org.junit.vintage:junit-vintage-engine</b> coordinates and
         * with <b>no version specified</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getEngine() {
            return create("junit.vintage.engine");
        }

    }

    public static class KotlinLibraryAccessors extends SubDependencyFactory {
        private final KotlinGradleLibraryAccessors laccForKotlinGradleLibraryAccessors = new KotlinGradleLibraryAccessors(owner);

        public KotlinLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>reflect</b> with <b>org.jetbrains.kotlin:kotlin-reflect</b> coordinates and
         * with version reference <b>kotlin</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getReflect() {
            return create("kotlin.reflect");
        }

        /**
         * Dependency provider for <b>stdlib</b> with <b>org.jetbrains.kotlin:kotlin-stdlib</b> coordinates and
         * with version reference <b>kotlin</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getStdlib() {
            return create("kotlin.stdlib");
        }

        /**
         * Group of libraries at <b>kotlin.gradle</b>
         */
        public KotlinGradleLibraryAccessors getGradle() {
            return laccForKotlinGradleLibraryAccessors;
        }

    }

    public static class KotlinGradleLibraryAccessors extends SubDependencyFactory {

        public KotlinGradleLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>plugin</b> with <b>org.jetbrains.kotlin:kotlin-gradle-plugin</b> coordinates and
         * with version reference <b>kotlin</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getPlugin() {
            return create("kotlin.gradle.plugin");
        }

    }

    public static class KotlinxLibraryAccessors extends SubDependencyFactory {
        private final KotlinxCoroutinesLibraryAccessors laccForKotlinxCoroutinesLibraryAccessors = new KotlinxCoroutinesLibraryAccessors(owner);
        private final KotlinxSerializationLibraryAccessors laccForKotlinxSerializationLibraryAccessors = new KotlinxSerializationLibraryAccessors(owner);

        public KotlinxLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Group of libraries at <b>kotlinx.coroutines</b>
         */
        public KotlinxCoroutinesLibraryAccessors getCoroutines() {
            return laccForKotlinxCoroutinesLibraryAccessors;
        }

        /**
         * Group of libraries at <b>kotlinx.serialization</b>
         */
        public KotlinxSerializationLibraryAccessors getSerialization() {
            return laccForKotlinxSerializationLibraryAccessors;
        }

    }

    public static class KotlinxCoroutinesLibraryAccessors extends SubDependencyFactory {
        private final KotlinxCoroutinesPlayLibraryAccessors laccForKotlinxCoroutinesPlayLibraryAccessors = new KotlinxCoroutinesPlayLibraryAccessors(owner);

        public KotlinxCoroutinesLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>android</b> with <b>org.jetbrains.kotlinx:kotlinx-coroutines-android</b> coordinates and
         * with version reference <b>kotlinx.coroutines</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getAndroid() {
            return create("kotlinx.coroutines.android");
        }

        /**
         * Dependency provider for <b>core</b> with <b>org.jetbrains.kotlinx:kotlinx-coroutines-core</b> coordinates and
         * with version reference <b>kotlinx.coroutines</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getCore() {
            return create("kotlinx.coroutines.core");
        }

        /**
         * Dependency provider for <b>guava</b> with <b>org.jetbrains.kotlinx:kotlinx-coroutines-guava</b> coordinates and
         * with version reference <b>kotlinx.coroutines</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getGuava() {
            return create("kotlinx.coroutines.guava");
        }

        /**
         * Dependency provider for <b>test</b> with <b>org.jetbrains.kotlinx:kotlinx-coroutines-test</b> coordinates and
         * with version reference <b>kotlinx.coroutines</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getTest() {
            return create("kotlinx.coroutines.test");
        }

        /**
         * Group of libraries at <b>kotlinx.coroutines.play</b>
         */
        public KotlinxCoroutinesPlayLibraryAccessors getPlay() {
            return laccForKotlinxCoroutinesPlayLibraryAccessors;
        }

    }

    public static class KotlinxCoroutinesPlayLibraryAccessors extends SubDependencyFactory {

        public KotlinxCoroutinesPlayLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>services</b> with <b>org.jetbrains.kotlinx:kotlinx-coroutines-play-services</b> coordinates and
         * with version reference <b>kotlinx.coroutines</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getServices() {
            return create("kotlinx.coroutines.play.services");
        }

    }

    public static class KotlinxSerializationLibraryAccessors extends SubDependencyFactory {

        public KotlinxSerializationLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>json</b> with <b>org.jetbrains.kotlinx:kotlinx-serialization-json</b> coordinates and
         * with version reference <b>kotlinx.serialization</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getJson() {
            return create("kotlinx.serialization.json");
        }

    }

    public static class LeakcanaryLibraryAccessors extends SubDependencyFactory {
        private final LeakcanaryAndroidLibraryAccessors laccForLeakcanaryAndroidLibraryAccessors = new LeakcanaryAndroidLibraryAccessors(owner);

        public LeakcanaryLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Group of libraries at <b>leakcanary.android</b>
         */
        public LeakcanaryAndroidLibraryAccessors getAndroid() {
            return laccForLeakcanaryAndroidLibraryAccessors;
        }

    }

    public static class LeakcanaryAndroidLibraryAccessors extends SubDependencyFactory implements DependencyNotationSupplier {

        public LeakcanaryAndroidLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>android</b> with <b>com.squareup.leakcanary:leakcanary-android</b> coordinates and
         * with version reference <b>leakcanaryAndroid</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> asProvider() {
            return create("leakcanary.android");
        }

        /**
         * Dependency provider for <b>instrumentation</b> with <b>com.squareup.leakcanary:leakcanary-android-instrumentation</b> coordinates and
         * with version reference <b>leakcanaryAndroid</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getInstrumentation() {
            return create("leakcanary.android.instrumentation");
        }

    }

    public static class LintLibraryAccessors extends SubDependencyFactory {

        public LintLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>api</b> with <b>com.android.tools.lint:lint-api</b> coordinates and
         * with version reference <b>androidTools</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getApi() {
            return create("lint.api");
        }

        /**
         * Dependency provider for <b>checks</b> with <b>com.android.tools.lint:lint-checks</b> coordinates and
         * with version reference <b>androidTools</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getChecks() {
            return create("lint.checks");
        }

        /**
         * Dependency provider for <b>tests</b> with <b>com.android.tools.lint:lint-tests</b> coordinates and
         * with version reference <b>androidTools</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getTests() {
            return create("lint.tests");
        }

    }

    public static class Media3LibraryAccessors extends SubDependencyFactory {
        private final Media3DatasourceLibraryAccessors laccForMedia3DatasourceLibraryAccessors = new Media3DatasourceLibraryAccessors(owner);
        private final Media3ExoplayerLibraryAccessors laccForMedia3ExoplayerLibraryAccessors = new Media3ExoplayerLibraryAccessors(owner);
        private final Media3UiLibraryAccessors laccForMedia3UiLibraryAccessors = new Media3UiLibraryAccessors(owner);

        public Media3LibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>session</b> with <b>androidx.media3:media3-session</b> coordinates and
         * with version reference <b>media3</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getSession() {
            return create("media3.session");
        }

        /**
         * Group of libraries at <b>media3.datasource</b>
         */
        public Media3DatasourceLibraryAccessors getDatasource() {
            return laccForMedia3DatasourceLibraryAccessors;
        }

        /**
         * Group of libraries at <b>media3.exoplayer</b>
         */
        public Media3ExoplayerLibraryAccessors getExoplayer() {
            return laccForMedia3ExoplayerLibraryAccessors;
        }

        /**
         * Group of libraries at <b>media3.ui</b>
         */
        public Media3UiLibraryAccessors getUi() {
            return laccForMedia3UiLibraryAccessors;
        }

    }

    public static class Media3DatasourceLibraryAccessors extends SubDependencyFactory {

        public Media3DatasourceLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>cronet</b> with <b>androidx.media3:media3-datasource-cronet</b> coordinates and
         * with version reference <b>media3</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getCronet() {
            return create("media3.datasource.cronet");
        }

    }

    public static class Media3ExoplayerLibraryAccessors extends SubDependencyFactory implements DependencyNotationSupplier {

        public Media3ExoplayerLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>exoplayer</b> with <b>androidx.media3:media3-exoplayer</b> coordinates and
         * with version reference <b>media3</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> asProvider() {
            return create("media3.exoplayer");
        }

        /**
         * Dependency provider for <b>hls</b> with <b>androidx.media3:media3-exoplayer-hls</b> coordinates and
         * with version reference <b>media3</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getHls() {
            return create("media3.exoplayer.hls");
        }

    }

    public static class Media3UiLibraryAccessors extends SubDependencyFactory {

        public Media3UiLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>compose</b> with <b>androidx.media3:media3-ui-compose</b> coordinates and
         * with version reference <b>media3</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getCompose() {
            return create("media3.ui.compose");
        }

    }

    public static class NavigationLibraryAccessors extends SubDependencyFactory {

        public NavigationLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>compose</b> with <b>androidx.navigation:navigation-compose</b> coordinates and
         * with version reference <b>navigation.compose</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getCompose() {
            return create("navigation.compose");
        }

        /**
         * Dependency provider for <b>test</b> with <b>androidx.navigation:navigation-testing</b> coordinates and
         * with version reference <b>navigation.compose</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getTest() {
            return create("navigation.test");
        }

    }

    public static class OkhttpLibraryAccessors extends SubDependencyFactory {
        private final OkhttpLoggingLibraryAccessors laccForOkhttpLoggingLibraryAccessors = new OkhttpLoggingLibraryAccessors(owner);

        public OkhttpLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>android</b> with <b>com.squareup.okhttp3:okhttp-android</b> coordinates and
         * with <b>no version specified</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getAndroid() {
            return create("okhttp.android");
        }

        /**
         * Dependency provider for <b>bom</b> with <b>com.squareup.okhttp3:okhttp-bom</b> coordinates and
         * with version reference <b>okhttp</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getBom() {
            return create("okhttp.bom");
        }

        /**
         * Group of libraries at <b>okhttp.logging</b>
         */
        public OkhttpLoggingLibraryAccessors getLogging() {
            return laccForOkhttpLoggingLibraryAccessors;
        }

    }

    public static class OkhttpLoggingLibraryAccessors extends SubDependencyFactory {

        public OkhttpLoggingLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>interceptor</b> with <b>com.squareup.okhttp3:logging-interceptor</b> coordinates and
         * with <b>no version specified</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getInterceptor() {
            return create("okhttp.logging.interceptor");
        }

    }

    public static class PagingLibraryAccessors extends SubDependencyFactory {

        public PagingLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>compose</b> with <b>androidx.paging:paging-compose</b> coordinates and
         * with version reference <b>paging</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getCompose() {
            return create("paging.compose");
        }

        /**
         * Dependency provider for <b>runtime</b> with <b>androidx.paging:paging-runtime</b> coordinates and
         * with version reference <b>paging</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getRuntime() {
            return create("paging.runtime");
        }

    }

    public static class PlayLibraryAccessors extends SubDependencyFactory {
        private final PlayServicesLibraryAccessors laccForPlayServicesLibraryAccessors = new PlayServicesLibraryAccessors(owner);

        public PlayLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Group of libraries at <b>play.services</b>
         */
        public PlayServicesLibraryAccessors getServices() {
            return laccForPlayServicesLibraryAccessors;
        }

    }

    public static class PlayServicesLibraryAccessors extends SubDependencyFactory {

        public PlayServicesLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>home</b> with <b>com.google.android.gms:play-services-home</b> coordinates and
         * with version reference <b>play.services.home</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getHome() {
            return create("play.services.home");
        }

        /**
         * Dependency provider for <b>location</b> with <b>com.google.android.gms:play-services-location</b> coordinates and
         * with version reference <b>play.services.location</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getLocation() {
            return create("play.services.location");
        }

        /**
         * Dependency provider for <b>threadnetwork</b> with <b>com.google.android.gms:play-services-threadnetwork</b> coordinates and
         * with version reference <b>play.services.threadnetwork</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getThreadnetwork() {
            return create("play.services.threadnetwork");
        }

        /**
         * Dependency provider for <b>wearable</b> with <b>com.google.android.gms:play-services-wearable</b> coordinates and
         * with version reference <b>play.services.wearable</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getWearable() {
            return create("play.services.wearable");
        }

    }

    public static class PreferenceLibraryAccessors extends SubDependencyFactory {

        public PreferenceLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>ktx</b> with <b>androidx.preference:preference-ktx</b> coordinates and
         * with version reference <b>preference.ktx</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getKtx() {
            return create("preference.ktx");
        }

    }

    public static class RetrofitLibraryAccessors extends SubDependencyFactory implements DependencyNotationSupplier {
        private final RetrofitConverterLibraryAccessors laccForRetrofitConverterLibraryAccessors = new RetrofitConverterLibraryAccessors(owner);

        public RetrofitLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>retrofit</b> with <b>com.squareup.retrofit2:retrofit</b> coordinates and
         * with <b>no version specified</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> asProvider() {
            return create("retrofit");
        }

        /**
         * Dependency provider for <b>bom</b> with <b>com.squareup.retrofit2:retrofit-bom</b> coordinates and
         * with version reference <b>retrofit.bom</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getBom() {
            return create("retrofit.bom");
        }

        /**
         * Group of libraries at <b>retrofit.converter</b>
         */
        public RetrofitConverterLibraryAccessors getConverter() {
            return laccForRetrofitConverterLibraryAccessors;
        }

    }

    public static class RetrofitConverterLibraryAccessors extends SubDependencyFactory {
        private final RetrofitConverterKotlinxLibraryAccessors laccForRetrofitConverterKotlinxLibraryAccessors = new RetrofitConverterKotlinxLibraryAccessors(owner);

        public RetrofitConverterLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Group of libraries at <b>retrofit.converter.kotlinx</b>
         */
        public RetrofitConverterKotlinxLibraryAccessors getKotlinx() {
            return laccForRetrofitConverterKotlinxLibraryAccessors;
        }

    }

    public static class RetrofitConverterKotlinxLibraryAccessors extends SubDependencyFactory {

        public RetrofitConverterKotlinxLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>serialization</b> with <b>com.squareup.retrofit2:converter-kotlinx-serialization</b> coordinates and
         * with <b>no version specified</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getSerialization() {
            return create("retrofit.converter.kotlinx.serialization");
        }

    }

    public static class ScreenshotLibraryAccessors extends SubDependencyFactory {
        private final ScreenshotValidationLibraryAccessors laccForScreenshotValidationLibraryAccessors = new ScreenshotValidationLibraryAccessors(owner);

        public ScreenshotLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Group of libraries at <b>screenshot.validation</b>
         */
        public ScreenshotValidationLibraryAccessors getValidation() {
            return laccForScreenshotValidationLibraryAccessors;
        }

    }

    public static class ScreenshotValidationLibraryAccessors extends SubDependencyFactory {

        public ScreenshotValidationLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>api</b> with <b>com.android.tools.screenshot:screenshot-validation-api</b> coordinates and
         * with version reference <b>screenshot</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getApi() {
            return create("screenshot.validation.api");
        }

    }

    public static class SentryLibraryAccessors extends SubDependencyFactory {
        private final SentryAndroidLibraryAccessors laccForSentryAndroidLibraryAccessors = new SentryAndroidLibraryAccessors(owner);

        public SentryLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Group of libraries at <b>sentry.android</b>
         */
        public SentryAndroidLibraryAccessors getAndroid() {
            return laccForSentryAndroidLibraryAccessors;
        }

    }

    public static class SentryAndroidLibraryAccessors extends SubDependencyFactory {

        public SentryAndroidLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>core</b> with <b>io.sentry:sentry-android-core</b> coordinates and
         * with version reference <b>sentry.android</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getCore() {
            return create("sentry.android.core");
        }

    }

    public static class ToolsLibraryAccessors extends SubDependencyFactory {
        private final ToolsDesugarLibraryAccessors laccForToolsDesugarLibraryAccessors = new ToolsDesugarLibraryAccessors(owner);

        public ToolsLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Group of libraries at <b>tools.desugar</b>
         */
        public ToolsDesugarLibraryAccessors getDesugar() {
            return laccForToolsDesugarLibraryAccessors;
        }

    }

    public static class ToolsDesugarLibraryAccessors extends SubDependencyFactory {

        public ToolsDesugarLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>jdk</b> with <b>com.android.tools:desugar_jdk_libs</b> coordinates and
         * with version reference <b>tools.desugar.jdk.libs</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getJdk() {
            return create("tools.desugar.jdk");
        }

    }

    public static class WearLibraryAccessors extends SubDependencyFactory implements DependencyNotationSupplier {
        private final WearComposeLibraryAccessors laccForWearComposeLibraryAccessors = new WearComposeLibraryAccessors(owner);
        private final WearPhoneLibraryAccessors laccForWearPhoneLibraryAccessors = new WearPhoneLibraryAccessors(owner);
        private final WearProtolayoutLibraryAccessors laccForWearProtolayoutLibraryAccessors = new WearProtolayoutLibraryAccessors(owner);
        private final WearRemoteLibraryAccessors laccForWearRemoteLibraryAccessors = new WearRemoteLibraryAccessors(owner);

        public WearLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>wear</b> with <b>androidx.wear:wear</b> coordinates and
         * with version reference <b>wear</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> asProvider() {
            return create("wear");
        }

        /**
         * Dependency provider for <b>input</b> with <b>androidx.wear:wear-input</b> coordinates and
         * with version reference <b>wearInput</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getInput() {
            return create("wear.input");
        }

        /**
         * Dependency provider for <b>tiles</b> with <b>androidx.wear.tiles:tiles</b> coordinates and
         * with version reference <b>wear.tiles</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getTiles() {
            return create("wear.tiles");
        }

        /**
         * Dependency provider for <b>tooling</b> with <b>androidx.wear:wear-tooling-preview</b> coordinates and
         * with version reference <b>wear.tooling</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getTooling() {
            return create("wear.tooling");
        }

        /**
         * Group of libraries at <b>wear.compose</b>
         */
        public WearComposeLibraryAccessors getCompose() {
            return laccForWearComposeLibraryAccessors;
        }

        /**
         * Group of libraries at <b>wear.phone</b>
         */
        public WearPhoneLibraryAccessors getPhone() {
            return laccForWearPhoneLibraryAccessors;
        }

        /**
         * Group of libraries at <b>wear.protolayout</b>
         */
        public WearProtolayoutLibraryAccessors getProtolayout() {
            return laccForWearProtolayoutLibraryAccessors;
        }

        /**
         * Group of libraries at <b>wear.remote</b>
         */
        public WearRemoteLibraryAccessors getRemote() {
            return laccForWearRemoteLibraryAccessors;
        }

    }

    public static class WearComposeLibraryAccessors extends SubDependencyFactory {

        public WearComposeLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>foundation</b> with <b>androidx.wear.compose:compose-foundation</b> coordinates and
         * with version reference <b>wear.compose</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getFoundation() {
            return create("wear.compose.foundation");
        }

        /**
         * Dependency provider for <b>material</b> with <b>androidx.wear.compose:compose-material3</b> coordinates and
         * with version reference <b>wear.compose</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getMaterial() {
            return create("wear.compose.material");
        }

        /**
         * Dependency provider for <b>navigation</b> with <b>androidx.wear.compose:compose-navigation</b> coordinates and
         * with version reference <b>wear.compose</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getNavigation() {
            return create("wear.compose.navigation");
        }

    }

    public static class WearPhoneLibraryAccessors extends SubDependencyFactory {

        public WearPhoneLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>interactions</b> with <b>androidx.wear:wear-phone-interactions</b> coordinates and
         * with version reference <b>wearPhoneInteractions</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getInteractions() {
            return create("wear.phone.interactions");
        }

    }

    public static class WearProtolayoutLibraryAccessors extends SubDependencyFactory {

        public WearProtolayoutLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>expression</b> with <b>androidx.wear.protolayout:protolayout-expression</b> coordinates and
         * with version reference <b>wear.protolayout</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getExpression() {
            return create("wear.protolayout.expression");
        }

        /**
         * Dependency provider for <b>main</b> with <b>androidx.wear.protolayout:protolayout</b> coordinates and
         * with version reference <b>wear.protolayout</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getMain() {
            return create("wear.protolayout.main");
        }

        /**
         * Dependency provider for <b>material</b> with <b>androidx.wear.protolayout:protolayout-material</b> coordinates and
         * with version reference <b>wear.protolayout</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getMaterial() {
            return create("wear.protolayout.material");
        }

    }

    public static class WearRemoteLibraryAccessors extends SubDependencyFactory {

        public WearRemoteLibraryAccessors(AbstractExternalDependencyFactory owner) { super(owner); }

        /**
         * Dependency provider for <b>interactions</b> with <b>androidx.wear:wear-remote-interactions</b> coordinates and
         * with version reference <b>wear.remote.interactions</b>
         * <p>
         * This dependency was declared in catalog libs.versions.toml
         */
        public Provider<MinimalExternalModuleDependency> getInteractions() {
            return create("wear.remote.interactions");
        }

    }

    public static class VersionAccessors extends VersionFactory  {

        private final ActivityVersionAccessors vaccForActivityVersionAccessors = new ActivityVersionAccessors(providers, config);
        private final AndroidSdkVersionAccessors vaccForAndroidSdkVersionAccessors = new AndroidSdkVersionAccessors(providers, config);
        private final CarVersionAccessors vaccForCarVersionAccessors = new CarVersionAccessors(providers, config);
        private final CommunityVersionAccessors vaccForCommunityVersionAccessors = new CommunityVersionAccessors(providers, config);
        private final ComposeVersionAccessors vaccForComposeVersionAccessors = new ComposeVersionAccessors(providers, config);
        private final CoreVersionAccessors vaccForCoreVersionAccessors = new CoreVersionAccessors(providers, config);
        private final CronetVersionAccessors vaccForCronetVersionAccessors = new CronetVersionAccessors(providers, config);
        private final FirebaseVersionAccessors vaccForFirebaseVersionAccessors = new FirebaseVersionAccessors(providers, config);
        private final FragmentVersionAccessors vaccForFragmentVersionAccessors = new FragmentVersionAccessors(providers, config);
        private final KotlinxVersionAccessors vaccForKotlinxVersionAccessors = new KotlinxVersionAccessors(providers, config);
        private final NavigationVersionAccessors vaccForNavigationVersionAccessors = new NavigationVersionAccessors(providers, config);
        private final PlayVersionAccessors vaccForPlayVersionAccessors = new PlayVersionAccessors(providers, config);
        private final PreferenceVersionAccessors vaccForPreferenceVersionAccessors = new PreferenceVersionAccessors(providers, config);
        private final RetrofitVersionAccessors vaccForRetrofitVersionAccessors = new RetrofitVersionAccessors(providers, config);
        private final RobolectricVersionAccessors vaccForRobolectricVersionAccessors = new RobolectricVersionAccessors(providers, config);
        private final SentryVersionAccessors vaccForSentryVersionAccessors = new SentryVersionAccessors(providers, config);
        private final ToolsVersionAccessors vaccForToolsVersionAccessors = new ToolsVersionAccessors(providers, config);
        private final WearVersionAccessors vaccForWearVersionAccessors = new WearVersionAccessors(providers, config);
        public VersionAccessors(ProviderFactory providers, DefaultVersionCatalog config) { super(providers, config); }

        /**
         * Version alias <b>accompanist</b> with value <b>0.37.3</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getAccompanist() { return getVersion("accompanist"); }

        /**
         * Version alias <b>androidBeaconLibrary</b> with value <b>2.21.1</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getAndroidBeaconLibrary() { return getVersion("androidBeaconLibrary"); }

        /**
         * Version alias <b>androidGradlePlugin</b> with value <b>8.13.1</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getAndroidGradlePlugin() { return getVersion("androidGradlePlugin"); }

        /**
         * Version alias <b>androidTools</b> with value <b>31.13.1</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getAndroidTools() { return getVersion("androidTools"); }

        /**
         * Version alias <b>androidxConcurrent</b> with value <b>1.3.0</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getAndroidxConcurrent() { return getVersion("androidxConcurrent"); }

        /**
         * Version alias <b>androidxHiltNavigationCompose</b> with value <b>1.3.0</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getAndroidxHiltNavigationCompose() { return getVersion("androidxHiltNavigationCompose"); }

        /**
         * Version alias <b>androidxTestCore</b> with value <b>1.7.0</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getAndroidxTestCore() { return getVersion("androidxTestCore"); }

        /**
         * Version alias <b>androidxTestExt</b> with value <b>1.3.0</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getAndroidxTestExt() { return getVersion("androidxTestExt"); }

        /**
         * Version alias <b>androidxTestRules</b> with value <b>1.7.0</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getAndroidxTestRules() { return getVersion("androidxTestRules"); }

        /**
         * Version alias <b>androidxTestRunner</b> with value <b>1.7.0</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getAndroidxTestRunner() { return getVersion("androidxTestRunner"); }

        /**
         * Version alias <b>appcompat</b> with value <b>1.7.1</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getAppcompat() { return getVersion("appcompat"); }

        /**
         * Version alias <b>biometric</b> with value <b>1.1.0</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getBiometric() { return getVersion("biometric"); }

        /**
         * Version alias <b>blurView</b> with value <b>version-2.0.6</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getBlurView() { return getVersion("blurView"); }

        /**
         * Version alias <b>changeLog</b> with value <b>3.8.1</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getChangeLog() { return getVersion("changeLog"); }

        /**
         * Version alias <b>coil</b> with value <b>3.3.0</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getCoil() { return getVersion("coil"); }

        /**
         * Version alias <b>composeLintChecks</b> with value <b>1.4.2</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getComposeLintChecks() { return getVersion("composeLintChecks"); }

        /**
         * Version alias <b>connectClient</b> with value <b>1.1.0</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getConnectClient() { return getVersion("connectClient"); }

        /**
         * Version alias <b>constraintlayout</b> with value <b>2.2.1</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getConstraintlayout() { return getVersion("constraintlayout"); }

        /**
         * Version alias <b>coreKtx</b> with value <b>1.17.0</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getCoreKtx() { return getVersion("coreKtx"); }

        /**
         * Version alias <b>emojiJava</b> with value <b>5.1.1</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getEmojiJava() { return getVersion("emojiJava"); }

        /**
         * Version alias <b>firebaseAppdistributionGradle</b> with value <b>5.2.0</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getFirebaseAppdistributionGradle() { return getVersion("firebaseAppdistributionGradle"); }

        /**
         * Version alias <b>glance</b> with value <b>1.1.1</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getGlance() { return getVersion("glance"); }

        /**
         * Version alias <b>googleServices</b> with value <b>4.4.4</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getGoogleServices() { return getVersion("googleServices"); }

        /**
         * Version alias <b>guava</b> with value <b>33.4.6-android</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getGuava() { return getVersion("guava"); }

        /**
         * Version alias <b>haze</b> with value <b>1.7.0</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getHaze() { return getVersion("haze"); }

        /**
         * Version alias <b>healthServicesClient</b> with value <b>1.1.0-alpha05</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getHealthServicesClient() { return getVersion("healthServicesClient"); }

        /**
         * Version alias <b>hilt</b> with value <b>2.57.2</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getHilt() { return getVersion("hilt"); }

        /**
         * Version alias <b>iconics</b> with value <b>5.5.0-compose01</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getIconics() { return getVersion("iconics"); }

        /**
         * Version alias <b>improv</b> with value <b>0.1.1</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getImprov() { return getVersion("improv"); }

        /**
         * Version alias <b>javaVersion</b> with value <b>11</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getJavaVersion() { return getVersion("javaVersion"); }

        /**
         * Version alias <b>junit</b> with value <b>6.0.1</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getJunit() { return getVersion("junit"); }

        /**
         * Version alias <b>kotlin</b> with value <b>2.2.21</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getKotlin() { return getVersion("kotlin"); }

        /**
         * Version alias <b>ksp</b> with value <b>2.3.2</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getKsp() { return getVersion("ksp"); }

        /**
         * Version alias <b>ktlint</b> with value <b>14.0.1</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getKtlint() { return getVersion("ktlint"); }

        /**
         * Version alias <b>leakcanaryAndroid</b> with value <b>2.14</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getLeakcanaryAndroid() { return getVersion("leakcanaryAndroid"); }

        /**
         * Version alias <b>lifecycle</b> with value <b>2.9.4</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getLifecycle() { return getVersion("lifecycle"); }

        /**
         * Version alias <b>material</b> with value <b>1.13.0</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getMaterial() { return getVersion("material"); }

        /**
         * Version alias <b>media</b> with value <b>1.7.1</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getMedia() { return getVersion("media"); }

        /**
         * Version alias <b>media3</b> with value <b>1.8.0</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getMedia3() { return getVersion("media3"); }

        /**
         * Version alias <b>mockk</b> with value <b>1.14.6</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getMockk() { return getVersion("mockk"); }

        /**
         * Version alias <b>okhttp</b> with value <b>5.3.2</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getOkhttp() { return getVersion("okhttp"); }

        /**
         * Version alias <b>paging</b> with value <b>3.3.6</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getPaging() { return getVersion("paging"); }

        /**
         * Version alias <b>recyclerview</b> with value <b>1.4.0</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getRecyclerview() { return getVersion("recyclerview"); }

        /**
         * Version alias <b>reorderable</b> with value <b>3.0.0</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getReorderable() { return getVersion("reorderable"); }

        /**
         * Version alias <b>room</b> with value <b>2.8.3</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getRoom() { return getVersion("room"); }

        /**
         * Version alias <b>runtimeLint</b> with value <b>1.9.4</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getRuntimeLint() { return getVersion("runtimeLint"); }

        /**
         * Version alias <b>screenshot</b> with value <b>0.0.1-alpha11</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getScreenshot() { return getVersion("screenshot"); }

        /**
         * Version alias <b>timber</b> with value <b>5.0.1</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getTimber() { return getVersion("timber"); }

        /**
         * Version alias <b>turbine</b> with value <b>1.2.1</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getTurbine() { return getVersion("turbine"); }

        /**
         * Version alias <b>watchfaceComplicationsDataSourceKtx</b> with value <b>1.2.1</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getWatchfaceComplicationsDataSourceKtx() { return getVersion("watchfaceComplicationsDataSourceKtx"); }

        /**
         * Version alias <b>wearInput</b> with value <b>1.2.0</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getWearInput() { return getVersion("wearInput"); }

        /**
         * Version alias <b>wearPhoneInteractions</b> with value <b>1.1.0</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getWearPhoneInteractions() { return getVersion("wearPhoneInteractions"); }

        /**
         * Version alias <b>webkit</b> with value <b>1.14.0</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getWebkit() { return getVersion("webkit"); }

        /**
         * Version alias <b>workRuntime</b> with value <b>2.11.0</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getWorkRuntime() { return getVersion("workRuntime"); }

        /**
         * Version alias <b>zxing</b> with value <b>4.3.0</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getZxing() { return getVersion("zxing"); }

        /**
         * Group of versions at <b>versions.activity</b>
         */
        public ActivityVersionAccessors getActivity() {
            return vaccForActivityVersionAccessors;
        }

        /**
         * Group of versions at <b>versions.androidSdk</b>
         */
        public AndroidSdkVersionAccessors getAndroidSdk() {
            return vaccForAndroidSdkVersionAccessors;
        }

        /**
         * Group of versions at <b>versions.car</b>
         */
        public CarVersionAccessors getCar() {
            return vaccForCarVersionAccessors;
        }

        /**
         * Group of versions at <b>versions.community</b>
         */
        public CommunityVersionAccessors getCommunity() {
            return vaccForCommunityVersionAccessors;
        }

        /**
         * Group of versions at <b>versions.compose</b>
         */
        public ComposeVersionAccessors getCompose() {
            return vaccForComposeVersionAccessors;
        }

        /**
         * Group of versions at <b>versions.core</b>
         */
        public CoreVersionAccessors getCore() {
            return vaccForCoreVersionAccessors;
        }

        /**
         * Group of versions at <b>versions.cronet</b>
         */
        public CronetVersionAccessors getCronet() {
            return vaccForCronetVersionAccessors;
        }

        /**
         * Group of versions at <b>versions.firebase</b>
         */
        public FirebaseVersionAccessors getFirebase() {
            return vaccForFirebaseVersionAccessors;
        }

        /**
         * Group of versions at <b>versions.fragment</b>
         */
        public FragmentVersionAccessors getFragment() {
            return vaccForFragmentVersionAccessors;
        }

        /**
         * Group of versions at <b>versions.kotlinx</b>
         */
        public KotlinxVersionAccessors getKotlinx() {
            return vaccForKotlinxVersionAccessors;
        }

        /**
         * Group of versions at <b>versions.navigation</b>
         */
        public NavigationVersionAccessors getNavigation() {
            return vaccForNavigationVersionAccessors;
        }

        /**
         * Group of versions at <b>versions.play</b>
         */
        public PlayVersionAccessors getPlay() {
            return vaccForPlayVersionAccessors;
        }

        /**
         * Group of versions at <b>versions.preference</b>
         */
        public PreferenceVersionAccessors getPreference() {
            return vaccForPreferenceVersionAccessors;
        }

        /**
         * Group of versions at <b>versions.retrofit</b>
         */
        public RetrofitVersionAccessors getRetrofit() {
            return vaccForRetrofitVersionAccessors;
        }

        /**
         * Group of versions at <b>versions.robolectric</b>
         */
        public RobolectricVersionAccessors getRobolectric() {
            return vaccForRobolectricVersionAccessors;
        }

        /**
         * Group of versions at <b>versions.sentry</b>
         */
        public SentryVersionAccessors getSentry() {
            return vaccForSentryVersionAccessors;
        }

        /**
         * Group of versions at <b>versions.tools</b>
         */
        public ToolsVersionAccessors getTools() {
            return vaccForToolsVersionAccessors;
        }

        /**
         * Group of versions at <b>versions.wear</b>
         */
        public WearVersionAccessors getWear() {
            return vaccForWearVersionAccessors;
        }

    }

    public static class ActivityVersionAccessors extends VersionFactory  {

        public ActivityVersionAccessors(ProviderFactory providers, DefaultVersionCatalog config) { super(providers, config); }

        /**
         * Version alias <b>activity.compose</b> with value <b>1.11.0</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getCompose() { return getVersion("activity.compose"); }

    }

    public static class AndroidSdkVersionAccessors extends VersionFactory  {

        private final AndroidSdkAutomotiveVersionAccessors vaccForAndroidSdkAutomotiveVersionAccessors = new AndroidSdkAutomotiveVersionAccessors(providers, config);
        private final AndroidSdkWearVersionAccessors vaccForAndroidSdkWearVersionAccessors = new AndroidSdkWearVersionAccessors(providers, config);
        public AndroidSdkVersionAccessors(ProviderFactory providers, DefaultVersionCatalog config) { super(providers, config); }

        /**
         * Version alias <b>androidSdk.compile</b> with value <b>36</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getCompile() { return getVersion("androidSdk.compile"); }

        /**
         * Version alias <b>androidSdk.min</b> with value <b>23</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getMin() { return getVersion("androidSdk.min"); }

        /**
         * Version alias <b>androidSdk.target</b> with value <b>36</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getTarget() { return getVersion("androidSdk.target"); }

        /**
         * Group of versions at <b>versions.androidSdk.automotive</b>
         */
        public AndroidSdkAutomotiveVersionAccessors getAutomotive() {
            return vaccForAndroidSdkAutomotiveVersionAccessors;
        }

        /**
         * Group of versions at <b>versions.androidSdk.wear</b>
         */
        public AndroidSdkWearVersionAccessors getWear() {
            return vaccForAndroidSdkWearVersionAccessors;
        }

    }

    public static class AndroidSdkAutomotiveVersionAccessors extends VersionFactory  {

        public AndroidSdkAutomotiveVersionAccessors(ProviderFactory providers, DefaultVersionCatalog config) { super(providers, config); }

        /**
         * Version alias <b>androidSdk.automotive.min</b> with value <b>29</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getMin() { return getVersion("androidSdk.automotive.min"); }

    }

    public static class AndroidSdkWearVersionAccessors extends VersionFactory  {

        public AndroidSdkWearVersionAccessors(ProviderFactory providers, DefaultVersionCatalog config) { super(providers, config); }

        /**
         * Version alias <b>androidSdk.wear.min</b> with value <b>26</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getMin() { return getVersion("androidSdk.wear.min"); }

        /**
         * Version alias <b>androidSdk.wear.target</b> with value <b>34</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getTarget() { return getVersion("androidSdk.wear.target"); }

    }

    public static class CarVersionAccessors extends VersionFactory  {

        public CarVersionAccessors(ProviderFactory providers, DefaultVersionCatalog config) { super(providers, config); }

        /**
         * Version alias <b>car.versions</b> with value <b>1.7.0</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getVersions() { return getVersion("car.versions"); }

    }

    public static class CommunityVersionAccessors extends VersionFactory  {

        private final CommunityMaterialVersionAccessors vaccForCommunityMaterialVersionAccessors = new CommunityMaterialVersionAccessors(providers, config);
        public CommunityVersionAccessors(ProviderFactory providers, DefaultVersionCatalog config) { super(providers, config); }

        /**
         * Group of versions at <b>versions.community.material</b>
         */
        public CommunityMaterialVersionAccessors getMaterial() {
            return vaccForCommunityMaterialVersionAccessors;
        }

    }

    public static class CommunityMaterialVersionAccessors extends VersionFactory  {

        public CommunityMaterialVersionAccessors(ProviderFactory providers, DefaultVersionCatalog config) { super(providers, config); }

        /**
         * Version alias <b>community.material.typeface</b> with value <b>7.0.96.2-kotlin</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getTypeface() { return getVersion("community.material.typeface"); }

    }

    public static class ComposeVersionAccessors extends VersionFactory  {

        public ComposeVersionAccessors(ProviderFactory providers, DefaultVersionCatalog config) { super(providers, config); }

        /**
         * Version alias <b>compose.bom</b> with value <b>2025.11.00</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getBom() { return getVersion("compose.bom"); }

    }

    public static class CoreVersionAccessors extends VersionFactory  {

        public CoreVersionAccessors(ProviderFactory providers, DefaultVersionCatalog config) { super(providers, config); }

        /**
         * Version alias <b>core.remoteviews</b> with value <b>1.1.0</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getRemoteviews() { return getVersion("core.remoteviews"); }

        /**
         * Version alias <b>core.splashscreen</b> with value <b>1.2.0</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getSplashscreen() { return getVersion("core.splashscreen"); }

    }

    public static class CronetVersionAccessors extends VersionFactory  {

        public CronetVersionAccessors(ProviderFactory providers, DefaultVersionCatalog config) { super(providers, config); }

        /**
         * Version alias <b>cronet.embedded</b> with value <b>141.7340.3</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getEmbedded() { return getVersion("cronet.embedded"); }

    }

    public static class FirebaseVersionAccessors extends VersionFactory  {

        public FirebaseVersionAccessors(ProviderFactory providers, DefaultVersionCatalog config) { super(providers, config); }

        /**
         * Version alias <b>firebase.bom</b> with value <b>34.6.0</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getBom() { return getVersion("firebase.bom"); }

    }

    public static class FragmentVersionAccessors extends VersionFactory  {

        public FragmentVersionAccessors(ProviderFactory providers, DefaultVersionCatalog config) { super(providers, config); }

        /**
         * Version alias <b>fragment.ktx</b> with value <b>1.8.9</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getKtx() { return getVersion("fragment.ktx"); }

    }

    public static class KotlinxVersionAccessors extends VersionFactory  {

        public KotlinxVersionAccessors(ProviderFactory providers, DefaultVersionCatalog config) { super(providers, config); }

        /**
         * Version alias <b>kotlinx.coroutines</b> with value <b>1.10.2</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getCoroutines() { return getVersion("kotlinx.coroutines"); }

        /**
         * Version alias <b>kotlinx.serialization</b> with value <b>1.9.0</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getSerialization() { return getVersion("kotlinx.serialization"); }

    }

    public static class NavigationVersionAccessors extends VersionFactory  {

        public NavigationVersionAccessors(ProviderFactory providers, DefaultVersionCatalog config) { super(providers, config); }

        /**
         * Version alias <b>navigation.compose</b> with value <b>2.9.6</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getCompose() { return getVersion("navigation.compose"); }

    }

    public static class PlayVersionAccessors extends VersionFactory  {

        private final PlayServicesVersionAccessors vaccForPlayServicesVersionAccessors = new PlayServicesVersionAccessors(providers, config);
        public PlayVersionAccessors(ProviderFactory providers, DefaultVersionCatalog config) { super(providers, config); }

        /**
         * Group of versions at <b>versions.play.services</b>
         */
        public PlayServicesVersionAccessors getServices() {
            return vaccForPlayServicesVersionAccessors;
        }

    }

    public static class PlayServicesVersionAccessors extends VersionFactory  {

        public PlayServicesVersionAccessors(ProviderFactory providers, DefaultVersionCatalog config) { super(providers, config); }

        /**
         * Version alias <b>play.services.home</b> with value <b>16.0.0</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getHome() { return getVersion("play.services.home"); }

        /**
         * Version alias <b>play.services.location</b> with value <b>21.3.0</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getLocation() { return getVersion("play.services.location"); }

        /**
         * Version alias <b>play.services.threadnetwork</b> with value <b>16.3.0</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getThreadnetwork() { return getVersion("play.services.threadnetwork"); }

        /**
         * Version alias <b>play.services.wearable</b> with value <b>19.0.0</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getWearable() { return getVersion("play.services.wearable"); }

    }

    public static class PreferenceVersionAccessors extends VersionFactory  {

        public PreferenceVersionAccessors(ProviderFactory providers, DefaultVersionCatalog config) { super(providers, config); }

        /**
         * Version alias <b>preference.ktx</b> with value <b>1.2.1</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getKtx() { return getVersion("preference.ktx"); }

    }

    public static class RetrofitVersionAccessors extends VersionFactory  {

        public RetrofitVersionAccessors(ProviderFactory providers, DefaultVersionCatalog config) { super(providers, config); }

        /**
         * Version alias <b>retrofit.bom</b> with value <b>3.0.0</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getBom() { return getVersion("retrofit.bom"); }

    }

    public static class RobolectricVersionAccessors extends VersionFactory  implements VersionNotationSupplier {

        private final RobolectricTargetVersionAccessors vaccForRobolectricTargetVersionAccessors = new RobolectricTargetVersionAccessors(providers, config);
        public RobolectricVersionAccessors(ProviderFactory providers, DefaultVersionCatalog config) { super(providers, config); }

        /**
         * Version alias <b>robolectric</b> with value <b>4.16</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> asProvider() { return getVersion("robolectric"); }

        /**
         * Group of versions at <b>versions.robolectric.target</b>
         */
        public RobolectricTargetVersionAccessors getTarget() {
            return vaccForRobolectricTargetVersionAccessors;
        }

    }

    public static class RobolectricTargetVersionAccessors extends VersionFactory  {

        public RobolectricTargetVersionAccessors(ProviderFactory providers, DefaultVersionCatalog config) { super(providers, config); }

        /**
         * Version alias <b>robolectric.target.sdk</b> with value <b>36</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getSdk() { return getVersion("robolectric.target.sdk"); }

    }

    public static class SentryVersionAccessors extends VersionFactory  {

        public SentryVersionAccessors(ProviderFactory providers, DefaultVersionCatalog config) { super(providers, config); }

        /**
         * Version alias <b>sentry.android</b> with value <b>8.26.0</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getAndroid() { return getVersion("sentry.android"); }

    }

    public static class ToolsVersionAccessors extends VersionFactory  {

        private final ToolsDesugarVersionAccessors vaccForToolsDesugarVersionAccessors = new ToolsDesugarVersionAccessors(providers, config);
        public ToolsVersionAccessors(ProviderFactory providers, DefaultVersionCatalog config) { super(providers, config); }

        /**
         * Group of versions at <b>versions.tools.desugar</b>
         */
        public ToolsDesugarVersionAccessors getDesugar() {
            return vaccForToolsDesugarVersionAccessors;
        }

    }

    public static class ToolsDesugarVersionAccessors extends VersionFactory  {

        private final ToolsDesugarJdkVersionAccessors vaccForToolsDesugarJdkVersionAccessors = new ToolsDesugarJdkVersionAccessors(providers, config);
        public ToolsDesugarVersionAccessors(ProviderFactory providers, DefaultVersionCatalog config) { super(providers, config); }

        /**
         * Group of versions at <b>versions.tools.desugar.jdk</b>
         */
        public ToolsDesugarJdkVersionAccessors getJdk() {
            return vaccForToolsDesugarJdkVersionAccessors;
        }

    }

    public static class ToolsDesugarJdkVersionAccessors extends VersionFactory  {

        public ToolsDesugarJdkVersionAccessors(ProviderFactory providers, DefaultVersionCatalog config) { super(providers, config); }

        /**
         * Version alias <b>tools.desugar.jdk.libs</b> with value <b>2.1.5</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getLibs() { return getVersion("tools.desugar.jdk.libs"); }

    }

    public static class WearVersionAccessors extends VersionFactory  implements VersionNotationSupplier {

        private final WearRemoteVersionAccessors vaccForWearRemoteVersionAccessors = new WearRemoteVersionAccessors(providers, config);
        public WearVersionAccessors(ProviderFactory providers, DefaultVersionCatalog config) { super(providers, config); }

        /**
         * Version alias <b>wear</b> with value <b>1.3.0</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> asProvider() { return getVersion("wear"); }

        /**
         * Version alias <b>wear.compose</b> with value <b>1.5.5</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getCompose() { return getVersion("wear.compose"); }

        /**
         * Version alias <b>wear.protolayout</b> with value <b>1.3.0</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getProtolayout() { return getVersion("wear.protolayout"); }

        /**
         * Version alias <b>wear.tiles</b> with value <b>1.5.0</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getTiles() { return getVersion("wear.tiles"); }

        /**
         * Version alias <b>wear.tooling</b> with value <b>1.0.0</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getTooling() { return getVersion("wear.tooling"); }

        /**
         * Group of versions at <b>versions.wear.remote</b>
         */
        public WearRemoteVersionAccessors getRemote() {
            return vaccForWearRemoteVersionAccessors;
        }

    }

    public static class WearRemoteVersionAccessors extends VersionFactory  {

        public WearRemoteVersionAccessors(ProviderFactory providers, DefaultVersionCatalog config) { super(providers, config); }

        /**
         * Version alias <b>wear.remote.interactions</b> with value <b>1.1.0</b>
         * <p>
         * If the version is a rich version and cannot be represented as a
         * single version string, an empty string is returned.
         * <p>
         * This version was declared in catalog libs.versions.toml
         */
        public Provider<String> getInteractions() { return getVersion("wear.remote.interactions"); }

    }

    public static class BundleAccessors extends BundleFactory {
        private final AndroidxBundleAccessors baccForAndroidxBundleAccessors = new AndroidxBundleAccessors(objects, providers, config, attributesFactory, capabilityNotationParser);
        private final WearBundleAccessors baccForWearBundleAccessors = new WearBundleAccessors(objects, providers, config, attributesFactory, capabilityNotationParser);

        public BundleAccessors(ObjectFactory objects, ProviderFactory providers, DefaultVersionCatalog config, AttributesFactory attributesFactory, CapabilityNotationParser capabilityNotationParser) { super(objects, providers, config, attributesFactory, capabilityNotationParser); }

        /**
         * Dependency bundle provider for <b>coil</b> which contains the following dependencies:
         * <ul>
         *    <li>io.coil-kt.coil3:coil</li>
         *    <li>io.coil-kt.coil3:coil-network-okhttp</li>
         *    <li>io.coil-kt.coil3:coil-svg</li>
         * </ul>
         * <p>
         * This bundle was declared in catalog libs.versions.toml
         */
        public Provider<ExternalModuleDependencyBundle> getCoil() {
            return createBundle("coil");
        }

        /**
         * Dependency bundle provider for <b>media3</b> which contains the following dependencies:
         * <ul>
         *    <li>androidx.media3:media3-exoplayer</li>
         *    <li>androidx.media3:media3-exoplayer-hls</li>
         *    <li>androidx.media3:media3-ui-compose</li>
         *    <li>androidx.media3:media3-session</li>
         * </ul>
         * <p>
         * This bundle was declared in catalog libs.versions.toml
         */
        public Provider<ExternalModuleDependencyBundle> getMedia3() {
            return createBundle("media3");
        }

        /**
         * Dependency bundle provider for <b>paging</b> which contains the following dependencies:
         * <ul>
         *    <li>androidx.paging:paging-runtime</li>
         *    <li>androidx.paging:paging-compose</li>
         * </ul>
         * <p>
         * This bundle was declared in catalog libs.versions.toml
         */
        public Provider<ExternalModuleDependencyBundle> getPaging() {
            return createBundle("paging");
        }

        /**
         * Group of bundles at <b>bundles.androidx</b>
         */
        public AndroidxBundleAccessors getAndroidx() {
            return baccForAndroidxBundleAccessors;
        }

        /**
         * Group of bundles at <b>bundles.wear</b>
         */
        public WearBundleAccessors getWear() {
            return baccForWearBundleAccessors;
        }

    }

    public static class AndroidxBundleAccessors extends BundleFactory {
        private final AndroidxComposeBundleAccessors baccForAndroidxComposeBundleAccessors = new AndroidxComposeBundleAccessors(objects, providers, config, attributesFactory, capabilityNotationParser);
        private final AndroidxGlanceBundleAccessors baccForAndroidxGlanceBundleAccessors = new AndroidxGlanceBundleAccessors(objects, providers, config, attributesFactory, capabilityNotationParser);

        public AndroidxBundleAccessors(ObjectFactory objects, ProviderFactory providers, DefaultVersionCatalog config, AttributesFactory attributesFactory, CapabilityNotationParser capabilityNotationParser) { super(objects, providers, config, attributesFactory, capabilityNotationParser); }

        /**
         * Dependency bundle provider for <b>androidx.test</b> which contains the following dependencies:
         * <ul>
         *    <li>androidx.test:core</li>
         *    <li>androidx.test.ext:junit-ktx</li>
         *    <li>androidx.test:rules</li>
         *    <li>androidx.test:runner</li>
         * </ul>
         * <p>
         * This bundle was declared in catalog libs.versions.toml
         */
        public Provider<ExternalModuleDependencyBundle> getTest() {
            return createBundle("androidx.test");
        }

        /**
         * Group of bundles at <b>bundles.androidx.compose</b>
         */
        public AndroidxComposeBundleAccessors getCompose() {
            return baccForAndroidxComposeBundleAccessors;
        }

        /**
         * Group of bundles at <b>bundles.androidx.glance</b>
         */
        public AndroidxGlanceBundleAccessors getGlance() {
            return baccForAndroidxGlanceBundleAccessors;
        }

    }

    public static class AndroidxComposeBundleAccessors extends BundleFactory {
        private final AndroidxComposeUiBundleAccessors baccForAndroidxComposeUiBundleAccessors = new AndroidxComposeUiBundleAccessors(objects, providers, config, attributesFactory, capabilityNotationParser);

        public AndroidxComposeBundleAccessors(ObjectFactory objects, ProviderFactory providers, DefaultVersionCatalog config, AttributesFactory attributesFactory, CapabilityNotationParser capabilityNotationParser) { super(objects, providers, config, attributesFactory, capabilityNotationParser); }

        /**
         * Group of bundles at <b>bundles.androidx.compose.ui</b>
         */
        public AndroidxComposeUiBundleAccessors getUi() {
            return baccForAndroidxComposeUiBundleAccessors;
        }

    }

    public static class AndroidxComposeUiBundleAccessors extends BundleFactory {

        public AndroidxComposeUiBundleAccessors(ObjectFactory objects, ProviderFactory providers, DefaultVersionCatalog config, AttributesFactory attributesFactory, CapabilityNotationParser capabilityNotationParser) { super(objects, providers, config, attributesFactory, capabilityNotationParser); }

        /**
         * Dependency bundle provider for <b>androidx.compose.ui.test</b> which contains the following dependencies:
         * <ul>
         *    <li>androidx.compose.ui:ui-test-junit4</li>
         *    <li>androidx.compose.ui:ui-test-manifest</li>
         * </ul>
         * <p>
         * This bundle was declared in catalog libs.versions.toml
         */
        public Provider<ExternalModuleDependencyBundle> getTest() {
            return createBundle("androidx.compose.ui.test");
        }

    }

    public static class AndroidxGlanceBundleAccessors extends BundleFactory  implements BundleNotationSupplier{

        public AndroidxGlanceBundleAccessors(ObjectFactory objects, ProviderFactory providers, DefaultVersionCatalog config, AttributesFactory attributesFactory, CapabilityNotationParser capabilityNotationParser) { super(objects, providers, config, attributesFactory, capabilityNotationParser); }

        /**
         * Dependency bundle provider for <b>androidx.glance</b> which contains the following dependencies:
         * <ul>
         *    <li>androidx.glance:glance-appwidget</li>
         *    <li>androidx.glance:glance-appwidget-preview</li>
         *    <li>androidx.glance:glance-material</li>
         *    <li>androidx.glance:glance-preview</li>
         * </ul>
         * <p>
         * This bundle was declared in catalog libs.versions.toml
         */
        public Provider<ExternalModuleDependencyBundle> asProvider() {
            return createBundle("androidx.glance");
        }

        /**
         * Dependency bundle provider for <b>androidx.glance.testing</b> which contains the following dependencies:
         * <ul>
         *    <li>androidx.glance:glance-testing</li>
         *    <li>androidx.glance:glance-appwidget-testing</li>
         * </ul>
         * <p>
         * This bundle was declared in catalog libs.versions.toml
         */
        public Provider<ExternalModuleDependencyBundle> getTesting() {
            return createBundle("androidx.glance.testing");
        }

    }

    public static class WearBundleAccessors extends BundleFactory {

        public WearBundleAccessors(ObjectFactory objects, ProviderFactory providers, DefaultVersionCatalog config, AttributesFactory attributesFactory, CapabilityNotationParser capabilityNotationParser) { super(objects, providers, config, attributesFactory, capabilityNotationParser); }

        /**
         * Dependency bundle provider for <b>wear.tiles</b> which contains the following dependencies:
         * <ul>
         *    <li>androidx.wear.tiles:tiles</li>
         *    <li>androidx.wear.protolayout:protolayout</li>
         *    <li>androidx.wear.protolayout:protolayout-expression</li>
         *    <li>androidx.wear.protolayout:protolayout-material</li>
         * </ul>
         * <p>
         * This bundle was declared in catalog libs.versions.toml
         */
        public Provider<ExternalModuleDependencyBundle> getTiles() {
            return createBundle("wear.tiles");
        }

    }

    public static class PluginAccessors extends PluginFactory {
        private final AndroidPluginAccessors paccForAndroidPluginAccessors = new AndroidPluginAccessors(providers, config);
        private final ComposePluginAccessors paccForComposePluginAccessors = new ComposePluginAccessors(providers, config);
        private final FirebasePluginAccessors paccForFirebasePluginAccessors = new FirebasePluginAccessors(providers, config);
        private final GooglePluginAccessors paccForGooglePluginAccessors = new GooglePluginAccessors(providers, config);
        private final HomeassistantPluginAccessors paccForHomeassistantPluginAccessors = new HomeassistantPluginAccessors(providers, config);
        private final KotlinPluginAccessors paccForKotlinPluginAccessors = new KotlinPluginAccessors(providers, config);

        public PluginAccessors(ProviderFactory providers, DefaultVersionCatalog config) { super(providers, config); }

        /**
         * Plugin provider for <b>hilt</b> with plugin id <b>com.google.dagger.hilt.android</b> and
         * with version reference <b>hilt</b>
         * <p>
         * This plugin was declared in catalog libs.versions.toml
         */
        public Provider<PluginDependency> getHilt() { return createPlugin("hilt"); }

        /**
         * Plugin provider for <b>ksp</b> with plugin id <b>com.google.devtools.ksp</b> and
         * with version reference <b>ksp</b>
         * <p>
         * This plugin was declared in catalog libs.versions.toml
         */
        public Provider<PluginDependency> getKsp() { return createPlugin("ksp"); }

        /**
         * Plugin provider for <b>ktlint</b> with plugin id <b>org.jlleitschuh.gradle.ktlint</b> and
         * with version reference <b>ktlint</b>
         * <p>
         * This plugin was declared in catalog libs.versions.toml
         */
        public Provider<PluginDependency> getKtlint() { return createPlugin("ktlint"); }

        /**
         * Plugin provider for <b>screenshot</b> with plugin id <b>com.android.compose.screenshot</b> and
         * with version reference <b>screenshot</b>
         * <p>
         * This plugin was declared in catalog libs.versions.toml
         */
        public Provider<PluginDependency> getScreenshot() { return createPlugin("screenshot"); }

        /**
         * Group of plugins at <b>plugins.android</b>
         */
        public AndroidPluginAccessors getAndroid() {
            return paccForAndroidPluginAccessors;
        }

        /**
         * Group of plugins at <b>plugins.compose</b>
         */
        public ComposePluginAccessors getCompose() {
            return paccForComposePluginAccessors;
        }

        /**
         * Group of plugins at <b>plugins.firebase</b>
         */
        public FirebasePluginAccessors getFirebase() {
            return paccForFirebasePluginAccessors;
        }

        /**
         * Group of plugins at <b>plugins.google</b>
         */
        public GooglePluginAccessors getGoogle() {
            return paccForGooglePluginAccessors;
        }

        /**
         * Group of plugins at <b>plugins.homeassistant</b>
         */
        public HomeassistantPluginAccessors getHomeassistant() {
            return paccForHomeassistantPluginAccessors;
        }

        /**
         * Group of plugins at <b>plugins.kotlin</b>
         */
        public KotlinPluginAccessors getKotlin() {
            return paccForKotlinPluginAccessors;
        }

    }

    public static class AndroidPluginAccessors extends PluginFactory {

        public AndroidPluginAccessors(ProviderFactory providers, DefaultVersionCatalog config) { super(providers, config); }

        /**
         * Plugin provider for <b>android.application</b> with plugin id <b>com.android.application</b> and
         * with version reference <b>androidGradlePlugin</b>
         * <p>
         * This plugin was declared in catalog libs.versions.toml
         */
        public Provider<PluginDependency> getApplication() { return createPlugin("android.application"); }

        /**
         * Plugin provider for <b>android.library</b> with plugin id <b>com.android.library</b> and
         * with version reference <b>androidGradlePlugin</b>
         * <p>
         * This plugin was declared in catalog libs.versions.toml
         */
        public Provider<PluginDependency> getLibrary() { return createPlugin("android.library"); }

        /**
         * Plugin provider for <b>android.lint</b> with plugin id <b>com.android.lint</b> and
         * with version reference <b>androidGradlePlugin</b>
         * <p>
         * This plugin was declared in catalog libs.versions.toml
         */
        public Provider<PluginDependency> getLint() { return createPlugin("android.lint"); }

    }

    public static class ComposePluginAccessors extends PluginFactory {

        public ComposePluginAccessors(ProviderFactory providers, DefaultVersionCatalog config) { super(providers, config); }

        /**
         * Plugin provider for <b>compose.compiler</b> with plugin id <b>org.jetbrains.kotlin.plugin.compose</b> and
         * with version reference <b>kotlin</b>
         * <p>
         * This plugin was declared in catalog libs.versions.toml
         */
        public Provider<PluginDependency> getCompiler() { return createPlugin("compose.compiler"); }

    }

    public static class FirebasePluginAccessors extends PluginFactory {

        public FirebasePluginAccessors(ProviderFactory providers, DefaultVersionCatalog config) { super(providers, config); }

        /**
         * Plugin provider for <b>firebase.appdistribution</b> with plugin id <b>com.google.firebase.appdistribution</b> and
         * with version reference <b>firebaseAppdistributionGradle</b>
         * <p>
         * This plugin was declared in catalog libs.versions.toml
         */
        public Provider<PluginDependency> getAppdistribution() { return createPlugin("firebase.appdistribution"); }

    }

    public static class GooglePluginAccessors extends PluginFactory {

        public GooglePluginAccessors(ProviderFactory providers, DefaultVersionCatalog config) { super(providers, config); }

        /**
         * Plugin provider for <b>google.services</b> with plugin id <b>com.google.gms.google-services</b> and
         * with version reference <b>googleServices</b>
         * <p>
         * This plugin was declared in catalog libs.versions.toml
         */
        public Provider<PluginDependency> getServices() { return createPlugin("google.services"); }

    }

    public static class HomeassistantPluginAccessors extends PluginFactory {
        private final HomeassistantAndroidPluginAccessors paccForHomeassistantAndroidPluginAccessors = new HomeassistantAndroidPluginAccessors(providers, config);

        public HomeassistantPluginAccessors(ProviderFactory providers, DefaultVersionCatalog config) { super(providers, config); }

        /**
         * Group of plugins at <b>plugins.homeassistant.android</b>
         */
        public HomeassistantAndroidPluginAccessors getAndroid() {
            return paccForHomeassistantAndroidPluginAccessors;
        }

    }

    public static class HomeassistantAndroidPluginAccessors extends PluginFactory {

        public HomeassistantAndroidPluginAccessors(ProviderFactory providers, DefaultVersionCatalog config) { super(providers, config); }

        /**
         * Plugin provider for <b>homeassistant.android.application</b> with plugin id <b>homeassistant.android.application</b> and
         * with <b>no version specified</b>
         * <p>
         * This plugin was declared in catalog libs.versions.toml
         */
        public Provider<PluginDependency> getApplication() { return createPlugin("homeassistant.android.application"); }

        /**
         * Plugin provider for <b>homeassistant.android.common</b> with plugin id <b>homeassistant.android.common</b> and
         * with <b>no version specified</b>
         * <p>
         * This plugin was declared in catalog libs.versions.toml
         */
        public Provider<PluginDependency> getCommon() { return createPlugin("homeassistant.android.common"); }

        /**
         * Plugin provider for <b>homeassistant.android.compose</b> with plugin id <b>homeassistant.android.compose</b> and
         * with <b>no version specified</b>
         * <p>
         * This plugin was declared in catalog libs.versions.toml
         */
        public Provider<PluginDependency> getCompose() { return createPlugin("homeassistant.android.compose"); }

        /**
         * Plugin provider for <b>homeassistant.android.dependencies</b> with plugin id <b>homeassistant.android.dependencies</b> and
         * with <b>no version specified</b>
         * <p>
         * This plugin was declared in catalog libs.versions.toml
         */
        public Provider<PluginDependency> getDependencies() { return createPlugin("homeassistant.android.dependencies"); }

        /**
         * Plugin provider for <b>homeassistant.android.flavor</b> with plugin id <b>homeassistant.android.flavor</b> and
         * with <b>no version specified</b>
         * <p>
         * This plugin was declared in catalog libs.versions.toml
         */
        public Provider<PluginDependency> getFlavor() { return createPlugin("homeassistant.android.flavor"); }

    }

    public static class KotlinPluginAccessors extends PluginFactory {

        public KotlinPluginAccessors(ProviderFactory providers, DefaultVersionCatalog config) { super(providers, config); }

        /**
         * Plugin provider for <b>kotlin.android</b> with plugin id <b>org.jetbrains.kotlin.android</b> and
         * with version reference <b>kotlin</b>
         * <p>
         * This plugin was declared in catalog libs.versions.toml
         */
        public Provider<PluginDependency> getAndroid() { return createPlugin("kotlin.android"); }

        /**
         * Plugin provider for <b>kotlin.parcelize</b> with plugin id <b>org.jetbrains.kotlin.plugin.parcelize</b> and
         * with version reference <b>kotlin</b>
         * <p>
         * This plugin was declared in catalog libs.versions.toml
         */
        public Provider<PluginDependency> getParcelize() { return createPlugin("kotlin.parcelize"); }

        /**
         * Plugin provider for <b>kotlin.serialization</b> with plugin id <b>org.jetbrains.kotlin.plugin.serialization</b> and
         * with version reference <b>kotlin</b>
         * <p>
         * This plugin was declared in catalog libs.versions.toml
         */
        public Provider<PluginDependency> getSerialization() { return createPlugin("kotlin.serialization"); }

    }

}
