<!--
    Please review the contributing guide before submitting: https://developers.home-assistant.io/docs/android/submit
    Please, complete the following sections to help the processing and review of your changes.
    Please, DO NOT DELETE ANY TEXT from this template! (unless instructed).

    Thank you for submitting a Pull Request and helping to improve Home Assistant. You are amazing!
-->

## Summary
<!--
    Provide a brief summary of the changes you have made and most importantly what they aim to achieve.
    Don't forget any links that could be useful to the reader. (Github issues, PRs, documentation, articles, ...)

    * What was the motivation behind this change?
    * What is the impact of the changes on the application?
-->

## Checklist
<!--
    Put an `x` in the boxes that apply. You can also fill these out after
    creating the PR. If you're unsure about any of them, don't hesitate to ask.
    We're here to help! This is simply a reminder of what we are going to look
    for before merging your code.
-->

- [ ] New or updated tests have been added to cover the changes following the testing [guidelines](https://developers.home-assistant.io/docs/android/testing/introduction).
- [ ] The code follows the project's [code style](https://developers.home-assistant.io/docs/android/codestyle) and [best_practices](https://developers.home-assistant.io/docs/android/best_practices).
- [ ] The changes have been thoroughly tested, and edge cases have been considered.
- [ ] Changes are backward compatible whenever feasible. Any breaking changes are documented in the changelog for users and/or in the code for developers depending on the relevance.

## Screenshots
<!--
    If this is a user-facing change not in the frontend, please include screenshots in light and dark mode.

    Note: Remove this section if there are no screenshots.
-->

## Link to pull request in documentation repositories
<!-- 
    This pull request introduces, changes, or removes user-facing functionality.
    A corresponding update to the Companion App documentation in the documentation repository (https://github.com/home-assistant/companion.home-assistant) is required.

    Instructions:
    1. Create a pull request in the documentation repository.
    2. Add the documentation pull request number after the "#" below.
    3. Add the `<span class='beta'>BETA</span> ` flag in the documentation to mark it as such.

    Note: Remove this section if there is no PR.
-->
User Documentation: home-assistant/companion.home-assistant#

<!-- 
    This pull request introduces, changes, or removes developer-facing functionality.
    A corresponding update to the Developer documentation in the documentation repository (https://github.com/home-assistant/developers.home-assistant) is required.

    Instructions:
    1. Create a pull request in the documentation repository.
    2. Add the documentation pull request number after the "#" below.

    Note: Remove this section if there is no PR.
-->
Developer Documentation: home-assistant/developers.home-assistant#

## Any other notes
<!-- 
    If there is any other information of note, like if this Pull Request is part of a bigger change, please include it here.
-->