/// <reference types="node" />
import chokidar from "chokidar";
import fs from "fs-extra";
import { PhraseyBuilderOptions } from "./builder";
import { Phrasey, PhraseyOptions } from "./phrasey";
import { PhraseyState } from "./state";
export interface PhraseyWatcherOptions {
    phrasey: PhraseyOptions;
    builder: PhraseyBuilderOptions;
    watcher: {
        buildAllTranslations?: boolean;
    };
}
export interface PhraseyWatcherCompleteListener {
    onConfigChange(): Promise<void>;
    onLocalesChange(): Promise<void>;
    onSchemaChange(): Promise<void>;
    onTranslationsChange(): Promise<void>;
    onTranslationChange(path: string): Promise<void>;
    onError(error: Error): Promise<void>;
}
export type PhraseyWatcherListener = Partial<PhraseyWatcherCompleteListener>;
export type PhraseyChokidarWatcherListener = (eventName: "add" | "addDir" | "change" | "unlink" | "unlinkDir", path: string, stats?: fs.Stats) => void;
export declare class PhraseyWatcher {
    options: PhraseyWatcherOptions;
    listeners: PhraseyWatcherListener[];
    phrasey: Phrasey;
    state: PhraseyState;
    configWatcher?: chokidar.FSWatcher;
    localesWatcher?: chokidar.FSWatcher;
    schemaWatcher?: chokidar.FSWatcher;
    translationsWatcher?: chokidar.FSWatcher;
    constructor(options: PhraseyWatcherOptions);
    initialize(): Promise<void>;
    updateConfig(): Promise<void>;
    updateLocales(): Promise<void>;
    updateSchema(): Promise<void>;
    updateTranslations(): Promise<void>;
    updateTranslation(path: string): Promise<void>;
    onConfigChange(): Promise<void>;
    onLocalesChange(): Promise<void>;
    onSchemaChange(): Promise<void>;
    onTranslationsChange(): Promise<void>;
    onTranslationChange(path: string): Promise<void>;
    onError(error: Error): Promise<void>;
    destroy(): Promise<void>;
    listen(listener: PhraseyWatcherListener): () => void;
    unlisten(listener: PhraseyWatcherListener): void;
    dispatch(apply: (listener: PhraseyWatcherListener) => Promise<void>): Promise<void>;
    get log(): import("./logger").PhraseyLogger;
    static create(options: PhraseyWatcherOptions): Promise<PhraseyWatcher>;
    static createWatcher(path: string | string[], listener: PhraseyChokidarWatcherListener): chokidar.FSWatcher;
}
