import { PhraseyResult } from "./result";
export declare const PhraseyVersion: any;
export declare const PhraseyIdentifierRegex: RegExp;
export interface PhraseyTreeLikeOptions<T> {
    map?: (value: T) => string;
    prefix?: string;
    symbolPostMap?: (symbol: string) => string;
}
export declare const PhraseyTreeLike: {
    LR: string;
    TBR: string;
    TR: string;
    build: <T>(data: T | T[], { map, prefix, symbolPostMap }?: PhraseyTreeLikeOptions<T>) => string;
    tab: (count: number) => string;
    spacify: (text: string) => string;
};
export declare const PhraseySafeResolvePackage: (packageName: string) => any;
export declare class PhraseyUtils {
    static parseStringArrayNullable(data?: string | string[] | null): string[];
    static equals(a: unknown, b: unknown): boolean;
    static _arrayEquals(a: unknown[], b: unknown[]): boolean;
    static _objectEquals(a: object, b: object): boolean;
}
export type PhraseyPipelineTask<T = true> = () => Promise<PhraseyResult<T, Error | Error[]>>;
export interface PhraseyPipeline<T = true> {
    execute: () => Promise<PhraseyResult<T, Error | Error[]>>;
}
export declare class PhraseyBuildablePipeline implements PhraseyPipeline {
    tasks: PhraseyPipelineTask[];
    add(task: PhraseyPipelineTask): void;
    build(): PhraseyPipeline;
    buildWithOutput<T>(output: PhraseyPipelineTask<T>): PhraseyPipeline<T>;
    execute(): Promise<PhraseyResult<true, Error | Error[]>>;
    static executeTask<T>(task: PhraseyPipelineTask<T>): Promise<PhraseyResult<T, Error | Error[]>>;
}
