import { PhraseyContentFormatter } from "./contentFormats";
import { PhraseyLocales } from "./locales";
import { PhraseyResult } from "./result";
import { PhraseySchema } from "./schema";
import { PhraseyTranslation, PhraseyTranslationStringValue } from "./translation";
export declare class PhraseyTranslations {
    schema: PhraseySchema;
    translations: Map<string, PhraseyTranslation>;
    pathCodes: Map<string, string>;
    constructor(schema: PhraseySchema);
    load(path: string, formatter: PhraseyContentFormatter, locales: PhraseyLocales, globalFallback: string[]): Promise<PhraseyResult<string, Error>>;
    ensure(translation: PhraseyTranslation): PhraseyResult<true, Error>;
    values(): IterableIterator<PhraseyTranslation>;
    static resolveFallbackKey(translations: PhraseyTranslation[], key: string): PhraseyTranslationStringValue | undefined;
    static normalizePath(path: string): string;
}
