"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhraseySummary = void 0;
class PhraseySummary {
    options;
    fullStats = {
        keysCount: 0,
        setCount: 0,
        fallbackCount: 0,
        unsetCount: 0,
        total: 0,
    };
    individualStats = new Map();
    constructor(options) {
        this.options = options;
        this.fullStats.keysCount = options.keysCount;
    }
    add(translation) {
        this.individualStats.set(translation.locale.code, translation.stats);
        this.fullStats.setCount += translation.stats.setCount;
        this.fullStats.fallbackCount += translation.stats.fallbackCount;
        this.fullStats.unsetCount += translation.stats.unsetCount;
        this.fullStats.total += translation.stats.total;
    }
    json() {
        const individual = {};
        for (const [locale, stats] of this.individualStats.entries()) {
            individual[locale] = stats.json();
        }
        return {
            full: this.fullStats,
            individual,
        };
    }
}
exports.PhraseySummary = PhraseySummary;
