import { PhraseyTranslation, PhraseyTranslationStats, PhraseyTranslationStatsJson } from "./translation";
export interface PhraseySummaryOptions {
    keysCount: number;
}
export interface PhraseySummaryJsonTotalStats {
    keysCount: number;
    setCount: number;
    fallbackCount: number;
    unsetCount: number;
    total: number;
}
export interface PhraseySummaryJson {
    full: PhraseySummaryJsonTotalStats;
    individual: Record<string, PhraseyTranslationStatsJson>;
}
export declare class PhraseySummary {
    options: PhraseySummaryOptions;
    fullStats: PhraseySummaryJsonTotalStats;
    individualStats: Map<string, PhraseyTranslationStats>;
    constructor(options: PhraseySummaryOptions);
    add(translation: PhraseyTranslation): void;
    json(): PhraseySummaryJson;
}
