import { PhraseyResult } from "./result";
import { PhraseyZSchemaKeyType, PhraseyZSchemaType } from "./z";
export interface PhraseySchemaJson {
    z: PhraseyZSchemaType;
    keys: Record<string, PhraseyZSchemaKeyType>;
}
export declare class PhraseySchema {
    z: PhraseyZSchemaType;
    keys: Map<string, {
        name: string;
        description?: string | undefined;
        parameters?: string[] | undefined;
    }>;
    constructor(z: PhraseyZSchemaType);
    init(): void;
    key(name: string): {
        name: string;
        description?: string | undefined;
        parameters?: string[] | undefined;
    };
    keysCount(): number;
    json(): PhraseySchemaJson;
    static create(path: string, format: string): Promise<PhraseyResult<PhraseySchema, Error>>;
}
