"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhraseyHooks = void 0;
/* eslint-disable @typescript-eslint/ban-types */
const errors_1 = require("./errors");
class PhraseyHooks {
    phrasey;
    handlers = [];
    constructor(phrasey) {
        this.phrasey = phrasey;
    }
    addHandlerFile(path, 
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    options) {
        try {
            // eslint-disable-next-line @typescript-eslint/no-var-requires
            const handler = require(path);
            this.addHandler({ path, options, handler });
            return { success: true, data: true };
        }
        catch (error) {
            return {
                success: false,
                error: new errors_1.PhraseyError(`Could not import hooks handler file "${path}"`, { cause: error }),
            };
        }
    }
    addHandler(handler) {
        this.handlers.push(handler);
        return () => this.removeHandler(handler);
    }
    removeHandler(handler) {
        this.handlers = this.handlers.filter((x) => x !== handler);
    }
    async dispatch(event, state, data) {
        const phrasey = this.phrasey;
        const log = this.phrasey.log.inherit(`hooks:${event}`);
        for (const { path, options, handler } of this.handlers) {
            const fn = handler[event];
            if (typeof fn === "function") {
                const ctx = Object.assign({ phrasey, state, log, options }, data);
                try {
                    await fn(ctx);
                }
                catch (error) {
                    const rpath = this.phrasey.rpath(path);
                    return {
                        success: false,
                        error: new errors_1.PhraseyError(`Hook "${rpath}" handling "${event}" failed.`, { cause: error }),
                    };
                }
            }
        }
        return { success: true, data: true };
    }
}
exports.PhraseyHooks = PhraseyHooks;
