import { PhraseyLogger } from "./logger";
import { Phrasey } from "./phrasey";
import { PhraseyResult } from "./result";
import { PhraseyState } from "./state";
export type PhraseyHooksContext<T extends {}> = {
    phrasey: Phrasey;
    state: PhraseyState;
    log: PhraseyLogger;
    options: Record<string, any>;
} & T;
export interface PhraseyHooksEvents {
    onCreated: {};
    beforeLocalesParsing: {};
    onLocalesParsed: {};
    beforeSchemaParsing: {};
    onSchemaParsed: {};
    beforeTranslationsParsing: {};
    beforeTranslationParsing: {
        path: string;
    };
    onTranslationParsed: {
        locale: string;
    };
    onTranslationsParsed: {};
    beforeTranslationsEnsuring: {};
    beforeTranslationEnsuring: {
        locale: string;
    };
    onTranslationEnsured: {
        locale: string;
    };
    onTranslationsEnsured: {};
    beforeTranslationsBuilding: {};
    beforeTranslationBuilding: {
        locale: string;
    };
    onTranslationBuildFinished: {
        locale: string;
    };
    onTranslationsBuildFinished: {};
}
export type PhraseyHooksEvent = keyof PhraseyHooksEvents;
export type PhraseyHooksEventContext<Event extends PhraseyHooksEvent> = PhraseyHooksContext<PhraseyHooksEvents[Event]>;
export type PhraseyHooksHandler = {
    [Event in PhraseyHooksEvent]?: (ctx: PhraseyHooksEventContext<Event>) => Promise<void>;
};
export interface PhraseyHooksAttachedHandler {
    path: string;
    options: Record<string, any>;
    handler: PhraseyHooksHandler;
}
export declare class PhraseyHooks {
    phrasey: Phrasey;
    handlers: PhraseyHooksAttachedHandler[];
    constructor(phrasey: Phrasey);
    addHandlerFile(path: string, options: Record<string, any>): PhraseyResult<true, Error>;
    addHandler(handler: PhraseyHooksAttachedHandler): () => void;
    removeHandler(handler: PhraseyHooksAttachedHandler): void;
    dispatch<Event extends PhraseyHooksEvent>(event: Event, state: PhraseyState, data: PhraseyHooksEvents[Event]): Promise<PhraseyResult<true, Error>>;
}
