"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhraseyConfig = void 0;
const contentFormats_1 = require("./contentFormats");
const transformer_1 = require("./transformer");
const z_1 = require("./z");
class PhraseyConfig {
    z;
    constructor(z) {
        this.z = z;
    }
    json() {
        return this;
    }
    static async create(path, format) {
        const z = await transformer_1.PhraseyTransformer.transform(path, contentFormats_1.PhraseyContentFormats.resolve(format), z_1.PhraseyZConfig);
        if (!z.success)
            return z;
        const config = new PhraseyConfig(z.data);
        return { success: true, data: config };
    }
}
exports.PhraseyConfig = PhraseyConfig;
